/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AsymmetricBindingBuilder
extends BindingBuilder {
    private static final Logger LOGGER = LogManager.getLogger(AsymmetricBindingBuilder.class);
    private static final Logger TIME_LOGGER = LogManager.getLogger((String)"org.apache.rampart.TIME");
    private WSSecEncryptedKey encrKey;
    private String encryptedKeyId;
    private byte[] encryptedKeyValue;
    private final List<byte[]> signatureValues = new ArrayList<byte[]>();
    private Element encrTokenElement;
    private Element sigDKTElement;
    private Element encrDKTElement;
    private List<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
    private Element signatureElement;
    private Element refList;

    public void build(RampartMessageData rmd) throws RampartException {
        LOGGER.debug("AsymmetricBindingBuilder build invoked");
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (RampartUtil.encryptFirst(rpd)) {
            this.doEncryptBeforeSig(rmd);
        } else {
            this.doSignBeforeEncrypt(rmd);
        }
        LOGGER.debug("AsymmetricBindingBuilder build invoked : DONE");
    }

    private void doEncryptBeforeSig(RampartMessageData rmd) throws RampartException {
        long t0 = System.currentTimeMillis();
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        RampartConfig config = rpd.getRampartConfig();
        Element encrDKTokenElem = null;
        WSSecEncrypt encr = null;
        this.refList = null;
        WSSecDKEncrypt dkEncr = null;
        Token encryptionToken = null;
        encryptionToken = rmd.isInitiator() ? rpd.getRecipientToken() : rpd.getInitiatorToken();
        List<WSEncryptionPart> encrParts = RampartUtil.getEncryptedParts(rmd);
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (encryptionToken == null && encrParts.size() > 0) {
            throw new RampartException("encryptionTokenMissing");
        }
        if (encryptionToken != null && encrParts.size() > 0) {
            if (rpd.getRampartConfig() == null) {
                throw new RampartException("rampartConigMissing");
            }
            if (encryptionToken.isDerivedKeys()) {
                try {
                    this.setupEncryptedKey(rmd, encryptionToken);
                    dkEncr = new WSSecDKEncrypt();
                    dkEncr.setParts(encrParts);
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setDerivedKeyLength(rpd.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    this.encrDKTElement = dkEncr.getdktElement();
                    encrDKTokenElem = RampartUtil.appendChildToSecHeader(rmd, this.encrDKTElement);
                    this.refList = dkEncr.encryptForExternalRef(null, encrParts);
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorCreatingEncryptedKey", e);
                }
                catch (ConversationException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                encr = new WSSecEncrypt();
                encr.setParts(encrParts);
                encr.setWsConfig(rmd.getConfig());
                encr.setDocument(doc);
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
                RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, encryptionToken);
                encr.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(config, rmd.getCustomClassLoader()));
                Element bstElem = encr.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                this.encrTokenElement = encr.getEncryptedKeyElement();
                this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
                this.refList = encr.encryptForRef(null, encrParts);
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
            this.refList = RampartUtil.appendChildToSecHeader(rmd, this.refList);
            long t1 = System.currentTimeMillis();
            this.setInsertionLocation(this.encrTokenElement);
            RampartUtil.handleEncryptedSignedHeaders(encrParts, this.sigParts, doc);
            Map<Token, Object> sigSuppTokMap = null;
            Map<Token, Object> endSuppTokMap = null;
            Map<Token, Object> sgndEndSuppTokMap = null;
            Map<Token, Object> sgndEncSuppTokMap = null;
            Map<Token, Object> endEncSuppTokMap = null;
            Map<Token, Object> sgndEndEncSuppTokMap = null;
            if (this.timestampElement != null) {
                this.sigParts.add(RampartUtil.createEncryptionPart("Timestamp", RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
            }
            if (rmd.isInitiator()) {
                SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
                sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
                SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
                endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
                SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
                sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
                SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
                sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
                SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
                endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
                SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
                sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
                List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
                for (SupportingToken supportingTok : supportingToks) {
                    this.handleSupportingTokens(rmd, supportingTok);
                }
                SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
                this.handleSupportingTokens(rmd, encryptedSupportingToks);
                this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
                this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
            } else {
                this.addSignatureConfirmation(rmd, this.sigParts);
            }
            if (this.sigParts.size() > 0 && rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null) {
                this.doSignature(rmd);
            }
            if (rmd.isInitiator()) {
                if (endSuppTokMap != null) {
                    endSuppTokMap.putAll(endEncSuppTokMap);
                }
                List<byte[]> endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
                this.signatureValues.addAll(endSigVals);
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
                List<byte[]> sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
                this.signatureValues.addAll(sigEndSigVals);
            }
            long t2 = System.currentTimeMillis();
            TIME_LOGGER.debug("Encryption took: {}, Signature took: {}", new Supplier[]{() -> t1 - t0, () -> t2 - t1});
            if (rpd.isSignatureProtection() && this.mainSigId != null) {
                long t3 = System.currentTimeMillis();
                ArrayList<WSEncryptionPart> secondEncrParts = new ArrayList<WSEncryptionPart>();
                secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                if (rmd.isInitiator()) {
                    for (String anEncryptedTokensIdList : this.encryptedTokensIdList) {
                        secondEncrParts.add(new WSEncryptionPart(anEncryptedTokensIdList, "Element"));
                    }
                }
                Element secondRefList = null;
                if (encryptionToken.isDerivedKeys()) {
                    try {
                        secondRefList = dkEncr.encryptForExternalRef(null, secondEncrParts);
                        RampartUtil.insertSiblingAfter(rmd, encrDKTokenElem, secondRefList);
                    }
                    catch (WSSecurityException e) {
                        throw new RampartException("errorCreatingEncryptedKey", e);
                    }
                }
                try {
                    secondRefList = encr.encryptForRef(null, secondEncrParts);
                    this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, secondRefList));
                }
                catch (WSSecurityException e) {
                    throw new RampartException("errorInEncryption", e);
                }
                long t4 = System.currentTimeMillis();
                TIME_LOGGER.debug("Signature protection took: {}", new Supplier[]{() -> t4 - t3});
            }
        }
    }

    private void doSignBeforeEncrypt(RampartMessageData rmd) throws RampartException {
        Token encrToken;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        Map<Token, Object> sigSuppTokMap = null;
        Map<Token, Object> endSuppTokMap = null;
        Map<Token, Object> sgndEndSuppTokMap = null;
        Map<Token, Object> sgndEncSuppTokMap = null;
        Map<Token, Object> endEncSuppTokMap = null;
        Map<Token, Object> sgndEndEncSuppTokMap = null;
        this.sigParts = RampartUtil.getSignedParts(rmd);
        if (this.timestampElement != null) {
            this.sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.timestampElement)));
        } else {
            this.setInsertionLocation(null);
        }
        long t0 = System.currentTimeMillis();
        if (rmd.isInitiator()) {
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            sigSuppTokMap = this.handleSupportingTokens(rmd, sgndSuppTokens);
            SupportingToken endSuppTokens = rpd.getEndorsingSupportingTokens();
            endSuppTokMap = this.handleSupportingTokens(rmd, endSuppTokens);
            SupportingToken sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens();
            sgndEndSuppTokMap = this.handleSupportingTokens(rmd, sgndEndSuppTokens);
            SupportingToken sgndEncryptedSuppTokens = rpd.getSignedEncryptedSupportingTokens();
            sgndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEncryptedSuppTokens);
            SupportingToken endorsingEncryptedSuppTokens = rpd.getEndorsingEncryptedSupportingTokens();
            endEncSuppTokMap = this.handleSupportingTokens(rmd, endorsingEncryptedSuppTokens);
            SupportingToken sgndEndEncSuppTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            sgndEndEncSuppTokMap = this.handleSupportingTokens(rmd, sgndEndEncSuppTokens);
            List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
            for (SupportingToken supportingTok : supportingToks) {
                this.handleSupportingTokens(rmd, supportingTok);
            }
            SupportingToken encryptedSupportingToks = rpd.getEncryptedSupportingTokens();
            this.handleSupportingTokens(rmd, encryptedSupportingToks);
            this.sigParts = this.addSignatureParts(sigSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEncSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndSuppTokMap, this.sigParts);
            this.sigParts = this.addSignatureParts(sgndEndEncSuppTokMap, this.sigParts);
        } else {
            this.addSignatureConfirmation(rmd, this.sigParts);
        }
        if (this.sigParts.size() > 0 && (rmd.isInitiator() && rpd.getInitiatorToken() != null || !rmd.isInitiator() && rpd.getRecipientToken() != null)) {
            this.doSignature(rmd);
        }
        List<SupportingPolicyData> supportingToks = rpd.getSupportingPolicyData();
        for (SupportingPolicyData policyData : supportingToks) {
            List<WSEncryptionPart> supportingSigParts;
            if (policyData == null || (supportingSigParts = RampartUtil.getSupportingSignedParts(rmd, policyData)).size() <= 0 || (!rmd.isInitiator() || rpd.getInitiatorToken() == null) && (rmd.isInitiator() || rpd.getRecipientToken() == null)) continue;
            this.doSupportingSignature(rmd, supportingSigParts, policyData);
        }
        if (rmd.isInitiator()) {
            if (endSuppTokMap != null) {
                endSuppTokMap.putAll(endEncSuppTokMap);
            }
            List<byte[]> endSigVals = this.doEndorsedSignatures(rmd, endSuppTokMap);
            this.signatureValues.addAll(endSigVals);
            if (sgndEndSuppTokMap != null) {
                sgndEndSuppTokMap.putAll(sgndEndEncSuppTokMap);
            }
            List<byte[]> sigEndSigVals = this.doEndorsedSignatures(rmd, sgndEndSuppTokMap);
            this.signatureValues.addAll(sigEndSigVals);
        }
        long t1 = System.currentTimeMillis();
        List<WSEncryptionPart> encrParts = RampartUtil.getEncryptedParts(rmd);
        if (rpd.isSignatureProtection() && this.mainSigId != null) {
            encrParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)this.signatureElement), "Element"));
        }
        if (rmd.isInitiator()) {
            for (String anEncryptedTokensIdList : this.encryptedTokensIdList) {
                encrParts.add(new WSEncryptionPart(anEncryptedTokensIdList, "Element"));
            }
        }
        if ((encrToken = rmd.isInitiator() ? rpd.getRecipientToken() : rpd.getInitiatorToken()) != null && encrParts.size() > 0) {
            Element refList = null;
            AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                    if (this.encrKey == null) {
                        this.setupEncryptedKey(rmd, encrToken);
                    }
                    dkEncr.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
                    dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    dkEncr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    dkEncr.setDerivedKeyLength(algorithmSuite.getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare(doc);
                    this.encrDKTElement = this.encrTokenElement != null ? RampartUtil.insertSiblingAfter(rmd, this.encrTokenElement, dkEncr.getdktElement()) : RampartUtil.insertSiblingBefore(rmd, this.sigDKTElement, dkEncr.getdktElement());
                    refList = dkEncr.encryptForExternalRef(null, encrParts);
                    RampartUtil.insertSiblingAfter(rmd, this.encrDKTElement, refList);
                }
                catch (WSSecurityException | ConversationException e) {
                    throw new RampartException("errorInDKEncr", e);
                }
            }
            try {
                WSSecEncrypt encr = new WSSecEncrypt();
                RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, encrToken);
                encr.setWsConfig(rmd.getConfig());
                encr.setDocument(doc);
                RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr);
                encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                encr.setKeyEncAlgo(algorithmSuite.getAsymmetricKeyWrap());
                encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
                if (this.timestampElement != null) {
                    this.setInsertionLocation(this.timestampElement);
                } else {
                    this.setInsertionLocation(null);
                }
                if (encr.getBSTTokenId() != null) {
                    this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encr.getBinarySecurityTokenElement()));
                }
                Element encryptedKeyElement = encr.getEncryptedKeyElement();
                refList = encr.encryptForRef(null, encrParts);
                encryptedKeyElement.appendChild(refList);
                this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encryptedKeyElement));
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInEncryption", e);
            }
        }
        List<SupportingPolicyData> supportingTokens = rpd.getSupportingPolicyData();
        for (SupportingPolicyData policyData : supportingTokens) {
            if (policyData == null) continue;
            Token supportingEncrToken = policyData.getEncryptionToken();
            List<WSEncryptionPart> supoortingEncrParts = RampartUtil.getSupportingEncryptedParts(rmd, policyData);
            if (supportingEncrToken == null || supoortingEncrParts.size() <= 0) continue;
            this.doEncryptionWithSupportingToken(rpd, rmd, supportingEncrToken, doc, supoortingEncrParts);
        }
        long t2 = System.currentTimeMillis();
        TIME_LOGGER.debug("Signature took: {}, Encryption took: {}", new Supplier[]{() -> t1 - t0, () -> t2 - t1});
    }

    private void doSupportingSignature(RampartMessageData rmd, List<WSEncryptionPart> supportingSigParts, SupportingPolicyData supportingData) throws RampartException {
        long t0 = System.currentTimeMillis();
        Token supportingSigToken = supportingData.getSignatureToken();
        if (!(supportingSigToken instanceof X509Token)) {
            return;
        }
        WSSecSignature supportingSig = this.getSignatureBuilder(rmd, supportingSigToken, ((X509Token)supportingSigToken).getUserCertAlias());
        Element bstElem = supportingSig.getBinarySecurityTokenElement();
        if (bstElem != null) {
            bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
            this.setInsertionLocation(bstElem);
        }
        if (rmd.getPolicyData().isTokenProtection() && supportingSig.getBSTTokenId() != null) {
            supportingSigParts.add(new WSEncryptionPart(supportingSig.getBSTTokenId()));
        }
        try {
            supportingSig.setDigestAlgo(rmd.getPolicyData().getAlgorithmSuite().getDigest());
            List referenceList = supportingSig.addReferencesToSign(supportingSigParts, rmd.getSecHeader());
            supportingSig.computeSignature(referenceList, false, this.getInsertionLocation());
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
        this.signatureValues.add(supportingSig.getSignatureValue());
        long t1 = System.currentTimeMillis();
        TIME_LOGGER.debug("Signature took: {}", new Supplier[]{() -> t1 - t0});
    }

    private void doSignature(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        long t0 = System.currentTimeMillis();
        Token sigToken = rmd.isInitiator() ? rpd.getInitiatorToken() : rpd.getRecipientToken();
        if (sigToken.isDerivedKeys()) {
            if (this.encrKey == null) {
                this.setupEncryptedKey(rmd, sigToken);
            }
            WSSecDKSign dkSign = new WSSecDKSign();
            dkSign.setExternalKey(this.encryptedKeyValue, this.encryptedKeyId);
            dkSign.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
            dkSign.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            try {
                dkSign.prepare(doc, rmd.getSecHeader());
                if (rpd.isTokenProtection()) {
                    this.sigParts.add(new WSEncryptionPart(this.encrKey.getId()));
                }
                dkSign.setParts(this.sigParts);
                List referenceList = dkSign.addReferencesToSign(this.sigParts, rmd.getSecHeader());
                if (this.refList == null) {
                    this.sigDKTElement = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), dkSign.getdktElement());
                    this.setInsertionLocation(this.sigDKTElement);
                    dkSign.computeSignature(referenceList, false, this.getInsertionLocation());
                } else {
                    this.sigDKTElement = RampartUtil.insertSiblingBefore(rmd, this.refList, dkSign.getdktElement());
                    this.setInsertionLocation(this.sigDKTElement);
                    dkSign.computeSignature(referenceList, true, this.getInsertionLocation());
                }
                if (RampartUtil.encryptFirst(rpd)) {
                    this.setInsertionLocation(dkSign.getSignatureElement());
                } else {
                    this.setInsertionLocation(this.timestampElement);
                }
                this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)dkSign.getSignatureElement());
                this.signatureValues.add(dkSign.getSignatureValue());
                this.signatureElement = dkSign.getSignatureElement();
            }
            catch (WSSecurityException | ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        WSSecSignature sig = this.getSignatureBuilder(rmd, sigToken);
        Element bstElem = sig.getBinarySecurityTokenElement();
        if (bstElem != null) {
            bstElem = RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), bstElem);
            this.setInsertionLocation(bstElem);
        }
        if (rmd.getPolicyData().isTokenProtection() && sig.getBSTTokenId() != null) {
            this.sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
        }
        try {
            sig.setDigestAlgo(rpd.getAlgorithmSuite().getDigest());
            List referenceList = sig.addReferencesToSign(this.sigParts, rmd.getSecHeader());
            if (this.refList == null) {
                sig.computeSignature(referenceList, false, this.getInsertionLocation());
            } else {
                sig.computeSignature(referenceList, true, this.refList);
            }
            this.signatureElement = sig.getSignatureElement();
            this.setInsertionLocation(this.signatureElement);
            this.mainSigId = RampartUtil.addWsuIdToElement((OMElement)this.signatureElement);
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
        this.signatureValues.add(sig.getSignatureValue());
        long t1 = System.currentTimeMillis();
        TIME_LOGGER.debug("Signature took: {}", new Supplier[]{() -> t1 - t0});
    }

    private void doEncryptionWithSupportingToken(RampartPolicyData rpd, RampartMessageData rmd, Token encrToken, Document doc, List<WSEncryptionPart> encrParts) throws RampartException {
        Element refList = null;
        try {
            if (!(encrToken instanceof X509Token)) {
                return;
            }
            WSSecEncrypt encr = new WSSecEncrypt();
            RampartUtil.setKeyIdentifierType(rmd, (WSSecBase)encr, encrToken);
            encr.setWsConfig(rmd.getConfig());
            encr.setDocument(doc);
            RampartUtil.setEncryptionUser(rmd, (WSSecEncryptedKey)encr, ((X509Token)encrToken).getEncryptionUser());
            encr.setSymmetricEncAlgorithm(rpd.getAlgorithmSuite().getEncryption());
            encr.setKeyEncAlgo(rpd.getAlgorithmSuite().getAsymmetricKeyWrap());
            encr.prepare(doc, RampartUtil.getEncryptionCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            if (this.timestampElement != null) {
                this.setInsertionLocation(this.timestampElement);
            } else {
                this.setInsertionLocation(null);
            }
            if (encr.getBSTTokenId() != null) {
                this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encr.getBinarySecurityTokenElement()));
            }
            Element encryptedKeyElement = encr.getEncryptedKeyElement();
            refList = encr.encryptForRef(null, encrParts);
            encryptedKeyElement.appendChild(refList);
            this.setInsertionLocation(RampartUtil.insertSiblingAfterOrPrepend(rmd, this.getInsertionLocation(), encryptedKeyElement));
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInEncryption", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        if (!rmd.isInitiator() && token.isDerivedKeys()) {
            if (this.encryptedKeyId != null && this.encryptedKeyValue != null) {
                return;
            }
            List resultsObj = (List)rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            this.encryptedKeyId = RampartUtil.getRequestEncryptedKeyId(resultsObj);
            this.encryptedKeyValue = RampartUtil.getRequestEncryptedKeyValue(resultsObj);
            if (this.encryptedKeyId != null || this.encryptedKeyValue != null) return;
            this.createEncryptedKey(rmd, token);
            return;
        } else {
            this.createEncryptedKey(rmd, token);
        }
    }

    private void createEncryptedKey(RampartMessageData rmd, Token token) throws RampartException {
        this.encrKey = this.getEncryptedKeyBuilder(rmd, token);
        Element bstElem = this.encrKey.getBinarySecurityTokenElement();
        if (bstElem != null) {
            RampartUtil.appendChildToSecHeader(rmd, bstElem);
        }
        this.encrTokenElement = this.encrKey.getEncryptedKeyElement();
        this.encrTokenElement = RampartUtil.appendChildToSecHeader(rmd, this.encrTokenElement);
        this.encryptedKeyValue = this.encrKey.getEphemeralKey();
        this.encryptedKeyId = this.encrKey.getId();
        try {
            org.apache.rahas.Token tok = new org.apache.rahas.Token(this.encryptedKeyId, (OMElement)this.encrTokenElement, null, null);
            tok.setSecret(this.encryptedKeyValue);
            rmd.getTokenStorage().add(tok);
        }
        catch (TrustException e) {
            throw new RampartException("errorInAddingTokenIntoStore", e);
        }
    }
}

