/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Header;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.KerberosToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransportBindingBuilder
extends BindingBuilder {
    private static final Logger LOGGER = LogManager.getLogger(TransportBindingBuilder.class);
    private static final Logger TIME_LOGGER = LogManager.getLogger((String)"org.apache.rampart.TIME");

    public void build(RampartMessageData rmd) throws RampartException {
        LOGGER.debug("TransportBindingBuilder build invoked");
        long t0 = System.currentTimeMillis();
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd.isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (rmd.isInitiator()) {
            SupportingToken endSupptokens;
            SupportingToken sgndEndSuppTokens;
            ArrayList<byte[]> signatureValues = new ArrayList<byte[]>();
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            if (sgndSuppTokens != null && sgndSuppTokens.getTokens() != null && sgndSuppTokens.getTokens().size() > 0) {
                LOGGER.debug("Processing signed supporting tokens");
                List tokens = sgndSuppTokens.getTokens();
                for (Token token : tokens) {
                    if (token instanceof UsernameToken) {
                        WSSecUsernameToken utBuilder = this.addUsernameToken(rmd, (UsernameToken)token);
                        utBuilder.prepare(rmd.getDocument());
                        utBuilder.appendToHeader(rmd.getSecHeader());
                        continue;
                    }
                    throw new RampartException("unsupportedSignedSupportingToken", new String[]{"{" + token.getName().getNamespaceURI() + "}" + token.getName().getLocalPart()});
                }
            }
            if ((sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens()) != null && sgndEndSuppTokens.getTokens() != null && sgndEndSuppTokens.getTokens().size() > 0) {
                LOGGER.debug("Processing endorsing signed supporting tokens");
                List tokens = sgndEndSuppTokens.getTokens();
                SignedEncryptedParts signdParts = sgndEndSuppTokens.getSignedParts();
                for (Token token : tokens) {
                    if (token instanceof IssuedToken && rmd.isInitiator()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (!(token instanceof X509Token)) continue;
                    signatureValues.add(this.doX509TokenSignature(rmd, token, signdParts));
                }
            }
            if ((endSupptokens = rpd.getEndorsingSupportingTokens()) != null && endSupptokens.getTokens() != null && endSupptokens.getTokens().size() > 0) {
                LOGGER.debug("Processing endorsing supporting tokens");
                List tokens = endSupptokens.getTokens();
                SignedEncryptedParts signdParts = endSupptokens.getSignedParts();
                for (Token token : tokens) {
                    if (token instanceof IssuedToken && rmd.isInitiator()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (token instanceof X509Token) {
                        signatureValues.add(this.doX509TokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (token instanceof SecureConversationToken) {
                        this.handleSecureConversationTokens(rmd, (SecureConversationToken)token);
                        signatureValues.add(this.doSecureConversationSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (!(token instanceof KerberosToken)) continue;
                    signatureValues.add(this.doKerberosTokenSignature(rmd, (KerberosToken)token, signdParts));
                }
            }
            List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
            for (SupportingToken supportingTok : supportingToks) {
                this.handleSupportingTokens(rmd, supportingTok);
            }
            rmd.getMsgContext().setProperty("_sendSignatureValues_", signatureValues);
        } else {
            this.addSignatureConfirmation(rmd, null);
        }
        long t1 = System.currentTimeMillis();
        TIME_LOGGER.debug("Transport binding build took: {}", new Supplier[]{() -> t1 - t0});
    }

    private byte[] doX509TokenSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            List headers = signdParts.getHeaders();
            for (Header header : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        if (token.isDerivedKeys()) {
            try {
                WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(rmd, token);
                Element bstElem = encrKey.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                encrKey.appendToHeader(rmd.getSecHeader());
                WSSecDKSign dkSig = new WSSecDKSign();
                dkSig.setWsConfig(rmd.getConfig());
                dkSig.setSigCanonicalization(rpd.getAlgorithmSuite().getInclusiveC14n());
                dkSig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
                dkSig.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
                dkSig.setExternalKey(encrKey.getEphemeralKey(), encrKey.getId());
                dkSig.prepare(doc, rmd.getSecHeader());
                if (rpd.isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(encrKey.getBSTTokenId()));
                }
                dkSig.setParts(sigParts);
                List referenceList = dkSig.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSig.appendDKElementToHeader(rmd.getSecHeader());
                dkSig.computeSignature(referenceList, false, null);
                return dkSig.getSignatureValue();
            }
            catch (WSSecurityException | ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = this.getSignatureBuilder(rmd, token);
            sig.appendBSTElementToHeader(rmd.getSecHeader());
            if (rpd.isTokenProtection() && 1 != token.getInclusion()) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            List referenceList = sig.addReferencesToSign(sigParts, rmd.getSecHeader());
            sig.computeSignature(referenceList, false, null);
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
    }

    private byte[] doKerberosTokenSignature(RampartMessageData rmd, KerberosToken token, SignedEncryptedParts signdParts) throws RampartException {
        Document doc = rmd.getDocument();
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            List headers = signdParts.getHeaders();
            for (Header header : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        try {
            KerberosSecurity kerberosBst = this.addKerberosToken(rmd, (Token)token);
            kerberosBst.setID("Id-" + kerberosBst.hashCode());
            WSSecSignature sign = new WSSecSignature();
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            if (token.isRequiresKeyIdentifierReference()) {
                sign.setKeyIdentifierType(12);
                byte[] digestBytes = WSSecurityUtil.generateDigest((byte[])kerberosBst.getToken());
                sign.setCustomTokenId(Base64.encode((byte[])digestBytes));
                sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            } else {
                sign.setKeyIdentifierType(9);
                sign.setCustomTokenId(kerberosBst.getID());
                sign.setCustomTokenValueType(kerberosBst.getValueType());
            }
            SecretKey secretKey = kerberosBst.getSecretKey();
            sign.setSecretKey(secretKey.getEncoded());
            sign.prepare(doc, null, rmd.getSecHeader());
            WSSecurityUtil.prependChildElement((Element)rmd.getSecHeader().getSecurityHeader(), (Element)kerberosBst.getElement());
            List referenceList = sign.addReferencesToSign(sigParts, rmd.getSecHeader());
            sign.computeSignature(referenceList, false, null);
            return sign.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithKerberosToken", e);
        }
    }

    private void appendToHeader(WSSecHeader secHeader, Element appendingChild) {
        Element secHeaderElement = secHeader.getSecurityHeader();
        secHeaderElement.appendChild(appendingChild);
    }

    private byte[] doIssuedTokenSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        List referenceList;
        org.apache.rahas.Token tok;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        String id = RampartUtil.getIssuedToken(rmd, (IssuedToken)token);
        int inclusion = token.getInclusion();
        try {
            tok = rmd.getTokenStorage().getToken(id);
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken", new String[]{id}, e);
        }
        boolean tokenIncluded = false;
        if (inclusion == 5 || (inclusion == 3 || inclusion == 2) && rmd.isInitiator()) {
            rmd.getSecHeader().getSecurityHeader().appendChild(doc.importNode((Element)tok.getToken(), true));
            tokenIncluded = true;
        }
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (rpd.isTokenProtection() && tokenIncluded) {
            sigParts.add(new WSEncryptionPart(id));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            List headers = signdParts.getHeaders();
            for (Header signedHeader : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(signedHeader.getName(), signedHeader.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign dkSign = new WSSecDKSign();
                OMElement ref = tokenIncluded ? tok.getAttachedReference() : tok.getUnattachedReference();
                if (ref != null) {
                    dkSign.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)ref, true));
                } else {
                    dkSign.setExternalKey(tok.getSecret(), tok.getId());
                }
                dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
                dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength());
                dkSign.prepare(doc);
                dkSign.appendDKElementToHeader(rmd.getSecHeader());
                dkSign.setParts(sigParts);
                referenceList = dkSign.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSign.computeSignature(referenceList, false, null);
                return dkSign.getSignatureValue();
            }
            catch (WSSecurityException | ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = new WSSecSignature();
            sig.setWsConfig(rmd.getConfig());
            String tokId = tok.getId();
            if (tokId.charAt(0) == '#') {
                tokId = tokId.substring(1);
            }
            sig.setCustomTokenId(tokId);
            sig.setCustomTokenValueType(RampartUtil.getSAML10AssertionNamespace());
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            sig.setKeyIdentifierType(9);
            sig.prepare(rmd.getDocument(), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), rmd.getSecHeader());
            sig.setParts(sigParts);
            referenceList = sig.addReferencesToSign(sigParts, rmd.getSecHeader());
            sig.computeSignature(referenceList);
            this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), sig.getSignatureElement()));
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    private byte[] doSecureConversationSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        org.apache.rahas.Token tok;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        String id = rmd.getSecConvTokenId();
        int inclusion = token.getInclusion();
        try {
            tok = rmd.getTokenStorage().getToken(id);
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken", new String[]{id}, e);
        }
        boolean tokenIncluded = false;
        if (inclusion == 5 || (inclusion == 3 || inclusion == 2) && rmd.isInitiator()) {
            rmd.getSecHeader().getSecurityHeader().appendChild(doc.importNode((Element)tok.getToken(), true));
            tokenIncluded = true;
        }
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (rpd.isTokenProtection() && tokenIncluded) {
            sigParts.add(new WSEncryptionPart(id));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            List headers = signdParts.getHeaders();
            for (Header objectHeader : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(objectHeader.getName(), objectHeader.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign dkSign = new WSSecDKSign();
                OMElement ref = tokenIncluded ? tok.getAttachedReference() : tok.getUnattachedReference();
                if (ref != null) {
                    dkSign.setExternalKey(tok.getSecret(), (Element)doc.importNode((Element)ref, true));
                } else {
                    dkSign.setExternalKey(tok.getSecret(), tok.getId());
                }
                dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
                dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength());
                dkSign.prepare(doc);
                dkSign.appendDKElementToHeader(rmd.getSecHeader());
                dkSign.setParts(sigParts);
                List referenceList = dkSign.addReferencesToSign(sigParts, rmd.getSecHeader());
                dkSign.computeSignature(referenceList, false, null);
                return dkSign.getSignatureValue();
            }
            catch (WSSecurityException | ConversationException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = new WSSecSignature();
            sig.setWsConfig(rmd.getConfig());
            sig.setCustomTokenId(tok.getId().substring(1));
            sig.setCustomTokenValueType(RampartUtil.getSAML10AssertionNamespace());
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            sig.setKeyIdentifierType(9);
            sig.prepare(rmd.getDocument(), RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()), rmd.getSecHeader());
            sig.setParts(sigParts);
            List referenceList = sig.addReferencesToSign(sigParts, rmd.getSecHeader());
            sig.computeSignature(referenceList, false, this.getInsertionLocation());
            this.setInsertionLocation(sig.getSignatureElement());
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    private void handleSecureConversationTokens(RampartMessageData rmd, SecureConversationToken secConvTok) throws RampartException {
        boolean cancelReqResp;
        MessageContext msgContext = rmd.getMsgContext();
        String secConvTokenId = rmd.getSecConvTokenId();
        String action = msgContext.getOptions().getAction();
        boolean bl = cancelReqResp = action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel");
        if (secConvTokenId != null && cancelReqResp) {
            try {
                rmd.getTokenStorage().getToken(secConvTokenId).setState(3);
                msgContext.setProperty("sctID", (Object)secConvTokenId);
                String contextIdentifierKey = RampartUtil.getContextIdentifierKey(msgContext);
                RampartUtil.getContextMap(msgContext).remove(contextIdentifierKey);
            }
            catch (TrustException e) {
                throw new RampartException("errorExtractingToken", e);
            }
        }
        if (secConvTokenId == null || !RampartUtil.isTokenValid(rmd, secConvTokenId) && !cancelReqResp) {
            LOGGER.debug("No SecureConversationToken found, requesting a new token");
            try {
                secConvTokenId = RampartUtil.getSecConvToken(rmd, secConvTok);
                rmd.setSecConvTokenId(secConvTokenId);
            }
            catch (TrustException e) {
                throw new RampartException("errorInObtainingSct", e);
            }
        }
    }
}

