/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.rampart.MessageBuilder;
import org.apache.rampart.RampartException;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.security.WSSecurityException;

public class RampartSender
implements Handler {
    private static final Logger MESSAGE_LOGGER = LogManager.getLogger((String)"org.apache.rampart.MESSAGE");
    private static final HandlerDescription EMPTY_HANDLER_METADATA = new HandlerDescription("default Handler");
    private HandlerDescription handlerDesc = EMPTY_HANDLER_METADATA;

    public void cleanup() {
    }

    public void init(HandlerDescription handlerdesc) {
        this.handlerDesc = handlerdesc;
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (!msgContext.isEngaged("rampart")) {
            return Handler.InvocationResponse.CONTINUE;
        }
        MessageBuilder builder = new MessageBuilder();
        try {
            builder.build(msgContext);
        }
        catch (WSSPolicyException | WSSecurityException e) {
            throw new AxisFault(e.getMessage(), e);
        }
        catch (RampartException e) {
            if (msgContext.isProcessingFault()) {
                return Handler.InvocationResponse.CONTINUE;
            }
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((MessageContext)msgContext).getEnvelope();
        MESSAGE_LOGGER.debug("*********************** RampartSender sent out \n{}", supplierArray);
        return Handler.InvocationResponse.CONTINUE;
    }

    public void flowComplete(MessageContext msgContext) {
    }

    public HandlerDescription getHandlerDesc() {
        return this.handlerDesc;
    }

    public String getName() {
        return "Apache Rampart outflow handler";
    }

    public Parameter getParameter(String name) {
        return this.handlerDesc.getParameter(name);
    }
}

