/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.handler;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.validate.UsernameTokenValidator;

public class RampartUsernameTokenValidator
extends UsernameTokenValidator {
    private static final Logger MESSAGE_LOGGER = LogManager.getLogger((String)"org.apache.rampart.MESSAGE");

    protected void verifyPlaintextPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        String user = usernameToken.getName();
        String password = usernameToken.getPassword();
        String pwType = usernameToken.getPasswordType();
        WSPasswordCallback pwCb = new WSPasswordCallback(user, password, pwType, 2, data);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            MESSAGE_LOGGER.debug("{}", new Supplier[]{() -> e});
            throw new WSSecurityException(5);
        }
    }
}

