/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy;

import java.util.Iterator;
import java.util.List;
import org.apache.axis2.policy.model.MTOMAssertion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.neethi.Assertion;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AsymmetricBinding;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.ContentEncryptedElements;
import org.apache.ws.secpolicy.model.EncryptionToken;
import org.apache.ws.secpolicy.model.Header;
import org.apache.ws.secpolicy.model.InitiatorToken;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.RecipientToken;
import org.apache.ws.secpolicy.model.RequiredElements;
import org.apache.ws.secpolicy.model.SignatureToken;
import org.apache.ws.secpolicy.model.SignedEncryptedElements;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;
import org.apache.ws.secpolicy.model.SymmetricBinding;
import org.apache.ws.secpolicy.model.TransportBinding;
import org.apache.ws.secpolicy.model.TransportToken;
import org.apache.ws.secpolicy.model.Trust10;
import org.apache.ws.secpolicy.model.Wss10;
import org.apache.ws.secpolicy.model.Wss11;

public class RampartPolicyBuilder {
    private static final Logger LOGGER = LogManager.getLogger(RampartPolicyBuilder.class);

    public static RampartPolicyData build(List<Assertion> topLevelAssertions) throws WSSPolicyException {
        RampartPolicyData rpd = new RampartPolicyData();
        for (Assertion assertion : topLevelAssertions) {
            if (assertion instanceof Binding) {
                RampartPolicyBuilder.setWebServiceSecurityPolicyNS(assertion, rpd);
                if (assertion instanceof SymmetricBinding) {
                    RampartPolicyBuilder.processSymmetricPolicyBinding((SymmetricBinding)assertion, rpd);
                    continue;
                }
                if (assertion instanceof AsymmetricBinding) {
                    RampartPolicyBuilder.processAsymmetricPolicyBinding((AsymmetricBinding)assertion, rpd);
                    continue;
                }
                RampartPolicyBuilder.processTransportBinding((TransportBinding)assertion, rpd);
                continue;
            }
            if (assertion instanceof Wss11) {
                RampartPolicyBuilder.processWSS11((Wss11)assertion, rpd);
                continue;
            }
            if (assertion instanceof Wss10) {
                RampartPolicyBuilder.processWSS10((Wss10)assertion, rpd);
                continue;
            }
            if (assertion instanceof SignedEncryptedElements) {
                RampartPolicyBuilder.processSignedEncryptedElements((SignedEncryptedElements)assertion, rpd);
                continue;
            }
            if (assertion instanceof SignedEncryptedParts) {
                RampartPolicyBuilder.processSignedEncryptedParts((SignedEncryptedParts)assertion, rpd);
                continue;
            }
            if (assertion instanceof RequiredElements) {
                RampartPolicyBuilder.processRequiredElements((RequiredElements)assertion, rpd);
                continue;
            }
            if (assertion instanceof ContentEncryptedElements) {
                RampartPolicyBuilder.processContentEncryptedElements((ContentEncryptedElements)assertion, rpd);
                continue;
            }
            if (assertion instanceof SupportingToken) {
                RampartPolicyBuilder.setWebServiceSecurityPolicyNS(assertion, rpd);
                RampartPolicyBuilder.processSupportingTokens((SupportingToken)assertion, rpd);
                continue;
            }
            if (assertion instanceof Trust10) {
                RampartPolicyBuilder.processTrust10((Trust10)assertion, rpd);
                continue;
            }
            if (assertion instanceof RampartConfig) {
                RampartPolicyBuilder.processRampartConfig((RampartConfig)assertion, rpd);
                continue;
            }
            if (assertion instanceof MTOMAssertion) {
                RampartPolicyBuilder.processMTOMSerialization((MTOMAssertion)assertion, rpd);
                continue;
            }
            LOGGER.debug("Unknown top level PED found: {}", new Supplier[]{() -> assertion.getClass().getName()});
        }
        return rpd;
    }

    private static void setWebServiceSecurityPolicyNS(Assertion assertion, RampartPolicyData policyData) {
        if (policyData.getWebServiceSecurityPolicyNS() == null) {
            policyData.setWebServiceSecurityPolicyNS(assertion.getName().getNamespaceURI());
        }
    }

    private static void processTransportBinding(TransportBinding binding, RampartPolicyData rpd) {
        RampartPolicyBuilder.binding((Binding)binding, rpd);
        rpd.setTransportBinding(true);
        rpd.setTokenProtection(binding.isTokenProtection());
        TransportToken transportToken = binding.getTransportToken();
        if (transportToken != null) {
            rpd.setTransportToken(transportToken.getTransportToken());
        }
    }

    private static void processTrust10(Trust10 trust10, RampartPolicyData rpd) {
        rpd.setTrust10(trust10);
    }

    private static void processRampartConfig(RampartConfig config, RampartPolicyData rpd) {
        rpd.setRampartConfig(config);
    }

    private static void processSymmetricPolicyBinding(SymmetricBinding symmBinding, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setSymmetricBinding(true);
        RampartPolicyBuilder.binding((Binding)symmBinding, rpd);
        RampartPolicyBuilder.symmAsymmBinding((SymmetricAsymmetricBindingBase)symmBinding, rpd);
        RampartPolicyBuilder.symmetricBinding(symmBinding, rpd);
    }

    private static void processWSS10(Wss10 wss10, RampartPolicyData rpd) {
        rpd.setWss10(wss10);
    }

    private static void processAsymmetricPolicyBinding(AsymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setAsymmetricBinding(true);
        RampartPolicyBuilder.binding((Binding)binding, rpd);
        RampartPolicyBuilder.symmAsymmBinding((SymmetricAsymmetricBindingBase)binding, rpd);
        RampartPolicyBuilder.asymmetricBinding(binding, rpd);
    }

    private static void processWSS11(Wss11 wss11, RampartPolicyData rpd) {
        rpd.setSignatureConfirmation(wss11.isRequireSignatureConfirmation());
        rpd.setWss11(wss11);
    }

    private static void processSignedEncryptedElements(SignedEncryptedElements see, RampartPolicyData rpd) {
        if (see.isSignedElemets()) {
            for (String xPathExpression : see.getXPathExpressions()) {
                rpd.setSignedElements(xPathExpression);
            }
        } else {
            for (String xPathExpression : see.getXPathExpressions()) {
                rpd.setEncryptedElements(xPathExpression);
            }
        }
        rpd.addDeclaredNamespaces(see.getDeclaredNamespaces());
    }

    private static void processSignedEncryptedParts(SignedEncryptedParts sep, RampartPolicyData rpd) {
        Iterator it = sep.getHeaders().iterator();
        if (sep.isSignedParts()) {
            rpd.setSignBody(sep.isBody());
            rpd.setSignAttachments(sep.isAttachments());
            rpd.setSignAllHeaders(sep.isSignAllHeaders());
            rpd.setSignBodyOptional(sep.isOptional());
            rpd.setSignAttachmentsOptional(sep.isOptional());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                rpd.addSignedPart(header.getNamespace(), header.getName());
            }
        } else {
            rpd.setEncryptBody(sep.isBody());
            rpd.setEncryptAttachments(sep.isAttachments());
            rpd.setEncryptBodyOptional(sep.isOptional());
            rpd.setEncryptAttachmentsOptional(sep.isOptional());
            while (it.hasNext()) {
                Header header = (Header)it.next();
                rpd.setEncryptedParts(header.getNamespace(), header.getName(), "Header");
            }
        }
    }

    private static void processContentEncryptedElements(ContentEncryptedElements cee, RampartPolicyData rpd) {
        for (String s : cee.getXPathExpressions()) {
            rpd.setContentEncryptedElements(s);
        }
        rpd.addDeclaredNamespaces(cee.getDeclaredNamespaces());
    }

    private static void processRequiredElements(RequiredElements req, RampartPolicyData rpd) {
        for (String s : req.getXPathExpressions()) {
            rpd.setRequiredElements(s);
        }
        rpd.addDeclaredNamespaces(req.getDeclaredNamespaces());
    }

    private static void binding(Binding binding, RampartPolicyData rpd) {
        rpd.setLayout(binding.getLayout().getValue());
        rpd.setIncludeTimestamp(binding.isIncludeTimestamp());
        rpd.setIncludeTimestampOptional(binding.isIncludeTimestampOptional());
        rpd.setAlgorithmSuite(binding.getAlgorithmSuite());
    }

    private static void symmAsymmBinding(SymmetricAsymmetricBindingBase binding, RampartPolicyData rpd) {
        rpd.setEntireHeadersAndBodySignatures(binding.isEntireHeadersAndBodySignatures());
        rpd.setProtectionOrder(binding.getProtectionOrder());
        rpd.setSignatureProtection(binding.isSignatureProtection());
        rpd.setTokenProtection(binding.isTokenProtection());
        rpd.setAlgorithmSuite(binding.getAlgorithmSuite());
    }

    private static void symmetricBinding(SymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        ProtectionToken token = binding.getProtectionToken();
        if (token != null) {
            rpd.setProtectionToken(token.getProtectionToken());
        } else {
            EncryptionToken encrToken = binding.getEncryptionToken();
            SignatureToken sigToken = binding.getSignatureToken();
            if (sigToken == null) {
                throw new WSSPolicyException("Symmetric binding should have a Protection token or both Signature and Encryption tokens defined");
            }
            rpd.setEncryptionToken(encrToken.getEncryptionToken());
            rpd.setSignatureToken(sigToken.getSignatureToken());
        }
    }

    private static void asymmetricBinding(AsymmetricBinding binding, RampartPolicyData rpd) throws WSSPolicyException {
        RecipientToken rt = binding.getRecipientToken();
        InitiatorToken it = binding.getInitiatorToken();
        if (rt == null || it == null) {
            throw new WSSPolicyException("Asymmetric binding should have both Initiator and Recipient tokens defined");
        }
        rpd.setRecipientToken(rt.getRecipientToken());
        rpd.setInitiatorToken(it.getInitiatorToken());
    }

    private static void processSupportingTokens(SupportingToken token, RampartPolicyData rpd) throws WSSPolicyException {
        rpd.setSupportingTokens(token);
    }

    private static void processMTOMSerialization(MTOMAssertion mtomAssertion, RampartPolicyData rpd) {
        rpd.setMTOMAssertion(mtomAssertion);
    }
}

