/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.PolicyComponent;
import org.apache.rampart.RampartException;
import org.ietf.jgss.GSSCredential;

public class KerberosConfig
implements Assertion {
    public static final String KERBEROS_LN = "kerberosConfig";
    public static final String JAAS_CONTEXT_LN = "jaasContext";
    public static final String PRINCIPAL_NAME_LN = "principalName";
    public static final String PRINCIPAL_PASSWORD_LN = "principalPassword";
    public static final String SERVICE_PRINCIPAL_NAME_LN = "servicePrincipalName";
    public static final String SERVICE_PRINCIPAL_NAME_FORM_LN = "servicePrincipalNameForm";
    public static final String KERBEROS_TOKEN_DECODER_CLASS_LN = "kerberosTokenDecoderClass";
    public static final String REQUEST_CREDENTIAL_DELEGATION_LN = "requestCredentialDelegation";
    public static final String DELEGATION_CREDENTIAL_LN = "delegationCredential";
    public static final String HOST_BASED_NAME_FORM = "hostbased";
    public static final String USERNAME_NAME_FORM = "username";
    private String jaasContext;
    private String principalName;
    private String principalPassword;
    private String servicePrincipalName;
    private String servicePrincipalNameForm;
    private String kerberosTokenDecoderClass;
    private boolean requstCredentialDelegation;
    private GSSCredential delegationCredential;

    public String getJaasContext() {
        return this.jaasContext;
    }

    public void setJaasContext(String jaasContext) {
        this.jaasContext = jaasContext;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getPrincipalPassword() {
        return this.principalPassword;
    }

    public void setPrincipalPassword(String principalPassword) {
        this.principalPassword = principalPassword;
    }

    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    public void setServicePrincipalName(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    public String getServicePrincipalNameForm() {
        if (this.servicePrincipalNameForm == null) {
            return HOST_BASED_NAME_FORM;
        }
        return this.servicePrincipalNameForm;
    }

    public void setKerberosTokenDecoderClass(String kerberosTokenDecoderClass) {
        this.kerberosTokenDecoderClass = kerberosTokenDecoderClass;
    }

    public String getKerberosTokenDecoderClass() {
        return this.kerberosTokenDecoderClass;
    }

    public void setServicePrincipalNameForm(String servicePrincipalNameForm) throws IllegalArgumentException {
        if (!HOST_BASED_NAME_FORM.equals(servicePrincipalNameForm) && !USERNAME_NAME_FORM.equals(servicePrincipalNameForm)) {
            throw new IllegalArgumentException(new RampartException("invalidServicePrincipalNameForm", new String[]{servicePrincipalNameForm, HOST_BASED_NAME_FORM, USERNAME_NAME_FORM}));
        }
        this.servicePrincipalNameForm = servicePrincipalNameForm;
    }

    public boolean isRequstCredentialDelegation() {
        return this.requstCredentialDelegation;
    }

    public void setRequestCredentialDelegation(boolean requestCredentialDelegation) {
        this.requstCredentialDelegation = requestCredentialDelegation;
    }

    public GSSCredential getDelegationCredential() {
        return this.delegationCredential;
    }

    public void setDelegationCredential(GSSCredential delegationCredential) {
        this.delegationCredential = delegationCredential;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public QName getName() {
        return new QName("http://ws.apache.org/rampart/policy", KERBEROS_LN);
    }

    public boolean isOptional() {
        return true;
    }

    public boolean isIgnorable() {
        throw new UnsupportedOperationException();
    }

    public short getType() {
        return 5;
    }

    public boolean equal(PolicyComponent policyComponent) {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = writer.getPrefix("http://ws.apache.org/rampart/policy");
        if (prefix == null) {
            prefix = "http://ws.apache.org/rampart/policy";
            writer.setPrefix(prefix, "http://ws.apache.org/rampart/policy");
        }
        if (this.getJaasContext() != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", JAAS_CONTEXT_LN);
            writer.writeCharacters(this.getJaasContext());
            writer.writeEndElement();
        }
        if (this.getPrincipalName() != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", PRINCIPAL_NAME_LN);
            writer.writeCharacters(this.getPrincipalName());
            writer.writeEndElement();
        }
        if (this.getPrincipalPassword() != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", PRINCIPAL_PASSWORD_LN);
            writer.writeCharacters(this.getPrincipalPassword());
            writer.writeEndElement();
        }
        if (this.getServicePrincipalName() != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", SERVICE_PRINCIPAL_NAME_LN);
            writer.writeCharacters(this.getServicePrincipalName());
            writer.writeEndElement();
        }
        if (this.servicePrincipalNameForm != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", SERVICE_PRINCIPAL_NAME_FORM_LN);
            writer.writeCharacters(this.servicePrincipalNameForm);
            writer.writeEndElement();
        }
        if (this.kerberosTokenDecoderClass != null) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", KERBEROS_TOKEN_DECODER_CLASS_LN);
            writer.writeCharacters(this.kerberosTokenDecoderClass);
            writer.writeEndElement();
        }
        if (this.requstCredentialDelegation) {
            writer.writeStartElement("http://ws.apache.org/rampart/policy", REQUEST_CREDENTIAL_DELEGATION_LN);
            writer.writeCharacters(Boolean.toString(this.requstCredentialDelegation));
            writer.writeEndElement();
        }
    }
}

