/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.KeyGenerator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultClassifier;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.client.MexClient;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.kernel.http.HTTPConstants;
import org.apache.axis2.mex.om.Metadata;
import org.apache.axis2.mex.om.MetadataReference;
import org.apache.axis2.mex.om.MetadataSection;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rahas.Token;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.client.STSClient;
import org.apache.rampart.PolicyBasedResultsValidator;
import org.apache.rampart.PolicyValidatorCallbackHandler;
import org.apache.rampart.RampartConfigCallbackHandler;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.SupportingPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.rampart.util.Axis2Util;
import org.apache.ws.secpolicy.model.HttpsToken;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.Wss11;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.validate.KerberosTokenDecoder;
import org.jaxen.JaxenException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RampartUtil {
    private static final String CRYPTO_PROVIDER = "org.apache.ws.security.crypto.provider";
    private static final Logger LOGGER = LogManager.getLogger(RampartUtil.class);
    private static final Map<String, CachedCrypto> cryptoStore = new ConcurrentHashMap<String, CachedCrypto>();

    public static CallbackHandler getPasswordCB(RampartMessageData rmd) throws RampartException {
        MessageContext msgContext = rmd.getMsgContext();
        RampartPolicyData rpd = rmd.getPolicyData();
        return RampartUtil.getPasswordCB(msgContext, rpd);
    }

    public static CallbackHandler getPasswordCB(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        Parameter param;
        CallbackHandler cbHandler;
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getPwCbClass() != null) {
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getPwCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            LOGGER.debug("loading class : " + cbHandlerClass);
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadPWCBClass", new String[]{cbHandlerClass}, e);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RampartException("cannotCreatePWCBInstance", new String[]{cbHandlerClass}, e);
            }
        }
        cbHandler = (CallbackHandler)msgContext.getProperty("passwordCallbackRef");
        if (cbHandler == null && (param = msgContext.getParameter("passwordCallbackRef")) != null) {
            cbHandler = (CallbackHandler)param.getValue();
        }
        return cbHandler;
    }

    public static KerberosTokenDecoder getKerberosTokenDecoder(MessageContext msgContext, KerberosConfig kerberosConfig) throws RampartException {
        KerberosTokenDecoder kerberosTokenDecoder;
        Class krbTokenDecoderClass;
        if (kerberosConfig == null) {
            throw new IllegalArgumentException("Kerberos config must not be null");
        }
        if (msgContext == null) {
            throw new IllegalArgumentException("Message context must not be null");
        }
        AxisService service = msgContext.getAxisService();
        if (service == null) {
            throw new IllegalArgumentException("No service available in message context: " + msgContext.getLogIDString());
        }
        String kerberosTokenDecoderClass = kerberosConfig.getKerberosTokenDecoderClass();
        if (kerberosTokenDecoderClass == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No Kerberos token decoder class configured for service: " + service.getName());
            }
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Loading Kerberos token decoder class '%s' using class loader of service '%s'", kerberosTokenDecoderClass, service.getName()));
        }
        ClassLoader classLoader = service.getClassLoader();
        try {
            krbTokenDecoderClass = Loader.loadClass((ClassLoader)classLoader, (String)kerberosTokenDecoderClass);
        }
        catch (ClassNotFoundException e) {
            throw new RampartException("cannotLoadKrbTokenDecoderClass", new String[]{kerberosTokenDecoderClass}, e);
        }
        try {
            kerberosTokenDecoder = (KerberosTokenDecoder)krbTokenDecoderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RampartException("cannotCreateKrbTokenDecoderInstance", new String[]{kerberosTokenDecoderClass}, e);
        }
        return kerberosTokenDecoder;
    }

    public static PolicyValidatorCallbackHandler getPolicyValidatorCB(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        PolicyValidatorCallbackHandler cbHandler;
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getPolicyValidatorCbClass() != null) {
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getPolicyValidatorCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("loading class : " + cbHandlerClass);
            }
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadPolicyValidatorCbClass", new String[]{cbHandlerClass}, e);
            }
            try {
                cbHandler = (PolicyValidatorCallbackHandler)cbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RampartException("cannotCreatePolicyValidatorCallbackInstance", new String[]{cbHandlerClass}, e);
            }
        }
        cbHandler = new PolicyBasedResultsValidator();
        return cbHandler;
    }

    public static RampartConfigCallbackHandler getRampartConfigCallbackHandler(MessageContext msgContext, RampartPolicyData rpd) throws RampartException {
        if (rpd.getRampartConfig() != null && rpd.getRampartConfig().getRampartConfigCbClass() != null) {
            RampartConfigCallbackHandler rampartConfigCB;
            Class cbClass;
            String cbHandlerClass = rpd.getRampartConfig().getRampartConfigCbClass();
            ClassLoader classLoader = msgContext.getAxisService().getClassLoader();
            LOGGER.debug("loading class : " + cbHandlerClass);
            try {
                cbClass = Loader.loadClass((ClassLoader)classLoader, (String)cbHandlerClass);
            }
            catch (ClassNotFoundException e) {
                throw new RampartException("cannotLoadRampartConfigCallbackClass", new String[]{cbHandlerClass}, e);
            }
            try {
                rampartConfigCB = (RampartConfigCallbackHandler)cbClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RampartException("cannotCreateRampartConfigCallbackInstance", new String[]{cbHandlerClass}, e);
            }
            return rampartConfigCB;
        }
        return null;
    }

    public static WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws RampartException {
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new RampartException("pwcbFailed", e);
        }
        return pwCb;
    }

    public static Crypto getEncryptionCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        LOGGER.debug("Loading encryption crypto");
        Crypto crypto = null;
        if (config != null && config.getEncrCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getEncrCryptoConfig();
            String provider = cryptoConfig.getProvider();
            LOGGER.debug("Using provider: " + provider);
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            String cryptoKey = null;
            String interval = null;
            if (cryptoConfig.isCacheEnabled()) {
                if (cryptoConfig.getCryptoKey() != null) {
                    cryptoKey = prop.getProperty(cryptoConfig.getCryptoKey());
                    interval = cryptoConfig.getCacheRefreshInterval();
                } else if (provider.equals("org.apache.ws.security.components.crypto.Merlin")) {
                    cryptoKey = cryptoConfig.getProp().getProperty("org.apache.ws.security.crypto.merlin.file");
                }
            }
            if (cryptoKey != null) {
                crypto = RampartUtil.retrieveCryptoFromCache(cryptoKey.trim() + "#" + provider.trim(), interval);
            }
            if (crypto == null) {
                crypto = RampartUtil.createCrypto(prop, loader);
                if (cryptoKey != null) {
                    RampartUtil.cacheCrypto(cryptoKey.trim() + "#" + provider.trim(), crypto);
                }
            }
        } else {
            LOGGER.debug("Trying the signature crypto info");
            crypto = RampartUtil.getSignatureCrypto(config, loader);
        }
        return crypto;
    }

    private static Crypto createCrypto(Properties properties, ClassLoader classLoader) throws RampartException {
        try {
            return CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader);
        }
        catch (WSSecurityException e) {
            LOGGER.error("Error loading crypto properties.", (Throwable)e);
            throw new RampartException("cannotCrateCryptoInstance", e);
        }
    }

    public static Crypto getSignatureCrypto(RampartConfig config, ClassLoader loader) throws RampartException {
        LOGGER.debug("Loading Signature crypto");
        Crypto crypto = null;
        if (config != null && config.getSigCryptoConfig() != null) {
            CryptoConfig cryptoConfig = config.getSigCryptoConfig();
            String provider = cryptoConfig.getProvider();
            LOGGER.debug("Using provider: " + provider);
            Properties prop = cryptoConfig.getProp();
            prop.put(CRYPTO_PROVIDER, provider);
            String cryptoKey = null;
            String interval = null;
            if (cryptoConfig.isCacheEnabled()) {
                if (cryptoConfig.getCryptoKey() != null) {
                    cryptoKey = prop.getProperty(cryptoConfig.getCryptoKey());
                    interval = cryptoConfig.getCacheRefreshInterval();
                } else if (provider.equals("org.apache.ws.security.components.crypto.Merlin")) {
                    cryptoKey = cryptoConfig.getProp().getProperty("org.apache.ws.security.crypto.merlin.file");
                }
            }
            if (cryptoKey != null) {
                crypto = RampartUtil.retrieveCryptoFromCache(cryptoKey.trim() + "#" + provider.trim(), interval);
            }
            if (crypto == null) {
                crypto = RampartUtil.createCrypto(prop, loader);
                if (cryptoKey != null) {
                    RampartUtil.cacheCrypto(cryptoKey.trim() + "#" + provider.trim(), crypto);
                }
            }
        }
        return crypto;
    }

    public static int getKeyIdentifier(X509Token token) throws RampartException {
        if (token.isRequireIssuerSerialReference()) {
            return 2;
        }
        if (token.isRequireThumbprintReference()) {
            return 8;
        }
        if (token.isRequireEmbeddedTokenReference()) {
            return 1;
        }
        throw new RampartException("unknownKeyRefSpecifier");
    }

    public static String processIssuerAddress(OMElement issuerAddress) throws RampartException {
        if (issuerAddress == null) {
            throw new RampartException("invalidIssuerAddress", new String[]{"Issuer address null"});
        }
        if (issuerAddress.getText() == null || "".equals(issuerAddress.getText())) {
            throw new RampartException("invalidIssuerAddress", new String[]{issuerAddress.toString()});
        }
        return issuerAddress.getText().trim();
    }

    public static Policy getPolicyFromMetadataRef(OMElement mex) throws RampartException {
        try {
            Metadata metadata = new Metadata();
            metadata.fromOM(mex.getFirstElement());
            MetadataSection[] metadataSections = metadata.getMetadatSections();
            MetadataReference reference = metadataSections[0].getMetadataReference();
            MexClient serviceClient = new MexClient();
            Options options = serviceClient.getOptions();
            options.setTo(reference.getEPR());
            options.setAction("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request");
            OMElement request = serviceClient.setupGetMetadataRequest("http://schemas.xmlsoap.org/ws/2004/09/policy", null);
            OMElement result = serviceClient.sendReceive(request);
            metadata.fromOM(result);
            MetadataSection[] mexSecs = metadata.getMetadataSection("http://schemas.xmlsoap.org/ws/2004/09/policy", null);
            OMElement policyElement = (OMElement)mexSecs[0].getInlineData();
            return PolicyEngine.getPolicy((OMElement)policyElement);
        }
        catch (AxisFault e) {
            throw new RampartException("Error Retrieving the policy from mex", e);
        }
    }

    public static Policy addRampartConfig(RampartMessageData rmd, Policy policy) {
        RampartConfig servicRampConf = rmd.getPolicyData().getRampartConfig();
        RampartConfig stsRampConf = new RampartConfig();
        stsRampConf.setUser(servicRampConf.getUser());
        stsRampConf.setSigCryptoConfig(servicRampConf.getSigCryptoConfig());
        stsRampConf.setPwCbClass(servicRampConf.getPwCbClass());
        stsRampConf.setEncryptionUser(servicRampConf.getStsAlias());
        stsRampConf.setEncrCryptoConfig(servicRampConf.getStsCryptoConfig());
        policy.addAssertion((Assertion)stsRampConf);
        return policy;
    }

    public static OMElement createRSTTempalteForSCT(int conversationVersion, int wstVersion) throws RampartException {
        try {
            LOGGER.debug("Creating RSTTemplate for an SCT request");
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace wspNs = fac.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMElement rstTempl = fac.createOMElement("RequestSecurityTokenTemplate", wspNs);
            OMElement tokenTypeElem = TrustUtil.createTokenTypeElement((int)wstVersion, (OMElement)rstTempl);
            String tokenType = ConversationConstants.getWSCNs((int)conversationVersion) + "/sct";
            tokenTypeElem.setText(tokenType);
            return rstTempl;
        }
        catch (TrustException | ConversationException e) {
            throw new RampartException("errorCreatingRSTTemplateForSCT", e);
        }
    }

    public static int getTimeToLive(RampartMessageData messageData) {
        RampartConfig rampartConfig = messageData.getPolicyData().getRampartConfig();
        if (rampartConfig != null) {
            String ttl = rampartConfig.getTimestampTTL();
            int ttl_i = 0;
            if (ttl != null) {
                try {
                    ttl_i = Integer.parseInt(ttl);
                }
                catch (NumberFormatException e) {
                    ttl_i = messageData.getTimeToLive();
                }
            }
            if (ttl_i <= 0) {
                ttl_i = messageData.getTimeToLive();
            }
            return ttl_i;
        }
        return 300;
    }

    public static int getTimestampMaxSkew(RampartMessageData messageData) {
        RampartConfig rampartConfig = messageData.getPolicyData().getRampartConfig();
        if (rampartConfig != null) {
            String maxSkew = rampartConfig.getTimestampMaxSkew();
            int maxSkew_i = 0;
            if (maxSkew != null) {
                try {
                    maxSkew_i = Integer.parseInt(maxSkew);
                }
                catch (NumberFormatException e) {
                    maxSkew_i = messageData.getTimestampMaxSkew();
                }
            }
            if (maxSkew_i < 0) {
                maxSkew_i = 0;
            }
            return maxSkew_i;
        }
        return 300;
    }

    public static String getSecConvToken(RampartMessageData rmd, SecureConversationToken secConvTok) throws TrustException, RampartException {
        String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/SCT");
        OMElement issuerEpr = secConvTok.getIssuerEpr();
        String issuerEprAddress = rmd.getMsgContext().getTo().getAddress();
        if (issuerEpr != null) {
            issuerEprAddress = RampartUtil.processIssuerAddress(issuerEpr);
        }
        int conversationVersion = rmd.getSecConvVersion();
        OMElement rstTemplate = RampartUtil.createRSTTempalteForSCT(conversationVersion, rmd.getWstVersion());
        Policy stsPolicy = null;
        Policy bsPol = secConvTok.getBootstrapPolicy();
        if (bsPol != null) {
            LOGGER.debug("BootstrapPolicy found");
            bsPol.addAssertion((Assertion)rmd.getPolicyData().getRampartConfig());
            if (rmd.getPolicyData().getMTOMAssertion() != null) {
                bsPol.addAssertion((Assertion)rmd.getPolicyData().getMTOMAssertion());
            }
            stsPolicy = bsPol;
        } else {
            LOGGER.debug("No bootstrap policy, using issuer policy");
            stsPolicy = rmd.getPolicyData().getIssuerPolicy();
        }
        String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
        LOGGER.debug("SecureConversationToken obtained: id=" + id);
        return id;
    }

    public static String getIssuedToken(RampartMessageData rmd, IssuedToken issuedToken) throws RampartException {
        try {
            String action = TrustUtil.getActionValue((int)rmd.getWstVersion(), (String)"/RST/Issue");
            String issuerEprAddress = RampartUtil.processIssuerAddress(issuedToken.getIssuerEpr());
            OMElement rstTemplate = issuedToken.getRstTemplate();
            Policy stsPolicy = (Policy)rmd.getMsgContext().getProperty("rampartStsPolicy");
            if (stsPolicy == null && issuedToken.getIssuerMex() != null) {
                stsPolicy = RampartUtil.getPolicyFromMetadataRef(issuedToken.getIssuerMex());
                RampartUtil.addRampartConfig(rmd, stsPolicy);
            }
            String id = RampartUtil.getToken(rmd, rstTemplate, issuerEprAddress, action, stsPolicy);
            LOGGER.debug("Issued token obtained: id=" + id);
            return id;
        }
        catch (TrustException e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getToken(RampartMessageData rmd, OMElement rstTemplate, String issuerEpr, String action, Policy issuerPolicy) throws RampartException {
        try {
            MessageContext msgContext = rmd.getMsgContext();
            String customTokeId = (String)msgContext.getProperty("customIssuedToken");
            if (customTokeId != null) {
                return customTokeId;
            }
            Axis2Util.useDOOM(false);
            STSClient client = new STSClient(rmd.getMsgContext().getConfigurationContext());
            client.setAction(action);
            client.setVersion(rmd.getWstVersion());
            client.setRstTemplate(rstTemplate);
            Crypto crypto = RampartUtil.getSignatureCrypto(rmd.getPolicyData().getRampartConfig(), rmd.getMsgContext().getAxisService().getClassLoader());
            CallbackHandler cbh = RampartUtil.getPasswordCB(rmd);
            client.setCryptoInfo(crypto, cbh);
            Policy servicePolicy = rmd.getServicePolicy();
            String servceEprAddress = rmd.getMsgContext().getOptions().getTo().getAddress();
            Object addrVersionNs = msgContext.getProperty("WSAddressingVersion");
            if (addrVersionNs != null) {
                client.setAddressingNs((String)addrVersionNs);
            }
            Options options = new Options();
            options.setUserName(rmd.getMsgContext().getOptions().getUserName());
            options.setPassword(rmd.getMsgContext().getOptions().getPassword());
            if (msgContext.getProperty("CUSTOM_PROTOCOL_HANDLER") != null) {
                Protocol protocolHandler = (Protocol)msgContext.getProperty("CUSTOM_PROTOCOL_HANDLER");
                options.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)protocolHandler);
            }
            if (msgContext.getParameter("passwordCallbackRef") != null) {
                Parameter pwCallback = msgContext.getParameter("passwordCallbackRef");
                client.addParameter(pwCallback);
            }
            client.setOptions(options);
            if (msgContext.isSOAP11()) {
                client.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                client.setSoapVersion("http://www.w3.org/2003/05/soap-envelope");
            }
            Token rst = client.requestSecurityToken(servicePolicy, issuerEpr, issuerPolicy, servceEprAddress);
            rst.setState(1);
            rmd.getTokenStorage().add(rst);
            Axis2Util.useDOOM(true);
            return rst.getId();
        }
        catch (Exception e) {
            throw new RampartException("errorInObtainingToken", e);
        }
    }

    public static String getSoapBodyId(SOAPEnvelope env) {
        return RampartUtil.addWsuIdToElement((OMElement)env.getBody());
    }

    public static String addWsuIdToElement(OMElement elem) {
        String id;
        OMAttribute idAttr = elem.getAttribute(new QName("Id"));
        if (idAttr == null) {
            idAttr = elem.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        }
        if (idAttr != null) {
            id = idAttr.getAttributeValue();
        } else {
            OMNamespace ns = elem.getOMFactory().createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
            id = "Id-" + elem.hashCode();
            idAttr = elem.getOMFactory().createOMAttribute("Id", ns, id);
            elem.addAttribute(idAttr);
        }
        return id;
    }

    public static Node adoptNode(Document targetDocument, Node node) {
        Node result = targetDocument.adoptNode(node);
        if (result == null) {
            result = targetDocument.importNode(node, true);
        }
        return result;
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, OMElement elem) {
        return RampartUtil.appendChildToSecHeader(rmd, (Element)elem);
    }

    public static Element appendChildToSecHeader(RampartMessageData rmd, Element elem) {
        Element secHeaderElem = rmd.getSecHeader().getSecurityHeader();
        Node node = RampartUtil.adoptNode(secHeaderElem.getOwnerDocument(), elem);
        return (Element)secHeaderElem.appendChild(node);
    }

    public static Element insertSiblingAfter(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            if (child.getParentNode() == null && !child.getLocalName().equals("UsernameToken")) {
                rmd.getSecHeader().getSecurityHeader().appendChild(child);
            }
            ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingAfter((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static Element insertSiblingBefore(RampartMessageData rmd, Element child, Element sibling) {
        if (child == null) {
            return RampartUtil.appendChildToSecHeader(rmd, sibling);
        }
        if (child.getOwnerDocument().equals(sibling.getOwnerDocument())) {
            ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)sibling));
            return sibling;
        }
        Element newSib = (Element)child.getOwnerDocument().importNode(sibling, true);
        ((OMElement)child).insertSiblingBefore((OMNode)((OMElement)newSib));
        return newSib;
    }

    public static List<WSEncryptionPart> getEncryptedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        List<WSEncryptionPart> encryptedPartsElements = RampartUtil.getPartsAndElements(false, envelope, rpd.isEncryptBody() && !rpd.isEncryptBodyOptional(), rpd.getEncryptedParts(), rpd.getEncryptedElements(), rpd.getDeclaredNamespaces());
        return RampartUtil.getContentEncryptedElements(encryptedPartsElements, envelope, rpd.getContentEncryptedElements(), rpd.getDeclaredNamespaces());
    }

    public static List<WSEncryptionPart> getSignedParts(RampartMessageData rmd) {
        RampartPolicyData rpd = rmd.getPolicyData();
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        if (rpd.isSignAllHeaders()) {
            Iterator childHeaders = envelope.getHeader().getChildElements();
            while (childHeaders.hasNext()) {
                OMElement hb = (OMElement)childHeaders.next();
                if (hb.getLocalName().equals("Security") && hb.getNamespace().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) continue;
                rpd.addSignedPart(hb.getNamespace().getNamespaceURI(), hb.getLocalName());
            }
        }
        return RampartUtil.getPartsAndElements(true, envelope, rpd.isSignBody() && !rpd.isSignBodyOptional(), rpd.getSignedParts(), rpd.getSignedElements(), rpd.getDeclaredNamespaces());
    }

    public static List<WSEncryptionPart> getSupportingEncryptedParts(RampartMessageData rmd, SupportingPolicyData rpd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        return RampartUtil.getPartsAndElements(false, envelope, rpd.isEncryptBody() && !rpd.isEncryptBodyOptional(), rpd.getEncryptedParts(), rpd.getEncryptedElements(), rpd.getDeclaredNamespaces());
    }

    public static List<WSEncryptionPart> getSupportingSignedParts(RampartMessageData rmd, SupportingPolicyData rpd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        return RampartUtil.getPartsAndElements(true, envelope, rpd.isSignBody() && !rpd.isSignBodyOptional(), rpd.getSignedParts(), rpd.getSignedElements(), rpd.getDeclaredNamespaces());
    }

    public static Set<OMNamespace> findAllPrefixNamespaces(OMElement currentElement, Map<String, String> decNamespacess) {
        HashSet<OMNamespace> results = new HashSet<OMNamespace>();
        RampartUtil.findPrefixNamespaces(currentElement, results);
        List<OMNamespace> defaultNamespaces = RampartUtil.getDefaultPrefixNamespaces(currentElement.getOMFactory());
        results.addAll(defaultNamespaces);
        for (String prefix : decNamespacess.keySet()) {
            String ns = decNamespacess.get(prefix);
            OMFactory omFactory = currentElement.getOMFactory();
            OMNamespace namespace = omFactory.createOMNamespace(ns, prefix);
            results.add(namespace);
        }
        return results;
    }

    private static void findPrefixNamespaces(OMElement e, Set<OMNamespace> results) {
        Iterator iterator = e.getAllDeclaredNamespaces();
        if (iterator != null) {
            while (iterator.hasNext()) {
                results.add((OMNamespace)iterator.next());
            }
        }
        Iterator children = e.getChildElements();
        while (children.hasNext()) {
            RampartUtil.findPrefixNamespaces((OMElement)children.next(), results);
        }
    }

    private static List<OMNamespace> getDefaultPrefixNamespaces(OMFactory factory) {
        ArrayList<OMNamespace> namespaces = new ArrayList<OMNamespace>();
        namespaces.add(factory.createOMNamespace("http://www.w3.org/2001/04/xmlenc#", "xenc"));
        namespaces.add(factory.createOMNamespace("http://www.w3.org/2000/09/xmldsig#", "ds"));
        namespaces.add(factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse"));
        namespaces.add(factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu"));
        return namespaces;
    }

    public static List<WSEncryptionPart> getContentEncryptedElements(List<WSEncryptionPart> encryptedPartsElements, SOAPEnvelope envelope, List<String> elements, Map<String, String> decNamespaces) {
        Set<OMNamespace> namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)envelope, decNamespaces);
        for (String expression : elements) {
            try {
                AXIOMXPath xp = new AXIOMXPath(expression);
                for (OMNamespace objectNamespace : namespaces) {
                    xp.addNamespace(objectNamespace.getPrefix(), objectNamespace.getNamespaceURI());
                }
                List selectedNodes = xp.selectNodes((Object)envelope);
                for (OMElement selectedNode : selectedNodes) {
                    String localName = selectedNode.getLocalName();
                    String namespace = selectedNode.getNamespace() != null ? selectedNode.getNamespace().getNamespaceURI() : null;
                    OMAttribute wsuIdAttribute = selectedNode.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    String wsuId = null;
                    if (wsuIdAttribute != null) {
                        wsuId = wsuIdAttribute.getAttributeValue();
                    }
                    encryptedPartsElements.add(RampartUtil.createEncryptionPart(localName, wsuId, namespace, "Content", expression));
                }
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return encryptedPartsElements;
    }

    public static WSEncryptionPart createEncryptionPart(String name, String id) {
        return RampartUtil.createEncryptionPart(name, id, null, null, null);
    }

    public static WSEncryptionPart createEncryptionPart(String name, String id, String namespace, String modifier) {
        return RampartUtil.createEncryptionPart(name, id, namespace, modifier, null);
    }

    public static WSEncryptionPart createEncryptionPart(String name, String id, String namespace, String modifier, String xPath) {
        assert (name != null);
        WSEncryptionPart wsEncryptionPart = new WSEncryptionPart(name, namespace, modifier);
        wsEncryptionPart.setId(id);
        wsEncryptionPart.setXpath(xPath);
        return wsEncryptionPart;
    }

    public static List<WSEncryptionPart> getPartsAndElements(boolean sign, SOAPEnvelope envelope, boolean includeBody, List<WSEncryptionPart> parts, List<String> elements, Map<String, String> decNamespaces) {
        ArrayList<Object> found = new ArrayList<Object>();
        ArrayList<WSEncryptionPart> result = new ArrayList<WSEncryptionPart>();
        if (includeBody) {
            String wsuId = RampartUtil.addWsuIdToElement((OMElement)envelope.getBody());
            if (sign) {
                result.add(RampartUtil.createEncryptionPart(envelope.getBody().getLocalName(), wsuId, null, null));
            } else {
                result.add(RampartUtil.createEncryptionPart(envelope.getBody().getLocalName(), wsuId, null, "Content"));
            }
            found.add(envelope.getBody());
        }
        SOAPHeader header = envelope.getHeader();
        for (WSEncryptionPart part : parts) {
            if (part.getName() == null) {
                Iterator headerList = header.getHeaderBlocksWithNamespaceURI(part.getNamespace());
                while (headerList.hasNext()) {
                    SOAPHeaderBlock shb = (SOAPHeaderBlock)headerList.next();
                    OMElement e = header.getFirstChildWithName(shb.getQName());
                    if (found.contains(e)) continue;
                    found.add(e);
                    if (sign) {
                        result.add(RampartUtil.createEncryptionPart(e.getLocalName(), null, part.getNamespace(), "Content"));
                        continue;
                    }
                    OMAttribute wsuIdAttribute = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    String wsuId = null;
                    if (wsuIdAttribute != null) {
                        wsuId = wsuIdAttribute.getAttributeValue();
                    }
                    result.add(RampartUtil.createEncryptionPart(e.getLocalName(), wsuId, part.getNamespace(), "Element"));
                }
                continue;
            }
            OMElement e = header.getFirstChildWithName(new QName(part.getNamespace(), part.getName()));
            if (e == null || found.contains(e)) continue;
            found.add(e);
            OMAttribute wsuId = e.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
            if (wsuId != null) {
                part.setEncId(wsuId.getAttributeValue());
            }
            result.add(part);
        }
        Set<OMNamespace> namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)envelope, decNamespaces);
        for (String expression : elements) {
            try {
                AXIOMXPath xp = new AXIOMXPath(expression);
                for (OMNamespace objectNamespace : namespaces) {
                    xp.addNamespace(objectNamespace.getPrefix(), objectNamespace.getNamespaceURI());
                }
                List selectedNodes = xp.selectNodes((Object)envelope);
                for (OMElement selectedNode : selectedNodes) {
                    String namespace;
                    String localName = selectedNode.getLocalName();
                    String string = namespace = selectedNode.getNamespace() != null ? selectedNode.getNamespace().getNamespaceURI() : null;
                    if (sign) {
                        result.add(RampartUtil.createEncryptionPart(localName, null, namespace, "Content", expression));
                        continue;
                    }
                    OMAttribute wsuIdAttribute = selectedNode.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
                    String wsuId = null;
                    if (wsuIdAttribute != null) {
                        wsuId = wsuIdAttribute.getAttributeValue();
                    }
                    result.add(RampartUtil.createEncryptionPart(localName, wsuId, namespace, "Element", expression));
                }
            }
            catch (JaxenException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static boolean checkRequiredElements(SOAPEnvelope envelope, Map<String, String> decNamespaces, String expression) {
        SOAPHeader header = envelope.getHeader();
        Set<OMNamespace> namespaces = RampartUtil.findAllPrefixNamespaces((OMElement)header, decNamespaces);
        try {
            AXIOMXPath xp = new AXIOMXPath(expression);
            for (OMNamespace namespace : namespaces) {
                xp.addNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
            }
            List selectedNodes = xp.selectNodes((Object)header);
            if (selectedNodes.size() == 0) {
                return false;
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static KeyGenerator getEncryptionKeyGenerator(String symEncrAlgo) throws WSSecurityException {
        KeyGenerator keyGen;
        block6: {
            try {
                keyGen = KeyGenerator.getInstance("AES");
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
                    keyGen = KeyGenerator.getInstance("DESede");
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
                    keyGen.init(128);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
                    keyGen.init(192);
                    break block6;
                }
                if (symEncrAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
                    keyGen.init(256);
                    break block6;
                }
                return null;
            }
            catch (NoSuchAlgorithmException e) {
                throw new WSSecurityException(2, null, null, (Throwable)e);
            }
        }
        return keyGen;
    }

    public static String getContextIdentifierKey(MessageContext msgContext) {
        return msgContext.getAxisService().getName();
    }

    public static Map<String, String> getContextMap(MessageContext msgContext) {
        Hashtable contextMap = (Hashtable)msgContext.getConfigurationContext().getProperty("contextMap");
        if (contextMap == null) {
            contextMap = new Hashtable();
            msgContext.getConfigurationContext().setProperty("contextMap", contextMap);
        }
        return contextMap;
    }

    public static boolean isTokenValid(RampartMessageData rmd, String id) throws RampartException {
        try {
            Token token = rmd.getTokenStorage().getToken(id);
            return token != null && token.getState() == 1;
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken");
        }
    }

    public static void setEncryptionUser(RampartMessageData rmd, WSSecEncryptedKey encrKeyBuilder) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        String encrUser = rpd.getRampartConfig().getEncryptionUser();
        RampartUtil.setEncryptionUser(rmd, encrKeyBuilder, encrUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setEncryptionUser(RampartMessageData rmd, WSSecEncryptedKey encrKeyBuilder, String encrUser) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        if (encrUser == null) {
            encrUser = rpd.getRampartConfig().getEncryptionUser();
        }
        if (encrUser == null || "".equals(encrUser)) {
            throw new RampartException("missingEncryptionUser");
        }
        if (encrUser.equals("useReqSigCert")) {
            List resultsObj = (List)rmd.getMsgContext().getProperty("RECV_RESULTS");
            if (resultsObj == null) throw new RampartException("noSecurityResults");
            encrKeyBuilder.setUseThisCert(RampartUtil.getReqSigCert(resultsObj));
            if (!encrKeyBuilder.isCertSet()) return;
            encrKeyBuilder.setUserInfo(RampartUtil.getUsername(resultsObj));
            return;
        } else {
            encrKeyBuilder.setUserInfo(encrUser);
        }
    }

    public static void setKeyIdentifierType(RampartMessageData rmd, WSSecBase secBase, org.apache.ws.secpolicy.model.Token token) {
        boolean useReference;
        boolean bl = useReference = token.getInclusion() == 1 || !rmd.isInitiator() && token.getInclusion() == 3 || rmd.isInitiator() && token.getInclusion() == 4;
        if (useReference) {
            boolean tokenTypeSet = false;
            if (token instanceof X509Token) {
                X509Token x509Token = (X509Token)token;
                if (x509Token.isRequireIssuerSerialReference()) {
                    secBase.setKeyIdentifierType(2);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireKeyIdentifierReference()) {
                    secBase.setKeyIdentifierType(4);
                    tokenTypeSet = true;
                } else if (x509Token.isRequireThumbprintReference()) {
                    secBase.setKeyIdentifierType(8);
                    tokenTypeSet = true;
                }
            }
            if (!tokenTypeSet) {
                RampartPolicyData rpd = rmd.getPolicyData();
                Wss11 wss = rpd.getWss11();
                if (wss == null) {
                    wss = rpd.getWss10();
                }
                if (wss.isMustSupportRefKeyIdentifier()) {
                    secBase.setKeyIdentifierType(4);
                } else if (wss.isMustSupportRefIssuerSerial()) {
                    secBase.setKeyIdentifierType(2);
                } else if (wss instanceof Wss11 && wss.isMustSupportRefThumbprint()) {
                    secBase.setKeyIdentifierType(8);
                }
            }
        } else {
            secBase.setKeyIdentifierType(1);
        }
    }

    private static X509Certificate getReqSigCert(List<WSHandlerResult> results) {
        for (WSHandlerResult result : results) {
            List wsSecEngineResults = result.getResults();
            for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                if (actInt != 2) continue;
                return (X509Certificate)wsSecEngineResult.get((Object)"x509-certificate");
            }
        }
        return null;
    }

    public static String getUsername(List<WSHandlerResult> results) {
        for (WSHandlerResult result : results) {
            List wsSecEngineResults = result.getResults();
            for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                if (actInt != 1) continue;
                WSUsernameTokenPrincipal principal = (WSUsernameTokenPrincipal)wsSecEngineResult.get((Object)"principal");
                return principal.getName();
            }
        }
        return null;
    }

    public static String getRequestEncryptedKeyId(List<WSHandlerResult> results) {
        for (WSHandlerResult result : results) {
            List wsSecEngineResults = result.getResults();
            for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                String encrKeyId = (String)wsSecEngineResult.get((Object)"id");
                if (actInt != 4 || encrKeyId == null) continue;
                if (encrKeyId.length() > 0) {
                    return encrKeyId;
                }
                LOGGER.debug("Found encryption security processing result with empty id, skipping it: " + wsSecEngineResult);
            }
        }
        return null;
    }

    public static byte[] getRequestEncryptedKeyValue(List<WSHandlerResult> results) {
        for (WSHandlerResult result : results) {
            List wsSecEngineResults = result.getResults();
            for (WSSecurityEngineResult wsSecEngineResult : wsSecEngineResults) {
                Integer actInt = (Integer)wsSecEngineResult.get((Object)"action");
                byte[] decryptedKey = (byte[])wsSecEngineResult.get((Object)"secret");
                if (actInt != 4 || decryptedKey == null) continue;
                return decryptedKey;
            }
        }
        return null;
    }

    public static Element insertSiblingAfterOrPrepend(RampartMessageData rmd, Element child, Element elem) {
        Element retElem = null;
        retElem = child != null ? RampartUtil.insertSiblingAfter(rmd, child, elem) : RampartUtil.prependSecHeader(rmd, elem);
        return retElem;
    }

    public static Element insertSiblingBeforeOrPrepend(RampartMessageData rmd, Element child, Element elem) {
        Element retElem = null;
        retElem = child != null && child.getPreviousSibling() != null ? RampartUtil.insertSiblingBefore(rmd, child, elem) : RampartUtil.prependSecHeader(rmd, elem);
        return retElem;
    }

    private static Element prependSecHeader(RampartMessageData rmd, Element elem) {
        Element retElem = null;
        Element secHeaderElem = rmd.getSecHeader().getSecurityHeader();
        Node node = secHeaderElem.getOwnerDocument().importNode(elem, true);
        Element firstElem = (Element)secHeaderElem.getFirstChild();
        if (firstElem == null) {
            retElem = (Element)secHeaderElem.appendChild(node);
        } else if (firstElem.getOwnerDocument().equals(elem.getOwnerDocument())) {
            ((OMElement)firstElem).insertSiblingBefore((OMNode)((OMElement)elem));
            retElem = elem;
        } else {
            Element newSib = (Element)firstElem.getOwnerDocument().importNode(elem, true);
            ((OMElement)firstElem).insertSiblingBefore((OMNode)((OMElement)newSib));
            retElem = newSib;
        }
        return retElem;
    }

    public static boolean isSecHeaderRequired(RampartPolicyData rpd, boolean initiator, boolean inflow) {
        if (rpd.isIncludeTimestamp()) {
            return true;
        }
        if (rpd.isSignBody() || rpd.getSignedParts().size() != 0 || rpd.getSignedElements().size() != 0) {
            return true;
        }
        if (rpd.isEncryptBody() || rpd.getEncryptedParts().size() != 0 || rpd.getEncryptedElements().size() != 0) {
            return true;
        }
        if (!initiator && inflow || initiator && !inflow) {
            List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
            for (SupportingToken supportingTok : supportingToks) {
                if (supportingTok == null || supportingTok.getTokens().size() == 0) continue;
                return true;
            }
            SupportingToken supportingTokens = rpd.getSignedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEndorsingSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEndorsingSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getEndorsingEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
            supportingTokens = rpd.getSignedEndorsingEncryptedSupportingTokens();
            if (supportingTokens != null && supportingTokens.getTokens().size() != 0) {
                return true;
            }
        }
        return false;
    }

    public static void handleEncryptedSignedHeaders(List<WSEncryptionPart> encryptedParts, List<WSEncryptionPart> signedParts, Document doc) {
        for (WSEncryptionPart signedPart : signedParts) {
            if (signedPart.getNamespace() == null || signedPart.getName() == null) continue;
            for (WSEncryptionPart encryptedPart : encryptedParts) {
                Element encHeader;
                String encHeaderId;
                if (encryptedPart.getNamespace() == null || encryptedPart.getName() == null || !signedPart.getName().equals(encryptedPart.getName()) || !signedPart.getNamespace().equals(encryptedPart.getNamespace())) continue;
                String encDataID = encryptedPart.getEncId();
                Element encDataElem = WSSecurityUtil.findElementById((Node)doc.getDocumentElement(), (String)encDataID, (boolean)false);
                if (encDataElem == null || "".equals((encHeaderId = (encHeader = (Element)encDataElem.getParentNode()).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")).trim())) continue;
                signedParts.remove(signedPart);
                signedParts.add(RampartUtil.createEncryptionPart(signedPart.getName(), encHeaderId, signedPart.getNamespace(), signedPart.getEncModifier(), signedPart.getXpath()));
            }
        }
    }

    public static String getSigElementId(RampartMessageData rmd) {
        SOAPEnvelope envelope = rmd.getMsgContext().getEnvelope();
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            return null;
        }
        Iterator secHeaders = header.getHeaderBlocksWithNamespaceURI("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (secHeaders != null && secHeaders.hasNext()) {
            SOAPHeaderBlock firstSecHeader = (SOAPHeaderBlock)secHeaders.next();
            QName sigQName = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
            QName wsuIdQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            OMElement sigElem = firstSecHeader.getFirstChildWithName(sigQName);
            OMAttribute wsuId = sigElem.getAttribute(wsuIdQName);
            if (wsuId != null) {
                return wsuId.getAttributeValue();
            }
            wsuId = sigElem.getAttribute(new QName("Id"));
            if (wsuId != null) {
                return wsuId.getAttributeValue();
            }
        }
        return null;
    }

    public static WSSConfig getWSSConfigInstance() {
        WSSConfig defaultWssConfig = WSSConfig.getNewInstance();
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setEnableSignatureConfirmation(defaultWssConfig.isEnableSignatureConfirmation());
        wssConfig.setTimeStampStrict(defaultWssConfig.isTimeStampStrict());
        wssConfig.setWsiBSPCompliant(defaultWssConfig.isWsiBSPCompliant());
        wssConfig.setPrecisionInMilliSeconds(defaultWssConfig.isPrecisionInMilliSeconds());
        return wssConfig;
    }

    public static void validateTransport(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        if (rpd == null) {
            return;
        }
        if (rpd.isTransportBinding() && !rmd.isInitiator() && rpd.getTransportToken() instanceof HttpsToken) {
            MessageContext messageContext;
            HttpServletRequest request;
            String incomingTransport = rmd.getMsgContext().getIncomingTransportName();
            if (!incomingTransport.equals("https")) {
                throw new RampartException("invalidTransport", new String[]{incomingTransport});
            }
            if (((HttpsToken)rpd.getTransportToken()).isRequireClientCertificate() && ((request = (HttpServletRequest)(messageContext = rmd.getMsgContext()).getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)) == null || request.getAttribute("javax.servlet.request.X509Certificate") == null)) {
                throw new RampartException("clientAuthRequired");
            }
        }
    }

    private static Crypto retrieveCryptoFromCache(String cryptoKey, String refreshInterval) {
        if (cryptoStore.containsKey(cryptoKey)) {
            CachedCrypto cachedCrypto = cryptoStore.get(cryptoKey);
            if (refreshInterval != null) {
                if (cachedCrypto.creationTime + Long.parseLong(refreshInterval) > Calendar.getInstance().getTimeInMillis()) {
                    LOGGER.debug("Cache Hit : Crypto Object was found in cache.");
                    return cachedCrypto.crypto;
                }
                LOGGER.debug("Cache Miss : Crypto Object found in cache is expired.");
                return null;
            }
            LOGGER.debug("Cache Hit : Crypto Object was found in cache.");
            return cachedCrypto.crypto;
        }
        LOGGER.debug("Cache Miss : Crypto Object was not found in cache.");
        return null;
    }

    private static void cacheCrypto(String cryptoKey, Crypto crypto) {
        cryptoStore.put(cryptoKey, new CachedCrypto(crypto, Calendar.getInstance().getTimeInMillis()));
        LOGGER.debug("Crypto object is inserted into the Cache.");
    }

    public static String getSAML10AssertionNamespace() {
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    }

    public static void setEncryptionCrypto(MessageContext msgContext) {
        RampartUtil.setEncryptionCryptoFileProperty(msgContext);
        RampartUtil.setEncryptionCryptoReferenceProperty(msgContext);
    }

    public static void setDecryptionCrypto(MessageContext msgContext) {
        RampartUtil.setDecryptionCryptoFileProperty(msgContext);
        RampartUtil.setDecryptionCryptoReferenceProperty(msgContext);
    }

    private static void setEncryptionCryptoReferenceProperty(MessageContext msgContext) {
        RampartUtil.setCryptoProperty(msgContext, "signaturePropRefId", "encryptionPropRefId");
    }

    private static void setDecryptionCryptoReferenceProperty(MessageContext msgContext) {
        RampartUtil.setCryptoProperty(msgContext, "signaturePropRefId", "decryptionPropRefId");
    }

    private static void setEncryptionCryptoFileProperty(MessageContext msgContext) {
        RampartUtil.setCryptoProperty(msgContext, "signaturePropFile", "encryptionPropFile");
    }

    private static void setDecryptionCryptoFileProperty(MessageContext msgContext) {
        RampartUtil.setCryptoProperty(msgContext, "signaturePropFile", "decryptionPropFile");
    }

    private static void setCryptoProperty(MessageContext msgContext, String signaturePropertyName, String cryptoPropertyName) {
        if (msgContext.getProperty(cryptoPropertyName) == null) {
            String signaturePropertyFile = (String)msgContext.getProperty(signaturePropertyName);
            if (signaturePropertyFile == null) {
                LOGGER.debug("Signature crypto property file is not set. Property file key - signaturePropFile");
            } else {
                msgContext.setProperty(cryptoPropertyName, (Object)signaturePropertyFile);
            }
        }
    }

    public static boolean encryptFirst(RampartPolicyData rpd) {
        return "EncryptBeforeSigning".equals(rpd.getProtectionOrder());
    }

    public static boolean isSecurityFault(SOAPFault fault) {
        String soapVersionURI = fault.getNamespaceURI();
        SOAPFaultCode code = fault.getCode();
        if (code == null) {
            return false;
        }
        if (soapVersionURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return RampartUtil.isSecurityFaultCode((SOAPFaultClassifier)code);
        }
        SOAPFaultSubCode subCode = code.getSubCode();
        return subCode != null && RampartUtil.isSecurityFaultCode((SOAPFaultClassifier)subCode);
    }

    private static boolean isSecurityFaultCode(SOAPFaultClassifier code) {
        QName value = code.getValueAsQName();
        return value != null && value.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
    }

    public static Collection<UsernameToken> getUsernameTokens(RampartPolicyData rpd) {
        ArrayList<UsernameToken> usernameTokens = new ArrayList<UsernameToken>();
        List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
        for (SupportingToken suppTok : supportingToks) {
            usernameTokens.addAll(RampartUtil.getUsernameTokens(suppTok));
        }
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getSignedSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getSignedEndorsingSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getEndorsingSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getEncryptedSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getSignedEncryptedSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getEndorsingEncryptedSupportingTokens()));
        usernameTokens.addAll(RampartUtil.getUsernameTokens(rpd.getSignedEndorsingEncryptedSupportingTokens()));
        return usernameTokens;
    }

    public static Collection<UsernameToken> getUsernameTokens(SupportingToken suppTok) {
        if (suppTok == null) {
            return new ArrayList<UsernameToken>();
        }
        ArrayList<UsernameToken> usernameTokens = new ArrayList<UsernameToken>();
        for (org.apache.ws.secpolicy.model.Token token : suppTok.getTokens()) {
            if (!(token instanceof UsernameToken)) continue;
            usernameTokens.add((UsernameToken)token);
        }
        return usernameTokens;
    }

    private static class CachedCrypto {
        private final Crypto crypto;
        private final long creationTime;

        public CachedCrypto(Crypto crypto, long creationTime) {
            this.crypto = crypto;
            this.creationTime = creationTime;
        }
    }
}

