/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.testutils;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class FakeValidationDateAspect {
    private static final Date VALIDATION_DATE;

    @Around(value="call(void java.security.cert.X509Certificate.checkValidity()) && target(cert)")
    public void aroundCheckValidity(X509Certificate cert) throws CertificateExpiredException, CertificateNotYetValidException {
        cert.checkValidity(VALIDATION_DATE);
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        cal.set(2018, 0, 1);
        VALIDATION_DATE = cal.getTime();
    }
}

