/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.aop.aspect;

import java.lang.annotation.Annotation;
import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.ow2.dragon.aop.annotation.NotNullParam;

@Aspect
public class CheckParameterNullityForServices {
    private final Logger logger = Logger.getLogger(this.getClass());

    @Pointcut(value="within(org.ow2.dragon..*) && execution(public * *(..)) && @annotation(org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull)")
    private void publicMethodAllArgsNotNull() {
    }

    @Pointcut(value="within(org.ow2.dragon..*) && execution(public * *(..)) && @annotation(org.ow2.dragon.aop.annotation.CheckArgumentsNotNull)")
    private void publicMethodSomeArgsNotNull() {
    }

    @Around(value="publicMethodAllArgsNotNull()")
    public Object beforePublicAllArgsNotNull(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                throw new NullPointerException("Arg " + i + " of method '" + pjp.getSignature().getName() + "' must not be null");
            }
        }
        return pjp.proceed();
    }

    @Around(value="publicMethodSomeArgsNotNull()")
    public Object beforePublicSomeArgsNotNull(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Annotation[][] argAnnots = methodSignature.getMethod().getParameterAnnotations();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annots = argAnnots[i];
                if (annots == null) continue;
                boolean annotFound = false;
                for (int j = 0; j < annots.length && !annotFound; ++j) {
                    if (!(annots[j] instanceof NotNullParam)) continue;
                    this.logger.debug((Object)("##### NotNullParam annotation found on arg " + i));
                    annotFound = true;
                    if (args[i] != null) continue;
                    throw new NullPointerException("Arg " + i + " of method '" + pjp.getSignature() + "' must not be null");
                }
            }
        }
        return pjp.proceed();
    }
}

