/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.metadata.SimpleFileTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.deployment.AttachedDocument;
import org.ow2.dragon.service.deployment.ServiceManagerService;
import org.ow2.dragon.util.InputStreamUtil;

@WebService(endpointInterface="org.ow2.dragon.service.deployment.ServiceManagerService")
public class ServiceManagerServiceImpl
implements ServiceManagerService {
    private TechServiceManager techServiceManager;

    @Override
    public void removeService(String serviceId) throws DragonFault {
        try {
            this.techServiceManager.removeTechService(serviceId);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public List<TechnicalServiceTO> getAllTechServices(RequestOptionsTO requestOptions) throws DragonFault {
        List result = null;
        try {
            result = this.techServiceManager.getAllTechServices(requestOptions);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    public void setTechServiceManager(TechServiceManager techServiceManager) {
        this.techServiceManager = techServiceManager;
    }

    @Override
    public TechnicalServiceTO getService(String serviceId) throws DragonFault {
        TechnicalServiceTO result = null;
        try {
            result = this.techServiceManager.getTechService(serviceId, null);
        }
        catch (Throwable e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public String addRelatedDoc(String serviceId, String mimetype, AttachedDocument attachedDocument, String fileName) throws DragonFault {
        String result = null;
        try {
            DataHandler desc = attachedDocument.getDocument();
            byte[] docContent = InputStreamUtil.getBytes((InputStream)desc.getInputStream());
            result = this.techServiceManager.registerRelatedDoc(serviceId, mimetype, docContent, fileName);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return result;
    }

    @Override
    public void addCategory(String techServiceId, String categoryId, String categoryValue, String categoryDesc) throws DragonFault {
        try {
            this.techServiceManager.addCategory(techServiceId, categoryId, categoryValue, categoryDesc);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public void addCategory(String techServiceId, String categoryId, String categoryValueId) throws DragonFault {
        try {
            this.techServiceManager.addCategory(techServiceId, categoryId, categoryValueId);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public List<KeyedRefTO> getCategoriesForTechServ(String techServiceId) throws DragonFault {
        try {
            return this.techServiceManager.getCategoriesForTechServ(techServiceId);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public AttachedDocument getRelatedDocContent(String relatedDocId) throws DragonFault {
        AttachedDocument attachedDocument = null;
        try {
            attachedDocument = new AttachedDocument();
            InputStream inputStream = this.techServiceManager.getRelatedDocContent(relatedDocId);
            attachedDocument.setDocument(new DataHandler((DataSource)new ByteArrayDataSource(inputStream, null)));
        }
        catch (Exception e) {
            throw new DragonFault(e.getMessage(), e);
        }
        return attachedDocument;
    }

    @Override
    public List<SimpleFileTO> getRelatedDocsForTechServ(String techServiceId) throws DragonFault {
        try {
            return this.techServiceManager.getRelatedDocsForTechServ(techServiceId);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public void removeCategories(String techServiceId, List<String> categoryIds) throws DragonFault {
        try {
            this.techServiceManager.removeCategories(techServiceId, categoryIds);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public List<TechnicalServiceTO> searchTechService(String searchCriteria, List<ServiceSearchProperties> searchedProperties, RequestOptionsTO iOptions) throws DragonFault {
        try {
            return this.techServiceManager.searchTechService(searchCriteria, searchedProperties, iOptions);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }

    @Override
    public String updateTechService(TechnicalServiceTO techServiceTO) throws DragonFault {
        try {
            return this.techServiceManager.updateTechService(techServiceTO);
        }
        catch (DeploymentException e) {
            throw new DragonFault(e.getMessage(), e);
        }
    }
}

