/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdl;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.service.DragonFault;
import org.ow2.dragon.service.util.HashMapAdapter;
import org.ow2.dragon.service.wsdl.AttachedDescription;
import org.ow2.dragon.service.wsdl.WSDLManagerService;
import org.ow2.dragon.util.XMLUtil;
import org.w3c.dom.Document;

@WebService(endpointInterface="org.ow2.dragon.service.wsdl.WSDLManagerService")
public class WSDLManagerServiceImpl
implements WSDLManagerService {
    private WSDLManager manager;

    public WSDLManager getManager() {
        return this.manager;
    }

    @Override
    public String[] importServiceDefFile(String wsdlURI) throws DragonFault {
        String[] result = null;
        try {
            URI uri = URI.create(wsdlURI);
            result = this.manager.importServiceDefFile(uri);
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    @Override
    public String[] importServiceDefFileWithRelativeImports(String wsdlURI, @XmlJavaTypeAdapter(value=HashMapAdapter.class) HashMap<String, String> imports) throws DragonFault {
        String[] result = null;
        try {
            URI uri = URI.create(wsdlURI);
            HashMap<String, URI> importsURIs = new HashMap<String, URI>();
            for (String key : imports.keySet()) {
                importsURIs.put(key, URI.create(imports.get(key)));
            }
            result = this.manager.importServiceDefFile(uri, importsURIs, null);
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    public void setManager(WSDLManager manager) {
        this.manager = manager;
    }

    @Override
    public String[] importServiceDefFile(AttachedDescription attachedDescription) throws DragonFault {
        String[] result = null;
        try {
            DataHandler desc = attachedDescription.getDescription();
            Document documentDesc = XMLUtil.loadDocument((InputStream)desc.getInputStream());
            documentDesc.setDocumentURI(".");
            result = this.manager.importServiceDefFile(documentDesc);
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    @Override
    public List<String> loadServiceDescsAsString(String serviceId) throws DragonFault {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List specs = this.manager.getServSpecsForTechServ(serviceId);
            if (specs != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : specs) {
                    result.add(this.manager.getWsdlDescAsString(serviceSpecificationTO.getId()));
                }
            }
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }

    @Override
    public List<AttachedDescription> loadServiceDescs(String serviceId) throws DragonFault {
        ArrayList<AttachedDescription> descriptions = new ArrayList<AttachedDescription>();
        try {
            List specs = this.manager.getServSpecsForTechServ(serviceId);
            if (specs != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : specs) {
                    InputStream inputStream = this.manager.getWsdlDesc(serviceSpecificationTO.getId());
                    AttachedDescription description = new AttachedDescription();
                    description.setDescription(new DataHandler((DataSource)new ByteArrayDataSource(inputStream, "application/octet-stream")));
                    descriptions.add(description);
                }
            }
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return descriptions;
    }

    @Override
    public List<AttachedDescription> loadEndpointDescs(String endpointId) throws DragonFault {
        ArrayList<AttachedDescription> descriptions = new ArrayList<AttachedDescription>();
        try {
            List specs = this.manager.getServSpecsForEndpoint(endpointId);
            if (specs != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : specs) {
                    InputStream inputStream = this.manager.getWsdlDesc(serviceSpecificationTO.getId());
                    AttachedDescription description = new AttachedDescription();
                    description.setDescription(new DataHandler((DataSource)new ByteArrayDataSource(inputStream, "application/octet-stream")));
                    descriptions.add(description);
                }
            }
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return descriptions;
    }

    @Override
    public List<String> loadEndpointDescsAsString(String endpointId) throws DragonFault {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List specs = this.manager.getServSpecsForEndpoint(endpointId);
            if (specs != null) {
                for (ServiceSpecificationTO serviceSpecificationTO : specs) {
                    result.add(this.manager.getWsdlDescAsString(serviceSpecificationTO.getId()));
                }
            }
        }
        catch (Throwable t) {
            throw new DragonFault(t.getMessage(), t);
        }
        return result;
    }
}

