/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:applicationContext-dao.xml", "classpath:applicationContext-test-hibernate.xml", "classpath:applicationContext-test-jdbc.xml", "classpath:applicationContext-transaction.xml", "classpath:applicationContext-test-compass.xml"})
public class CompassHibernateOnFlush {
    @Resource
    private SessionFactory sessionFactory;
    private Logger logger = Logger.getLogger(this.getClass());
    private Person person1;
    private Post post1;
    private Post post2;
    private Post post3;
    private TechnicalService service1;
    private Endpoint endpoint1;
    private Endpoint endpoint2;
    private Binding binding1;
    private BindingOperation bindingOperation1;
    private BindingOperation bindingOperation2;
    private Protocol protocol1;
    private ServiceInterface interface1;
    private SpecifiedOperation specifiedOperation1;
    private SpecifiedOperation specifiedOperation2;
    private Link partyToTechService1;
    private String serviceId;
    private String partyId;

    public org.hibernate.Session getHibernateSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void createTestData() {
        this.logger.debug((Object)"##### create test data");
        this.person1 = new Person();
        this.person1.setFirstName("foo1");
        this.person1.setMiddleName("bar1");
        this.person1.setLastName("foobar1");
        this.person1.setLocation("A1");
        this.post1 = new Post();
        this.post1.setName("post1");
        this.post1.setNature("nature1");
        this.post1.setDescription("desc1");
        this.service1 = new TechnicalService();
        this.setName(this.service1, "serv1");
        this.interface1 = new ServiceInterface();
        this.interface1.setFullName("interface1");
        this.specifiedOperation1 = new SpecifiedOperation();
        this.specifiedOperation1.setName("specOp1");
        this.specifiedOperation2 = new SpecifiedOperation();
        this.specifiedOperation2.setName("specOp2");
        this.endpoint1 = new Endpoint();
        this.endpoint1.setName("endpoint1");
        this.endpoint2 = new Endpoint();
        this.endpoint2.setName("endpoint2");
        this.bindingOperation1 = new BindingOperation();
        this.bindingOperation1.setSignature("sign1");
        this.bindingOperation2 = new BindingOperation();
        this.bindingOperation2.setSignature("sign2");
        this.protocol1 = new Protocol();
        Name nameObject = new Name();
        nameObject.setLangCode("EN-us");
        nameObject.setName("protocol1");
        this.protocol1.setName(nameObject);
        this.binding1 = new Binding();
        this.binding1.setFullName("binding1");
        this.person1.setPost(this.post1);
        this.interface1.addBinding(this.binding1);
        this.service1.addEndpoint(this.endpoint1);
        this.service1.addEndpoint(this.endpoint2);
        this.binding1.addProtocol(this.protocol1);
        this.binding1.addEndpoint(this.endpoint1);
        this.binding1.addEndpoint(this.endpoint2);
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        s.saveOrUpdate((Object)this.post1);
        s.saveOrUpdate((Object)this.person1);
        s.saveOrUpdate((Object)this.interface1);
        s.saveOrUpdate((Object)this.protocol1);
        s.saveOrUpdate((Object)this.binding1);
        this.interface1.addSpecifiedOp(this.specifiedOperation1);
        this.interface1.addSpecifiedOp(this.specifiedOperation2);
        this.specifiedOperation1.addBindingOp(this.bindingOperation1);
        this.specifiedOperation2.addBindingOp(this.bindingOperation2);
        this.binding1.addBindingOp(this.bindingOperation1);
        this.binding1.addBindingOp(this.bindingOperation2);
        s.saveOrUpdate((Object)this.specifiedOperation1);
        s.saveOrUpdate((Object)this.specifiedOperation2);
        s.saveOrUpdate((Object)this.bindingOperation1);
        s.saveOrUpdate((Object)this.bindingOperation2);
        s.saveOrUpdate((Object)this.interface1);
        s.saveOrUpdate((Object)this.binding1);
        s.saveOrUpdate((Object)this.service1);
        s.saveOrUpdate((Object)this.endpoint1);
        s.saveOrUpdate((Object)this.endpoint2);
        this.serviceId = this.service1.getId();
        this.partyId = this.person1.getId();
        s.flush();
        tx.commit();
        s.close();
    }

    private void setName(TechnicalService technicalServiceBO, String name) {
        Name nameObj = new Name();
        nameObj.setLangCode("EN-us");
        nameObj.setName(name);
        technicalServiceBO.addName(nameObj);
    }

    @Test
    public void testUpdateWithCollecionOnSecondaryObject() {
        this.createTestData();
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        Person person = (Person)s.get(Person.class, (Serializable)((Object)this.partyId));
        TechnicalService service = (TechnicalService)s.get(TechnicalService.class, (Serializable)((Object)this.serviceId));
        this.partyToTechService1 = new Link();
        this.partyToTechService1.setType("Owner");
        service.addToLink(this.partyToTechService1);
        person.addFromLink(this.partyToTechService1);
        s.saveOrUpdate((Object)this.partyToTechService1);
        s.flush();
        tx.commit();
        s.close();
        s = this.getSessionFactory().openSession();
        tx = s.beginTransaction();
        tx.begin();
        this.partyToTechService1 = (Link)s.get(Link.class, (Serializable)((Object)this.partyToTechService1.getId()));
        this.partyToTechService1.setType("Consumer");
        s.saveOrUpdate((Object)this.partyToTechService1);
        s.flush();
        tx.commit();
        s.close();
    }

    private List getAll(Class clazz, org.hibernate.Session s) {
        List result = new ArrayList();
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)clazz);
        Criteria executableCriteria = detachedCriteria.getExecutableCriteria(s);
        result = executableCriteria.list();
        return result;
    }

    private void deleteAll(org.hibernate.Session s, List objectList) {
        for (Object obj : objectList) {
            s.delete(obj);
        }
    }
}

