/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.generic;

import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.test.ASearchableClass;
import org.ow2.dragon.persistence.bo.test.UnitName;
import org.ow2.dragon.persistence.dao.ASearchableClassDAO;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class GenericHibernateCompassDAOImplTest
extends CommonDAOTestConfig {
    @Resource
    private ASearchableClassDAO aSearchableClassDAO;
    private ASearchableClass aClass1;
    private ASearchableClass aClass2;
    private ASearchableClass aClass3;
    private ASearchableClass aClass4;
    private UnitName name1;
    private UnitName name2;
    private UnitName name3;
    private UnitName name4;
    private UnitName name5;

    public void createSortTestData() {
        this.name1 = new UnitName("name1", null);
        this.name2 = new UnitName("name2", null);
        this.name3 = new UnitName("name3", null);
        this.name4 = new UnitName("name4", null);
        this.name5 = new UnitName("name5", null);
        this.aClass1 = new ASearchableClass();
        this.aClass1.setName("name1");
        this.aClass1.addUnitName(this.name1);
        this.aClass1.addUnitName(this.name2);
        this.aClass2 = new ASearchableClass();
        this.aClass2.setName("name2");
        this.aClass2.addUnitName(this.name2);
        this.aClass2.addUnitName(this.name3);
        this.aClass3 = new ASearchableClass();
        this.aClass3.setName("name3");
        this.aClass3.addUnitName(this.name5);
        this.aClass3.addUnitName(this.name4);
        this.aClass4 = new ASearchableClass();
        this.aClass4.setName("name4");
        this.aClass4.addUnitName(this.name4);
        this.aClass4.addUnitName(this.name3);
        this.aSearchableClassDAO.save((Object)this.aClass1);
        this.aSearchableClassDAO.save((Object)this.aClass2);
        this.aSearchableClassDAO.save((Object)this.aClass3);
        this.aSearchableClassDAO.save((Object)this.aClass4);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetAllSortOnUnitName() {
        this.createSortTestData();
        RequestOptions options = new RequestOptions();
        options.setSortAscendingly(true);
        options.setSortCriteria("units.name");
        options.setFetchCriteria("units");
        List as = this.aSearchableClassDAO.getAll(options);
        GenericHibernateCompassDAOImplTest.assertNotNull((Object)as);
        GenericHibernateCompassDAOImplTest.assertEquals((int)4, (int)as.size());
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass1), as.get(0));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass2), as.get(1));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass4), as.get(2));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass3), as.get(3));
        RequestOptions options2 = new RequestOptions();
        options2.setSortAscendingly(false);
        options2.setSortCriteria("units.name");
        options2.setFetchCriteria("units");
        List as2 = this.aSearchableClassDAO.getAll(options2);
        GenericHibernateCompassDAOImplTest.assertNotNull((Object)as2);
        GenericHibernateCompassDAOImplTest.assertEquals((int)4, (int)as2.size());
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass3), as2.get(0));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass4), as2.get(1));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass2), as2.get(2));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass1), as2.get(3));
    }

    @Test
    public void testGetAllSortOnUnitNamePaginate() {
        this.createSortTestData();
        RequestOptions options = new RequestOptions();
        options.setSortAscendingly(true);
        options.setSortCriteria("units.name");
        options.setFetchCriteria("units");
        options.setFirstResult(0);
        options.setNbOfResults(2);
        List as = this.aSearchableClassDAO.getAll(options);
        GenericHibernateCompassDAOImplTest.assertNotNull((Object)as);
        GenericHibernateCompassDAOImplTest.assertEquals((int)2, (int)as.size());
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass1), as.get(0));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass2), as.get(1));
        RequestOptions options2 = new RequestOptions();
        options2.setSortAscendingly(false);
        options2.setSortCriteria("units.name");
        options2.setFetchCriteria("units");
        options2.setFirstResult(2);
        options2.setNbOfResults(2);
        List as2 = this.aSearchableClassDAO.getAll(options2);
        GenericHibernateCompassDAOImplTest.assertNotNull((Object)as2);
        GenericHibernateCompassDAOImplTest.assertEquals((int)2, (int)as2.size());
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass2), as2.get(0));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass1), as2.get(1));
    }

    @Test
    public void testGetAllWithIdsSortOnName() {
        this.createSortTestData();
        RequestOptions options = new RequestOptions();
        options.setSortAscendingly(true);
        options.setSortCriteria("units.name");
        options.setFetchCriteria("units");
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.aClass3.getId());
        ids.add(this.aClass4.getId());
        List as = this.aSearchableClassDAO.getAll(ids, options);
        GenericHibernateCompassDAOImplTest.assertNotNull((Object)as);
        GenericHibernateCompassDAOImplTest.assertEquals((int)2, (int)as.size());
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass4), as.get(0));
        GenericHibernateCompassDAOImplTest.assertEquals((Object)((Object)this.aClass3), as.get(1));
    }
}

