/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.generic;

import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.test.AClass;
import org.ow2.dragon.persistence.bo.test.BClass;
import org.ow2.dragon.persistence.bo.test.CClass;
import org.ow2.dragon.persistence.bo.test.UnitName;
import org.ow2.dragon.persistence.dao.AClassDAO;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class UniversalHibernateDAOImplTest
extends CommonDAOTestConfig {
    @Resource
    private AClassDAO aClassDAO;
    private AClass aClass1;
    private AClass aClass2;
    private AClass aClass3;
    private AClass aClass4;
    private BClass bClass1;
    private BClass bClass2;
    private BClass bClass3;
    private CClass cClass1;
    private CClass cClass2;
    private CClass cClass3;
    private UnitName name1;
    private UnitName name2;
    private UnitName name3;
    private UnitName name4;
    private UnitName name5;

    public void createTestData() {
        this.name1 = new UnitName("name1", null);
        this.name2 = new UnitName("name2", null);
        this.name3 = new UnitName("name3", null);
        this.cClass1 = new CClass(this.name1);
        this.cClass2 = new CClass(this.name3, this.name2);
        this.cClass3 = new CClass(this.name3);
        this.bClass1 = new BClass(this.name1);
        this.bClass1.setAnOrderField("b1");
        this.bClass2 = new BClass(this.name3, this.name2);
        this.bClass2.setAnOrderField("b2");
        this.bClass3 = new BClass(this.name3);
        this.bClass3.setAnOrderField("b3");
        this.aClass1 = new AClass();
        this.aClass1.setName("a1");
        this.aClass1.addBClass(this.bClass2);
        this.aClass1.addBClass(this.bClass3);
        this.aClass1.addCClass(this.cClass2);
        this.aClass1.addCClass(this.cClass3);
        this.aClass2 = new AClass();
        this.aClass2.setName("a2");
        this.aClass2.addBClass(this.bClass1);
        this.aClass2.addBClass(this.bClass3);
        this.aClass2.addCClass(this.cClass3);
        this.aClassDAO.save((Object)this.aClass1);
        this.aClassDAO.save((Object)this.aClass2);
        this.getHibernateSession().flush();
    }

    public void createSortTestData() {
        this.name1 = new UnitName("name1", null);
        this.name2 = new UnitName("name2", null);
        this.name3 = new UnitName("name3", null);
        this.name4 = new UnitName("name4", null);
        this.name5 = new UnitName("name5", null);
        this.aClass1 = new AClass();
        this.aClass1.setName("name1");
        this.aClass1.addUnitName(this.name1);
        this.aClass1.addUnitName(this.name2);
        this.aClass2 = new AClass();
        this.aClass2.setName("name2");
        this.aClass2.addUnitName(this.name2);
        this.aClass2.addUnitName(this.name3);
        this.aClass3 = new AClass();
        this.aClass3.setName("name3");
        this.aClass3.addUnitName(this.name5);
        this.aClass3.addUnitName(this.name4);
        this.aClass4 = new AClass();
        this.aClass4.setName("name4");
        this.aClass4.addUnitName(this.name4);
        this.aClass4.addUnitName(this.name3);
        this.aClassDAO.save((Object)this.aClass1);
        this.aClassDAO.save((Object)this.aClass2);
        this.aClassDAO.save((Object)this.aClass3);
        this.aClassDAO.save((Object)this.aClass4);
        this.getHibernateSession().flush();
    }

    @Test
    public void testSearch() {
        this.createTestData();
        String[] criteria = new String[]{this.name1.getName()};
        String[] properties = new String[]{"bs.names.name", "cs.names.name"};
        List aClasses = this.aClassDAO.searchEquals(criteria, properties, null);
        UniversalHibernateDAOImplTest.assertNotNull((String)"AClass list must not be null", (Object)aClasses);
        UniversalHibernateDAOImplTest.assertEquals((String)"Bad number of results", (int)1, (int)aClasses.size());
        UniversalHibernateDAOImplTest.assertTrue((String)"Bad list of organization name", (boolean)aClasses.contains((Object)this.aClass2));
    }

    @Test
    public void testSearch2() {
        this.createTestData();
        Search search = new Search();
        search.setDistinct(true);
        search.setSearchClass(AClass.class);
        search.addFilter(Filter.equal((String)"bs.names.name", (Object)this.name3.getName()));
        search.addSort("bs.anOrderField", false);
        search.addFetch("bs");
        List aclasses = this.aClassDAO.search((IMutableSearch)search);
        for (int i = 0; i < aclasses.size(); ++i) {
            UniversalHibernateDAOImplTest.assertEquals((String)((AClass)((Object)aclasses.get(0))).getName(), (String)"a1");
            UniversalHibernateDAOImplTest.assertEquals((String)((AClass)((Object)aclasses.get(1))).getName(), (String)"a2");
        }
    }

    @Test
    public void testPrePersistCallback() {
        AClass aClass1 = new AClass();
        this.aClassDAO.save((Object)aClass1);
        this.getHibernateSession().flush();
        UniversalHibernateDAOImplTest.assertNotNull((Object)aClass1.getCreated());
        UniversalHibernateDAOImplTest.assertNotNull((Object)aClass1.getLastUpdated());
    }

    @Test
    public void testGetAllSortOnName() {
        this.createSortTestData();
        RequestOptions options = new RequestOptions();
        options.setSortAscendingly(true);
        options.setSortCriteria("name");
        List as = this.aClassDAO.getAll(options);
        UniversalHibernateDAOImplTest.assertNotNull((Object)as);
        UniversalHibernateDAOImplTest.assertEquals((int)4, (int)as.size());
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass1), as.get(0));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass2), as.get(1));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass3), as.get(2));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass4), as.get(3));
        RequestOptions options2 = new RequestOptions();
        options2.setSortAscendingly(false);
        options2.setSortCriteria("name");
        List as2 = this.aClassDAO.getAll(options2);
        UniversalHibernateDAOImplTest.assertNotNull((Object)as2);
        UniversalHibernateDAOImplTest.assertEquals((int)4, (int)as2.size());
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass4), as2.get(0));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass3), as2.get(1));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass2), as2.get(2));
        UniversalHibernateDAOImplTest.assertEquals((Object)((Object)this.aClass1), as2.get(3));
    }
}

