/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.metadata;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.util.ContentType;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class SimpleFileDAOTest
extends CommonDAOTestConfig {
    @Resource
    private SimpleFileDAO simpleFileDAO;
    private SimpleFile simpleFile1;

    public void createTestData() {
        this.simpleFile1 = new SimpleFile();
        this.simpleFile1.setAuthor("foo");
        this.simpleFile1.setExtractedContent("dfsfsdfqf");
        this.simpleFile1.setFileType(ContentType.PDF);
        this.simpleFile1.setTitle("bar");
        this.simpleFileDAO.save((Object)this.simpleFile1);
    }

    @Test
    public void testCRUD() {
        this.createTestData();
        List result = this.simpleFileDAO.searchEquals(new String[]{this.simpleFile1.getAuthor()}, new String[]{"author"}, null);
        SimpleFileDAOTest.assertNotNull((Object)result);
        SimpleFileDAOTest.assertEquals((int)1, (int)result.size());
        SimpleFile fileResult = (SimpleFile)result.get(0);
        fileResult.setAuthor("foobar");
        this.simpleFileDAO.save((Object)fileResult);
        result = this.simpleFileDAO.searchEquals(new String[]{"foobar"}, new String[]{"author"}, null);
        SimpleFileDAOTest.assertNotNull((Object)result);
        SimpleFileDAOTest.assertEquals((int)1, (int)result.size());
        SimpleFileDAOTest.assertEquals((String)this.simpleFile1.getTitle(), (String)((SimpleFile)result.get(0)).getTitle());
        this.simpleFileDAO.remove((Serializable)((Object)this.simpleFile1.getId()));
        result = this.simpleFileDAO.searchEquals(new String[]{this.simpleFile1.getTitle()}, new String[]{"title"}, null);
        SimpleFileDAOTest.assertNotNull((Object)result);
        SimpleFileDAOTest.assertEquals((boolean)true, (boolean)result.isEmpty());
    }
}

