/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.organization;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class OrganizationUnitDAOTest
extends CommonDAOTestConfig {
    private static final String BUSINESS_DOMAIN_KEY = "businessDomain";
    private static final String STREET_NUMBER_KEY = "streetNumber";
    private static final String COMPLEMENT_KEY = "complement";
    private static final String STREET_KEY = "street";
    private static final String COUNTRY_KEY = "country";
    private static final String STATE_KEY = "state";
    private static final String ZIPCODE_KEY = "zipcode";
    private static final String CITY_KEY = "city";
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private OrganizationUnit organizationUnit3;
    private OrganizationUnit organizationUnit4;
    private OrganizationUnit organizationUnit5;
    private OrganizationUnit organizationUnit6;

    public void createTestData() {
        this.organizationUnit1 = new OrganizationUnit();
        this.organizationUnit1.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit1);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit1);
        this.setName("ebm", this.organizationUnit1);
        this.organizationUnit2 = new OrganizationUnit();
        this.organizationUnit2.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit2);
        this.setAddresses(null, null, null, null, null, null, "lyon", this.organizationUnit2);
        this.setName("ebm", this.organizationUnit2);
        this.organizationUnit3 = new OrganizationUnit();
        this.organizationUnit3.setType("enterprise");
        this.setBusinessDomain("elec", this.organizationUnit3);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit3);
        this.setName("fetelec", this.organizationUnit3);
        this.organizationUnit4 = new OrganizationUnit();
        this.organizationUnit4.setType("enterprise");
        this.setBusinessDomain("frige", this.organizationUnit4);
        this.setAddresses(null, null, null, null, null, null, "toulouse", this.organizationUnit4);
        this.setName("cegedum", this.organizationUnit4);
        this.organizationUnit5 = new OrganizationUnit();
        this.organizationUnit5.setType("enterprise");
        this.setBusinessDomain("water", this.organizationUnit5);
        this.setAddresses(null, null, null, null, null, null, "paris", this.organizationUnit5);
        this.setName("openball", this.organizationUnit5);
        this.saveData();
    }

    private void saveData() {
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.organizationUnitDAO.save((Object)this.organizationUnit3);
        this.organizationUnitDAO.save((Object)this.organizationUnit4);
        this.organizationUnitDAO.save((Object)this.organizationUnit5);
        this.getHibernateSession().flush();
    }

    private void saveData2() {
        this.organizationUnitDAO.save((Object)this.organizationUnit6);
        this.organizationUnitDAO.save((Object)this.organizationUnit5);
        this.organizationUnitDAO.save((Object)this.organizationUnit4);
        this.organizationUnitDAO.save((Object)this.organizationUnit3);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    private void setBusinessDomain(String businessDomain, OrganizationUnit organizationUnitBO) {
        CategoryBag categoryBag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(BUSINESS_DOMAIN_KEY);
        keyedReference.setKeyValue(businessDomain);
        categoryBag.addKeyedReference(keyedReference);
        organizationUnitBO.setCategoryBag(categoryBag);
    }

    private void setName(String nameString, OrganizationUnit organizationUnit) {
        Name name = new Name();
        name.setName(nameString);
        organizationUnit.addName(name);
    }

    private void setAddresses(String streetNum, String street, String complement, String country, String state, String zipcode, String city, OrganizationUnit organizationUnitBO) {
        Address address = new Address();
        this.addAddressLine(address, STREET_NUMBER_KEY, null, streetNum);
        this.addAddressLine(address, STREET_KEY, null, street);
        this.addAddressLine(address, COMPLEMENT_KEY, null, complement);
        this.addAddressLine(address, COUNTRY_KEY, null, country);
        this.addAddressLine(address, STATE_KEY, null, state);
        this.addAddressLine(address, ZIPCODE_KEY, null, zipcode);
        this.addAddressLine(address, CITY_KEY, null, city);
        organizationUnitBO.addAddress(address);
    }

    private void addAddressLine(Address address, String keyName, String keyValue, String line) {
        AddressLine addressLine = new AddressLine();
        addressLine.setAddressLine(line);
        addressLine.setKeyName(keyName);
        addressLine.setKeyValue(keyValue);
        address.addAddressLine(addressLine);
    }

    @Test
    public void testSearch() {
        this.createTestData();
        String[] criteria = new String[]{"ramonville"};
        String[] properties = new String[]{"addresses.addressLines.addressLine"};
        List orgs = this.organizationUnitDAO.searchLike(criteria, properties, null);
        OrganizationUnitDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs);
        OrganizationUnitDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)orgs.size());
        OrganizationUnitDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs.contains(this.organizationUnit1));
        OrganizationUnitDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs.contains(this.organizationUnit3));
    }

    @Test
    public void testSearch2() {
        this.createTestData();
        String[] criteria2 = new String[]{"ramonville", "ebm"};
        String[] properties2 = new String[]{"addresses.addressLines.addressLine", "names.name"};
        List orgs2 = this.organizationUnitDAO.searchLike(criteria2, properties2, null);
        OrganizationUnitDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs2);
        OrganizationUnitDAOTest.assertEquals((String)"Bad number of results", (int)1, (int)orgs2.size());
        OrganizationUnitDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs2.contains(this.organizationUnit1));
    }

    @Test
    public void testSearch3() {
        this.createTestData();
        String[] criteria2 = new String[]{"Ramonville", "eBM"};
        String[] properties2 = new String[]{"addresses.addressLines.addressLine", "names.name"};
        List orgs3 = this.organizationUnitDAO.searchLike(null, properties2, null);
        List orgs4 = this.organizationUnitDAO.searchLike(criteria2, null, null);
        List orgs5 = this.organizationUnitDAO.searchLike(null, null, null);
        OrganizationUnitDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs3);
        OrganizationUnitDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs3.size());
        OrganizationUnitDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs4);
        OrganizationUnitDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs4.size());
        OrganizationUnitDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs5);
        OrganizationUnitDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs5.size());
    }

    public void createTestData2() {
        this.organizationUnit1 = new OrganizationUnit();
        this.organizationUnit1.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit1);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit1);
        this.setName("1", this.organizationUnit1);
        this.organizationUnit2 = new OrganizationUnit();
        this.organizationUnit2.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit2);
        this.setAddresses(null, null, null, null, null, null, "lyon", this.organizationUnit2);
        this.setName("2", this.organizationUnit2);
        this.organizationUnit1.addParty((Party)this.organizationUnit2);
        this.organizationUnit3 = new OrganizationUnit();
        this.organizationUnit3.setType("enterprise");
        this.setBusinessDomain("elec", this.organizationUnit3);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit3);
        this.setName("3", this.organizationUnit3);
        this.organizationUnit1.addParty((Party)this.organizationUnit3);
        this.organizationUnit4 = new OrganizationUnit();
        this.organizationUnit4.setType("enterprise");
        this.setBusinessDomain("frige", this.organizationUnit4);
        this.setAddresses(null, null, null, null, null, null, "toulouse", this.organizationUnit4);
        this.setName("4", this.organizationUnit4);
        this.organizationUnit2.addParty((Party)this.organizationUnit4);
        this.organizationUnit5 = new OrganizationUnit();
        this.organizationUnit5.setType("enterprise");
        this.setBusinessDomain("water", this.organizationUnit5);
        this.setAddresses(null, null, null, null, null, null, "paris", this.organizationUnit5);
        this.setName("5", this.organizationUnit5);
        this.organizationUnit3.addParty((Party)this.organizationUnit5);
        this.organizationUnit6 = new OrganizationUnit();
        this.organizationUnit6.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit6);
        this.setAddresses(null, null, null, null, null, null, "paris", this.organizationUnit6);
        this.setName("6", this.organizationUnit6);
        this.organizationUnit3.addParty((Party)this.organizationUnit6);
        this.saveData2();
    }

    @Test
    public void testGetOrgAndChildren() {
        this.createTestData2();
        List orgs1 = this.organizationUnitDAO.getOrgAndChildren(this.organizationUnit1.getId());
        OrganizationUnitDAOTest.assertNotNull((Object)orgs1);
        OrganizationUnitDAOTest.assertTrue((orgs1.size() == 6 ? 1 : 0) != 0);
        List orgs3 = this.organizationUnitDAO.getOrgAndChildren(this.organizationUnit3.getId());
        OrganizationUnitDAOTest.assertNotNull((Object)orgs3);
        OrganizationUnitDAOTest.assertTrue((orgs3.size() == 3 ? 1 : 0) != 0);
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit3));
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit5));
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit6));
    }

    @Test
    public void testGetAllWithoutMeAndMyChildren() throws DAOLayerException {
        this.createTestData2();
        List orgs3 = this.organizationUnitDAO.getAllWithoutMeAndMyChildren(this.organizationUnit3.getId());
        OrganizationUnitDAOTest.assertNotNull((Object)orgs3);
        OrganizationUnitDAOTest.assertTrue((orgs3.size() == 3 ? 1 : 0) != 0);
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit1));
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit2));
        OrganizationUnitDAOTest.assertTrue((boolean)orgs3.contains(this.organizationUnit4));
    }
}

