/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.organization;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class OrganizationUnitUnifiedDAOTest
extends CommonDAOTestConfig {
    private static final String BUSINESS_DOMAIN_KEY = "businessDomain";
    private static final String STREET_NUMBER_KEY = "streetNumber";
    private static final String COMPLEMENT_KEY = "complement";
    private static final String STREET_KEY = "street";
    private static final String COUNTRY_KEY = "country";
    private static final String STATE_KEY = "state";
    private static final String ZIPCODE_KEY = "zipcode";
    private static final String CITY_KEY = "city";
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private OrganizationUnit organizationUnit3;
    private OrganizationUnit organizationUnit4;
    private OrganizationUnit organizationUnit5;

    public void createTestData() {
        this.organizationUnit1 = new OrganizationUnit();
        this.organizationUnit1.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit1);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit1);
        this.setName("ebm", this.organizationUnit1);
        this.organizationUnit2 = new OrganizationUnit();
        this.organizationUnit2.setType("enterprise");
        this.setBusinessDomain("computing", this.organizationUnit2);
        this.setAddresses(null, null, null, null, null, null, "lyon", this.organizationUnit2);
        this.setName("ebm", this.organizationUnit2);
        this.organizationUnit3 = new OrganizationUnit();
        this.organizationUnit3.setType("enterprise");
        this.setBusinessDomain("elec", this.organizationUnit3);
        this.setAddresses(null, null, null, null, null, null, "ramonville", this.organizationUnit3);
        this.setName("fetelec", this.organizationUnit3);
        this.organizationUnit4 = new OrganizationUnit();
        this.organizationUnit4.setType("enterprise");
        this.setBusinessDomain("frige", this.organizationUnit4);
        this.setAddresses(null, null, null, null, null, null, "toulouse", this.organizationUnit4);
        this.setName("cegedum", this.organizationUnit4);
        this.organizationUnit5 = new OrganizationUnit();
        this.organizationUnit5.setType("enterprise");
        this.setBusinessDomain("water", this.organizationUnit5);
        this.setAddresses(null, null, null, null, null, null, "paris", this.organizationUnit5);
        this.setName("openball", this.organizationUnit5);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.organizationUnitDAO.save((Object)this.organizationUnit3);
        this.organizationUnitDAO.save((Object)this.organizationUnit4);
        this.organizationUnitDAO.save((Object)this.organizationUnit5);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    private void setBusinessDomain(String businessDomain, OrganizationUnit organizationUnitBO) {
        CategoryBag categoryBag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(BUSINESS_DOMAIN_KEY);
        keyedReference.setKeyValue(businessDomain);
        categoryBag.addKeyedReference(keyedReference);
        organizationUnitBO.setCategoryBag(categoryBag);
    }

    private void setName(String nameString, OrganizationUnit organizationUnit) {
        Name name = new Name();
        name.setName(nameString);
        organizationUnit.addName(name);
    }

    private void setAddresses(String streetNum, String street, String complement, String country, String state, String zipcode, String city, OrganizationUnit organizationUnitBO) {
        Address address = new Address();
        this.addAddressLine(address, STREET_NUMBER_KEY, null, streetNum);
        this.addAddressLine(address, STREET_KEY, null, street);
        this.addAddressLine(address, COMPLEMENT_KEY, null, complement);
        this.addAddressLine(address, COUNTRY_KEY, null, country);
        this.addAddressLine(address, STATE_KEY, null, state);
        this.addAddressLine(address, ZIPCODE_KEY, null, zipcode);
        this.addAddressLine(address, CITY_KEY, null, city);
        organizationUnitBO.addAddress(address);
    }

    private void addAddressLine(Address address, String keyName, String keyValue, String line) {
        AddressLine addressLine = new AddressLine();
        addressLine.setAddressLine(line);
        addressLine.setKeyName(keyName);
        addressLine.setKeyValue(keyValue);
        address.addAddressLine(addressLine);
    }

    @Test
    public void testSearchLike() {
        this.createTestData();
        String[] criteria = new String[]{"ramonville"};
        String[] properties = new String[]{"addresses.addressLines.addressLine"};
        List orgs = this.organizationUnitDAO.searchLike(criteria, properties, null);
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)orgs.size());
        OrganizationUnitUnifiedDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs.contains(this.organizationUnit1));
        OrganizationUnitUnifiedDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs.contains(this.organizationUnit3));
    }

    @Test
    public void testSearchLike2() {
        this.createTestData();
        String[] criteria2 = new String[]{"ramonville", "ebm"};
        String[] properties2 = new String[]{"addresses.addressLines.addressLine", "names.name"};
        List orgs2 = this.organizationUnitDAO.searchLike(criteria2, properties2, null);
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs2);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)1, (int)orgs2.size());
        OrganizationUnitUnifiedDAOTest.assertTrue((String)"Bad list of organization name", (boolean)orgs2.contains(this.organizationUnit1));
    }

    @Test
    public void testSearchLike3() {
        this.createTestData();
        String[] criteria2 = new String[]{"Ramonville", "eBM"};
        String[] properties2 = new String[]{"addresses.addressLines.addressLine", "names.name"};
        List orgs3 = this.organizationUnitDAO.searchLike(null, properties2, null);
        List orgs4 = this.organizationUnitDAO.searchLike(criteria2, null, null);
        List orgs5 = this.organizationUnitDAO.searchLike(null, null, null);
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs3);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs3.size());
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs4);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs4.size());
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs5);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)5, (int)orgs5.size());
    }

    @Test
    public void testSearchORMResult() throws DAOLayerException {
        this.createTestData();
        String[] criteria = new String[]{"fetelec"};
        String[] properties = new String[]{"names.name"};
        List orgs = this.organizationUnitDAO.searchLucene(criteria, properties);
        OrganizationUnitUnifiedDAOTest.assertNotNull((String)"Organization list must not be null", (Object)orgs);
        OrganizationUnitUnifiedDAOTest.assertEquals((String)"Bad number of results", (int)1, (int)orgs.size());
        OrganizationUnitUnifiedDAOTest.assertTrue((String)"Bad list of organization", (boolean)orgs.contains(this.organizationUnit3));
    }
}

