/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.organization;

import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class PersonDAOTest
extends CommonDAOTestConfig {
    private static final String BUSINESS_DOMAIN_KEY = "businessDomain";
    private static final String STREET_NUMBER_KEY = "streetNumber";
    private static final String COMPLEMENT_KEY = "complement";
    private static final String STREET_KEY = "street";
    private static final String COUNTRY_KEY = "country";
    private static final String STATE_KEY = "state";
    private static final String ZIPCODE_KEY = "zipcode";
    private static final String CITY_KEY = "city";
    @Resource
    private PersonDAO personDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    private Person person1;
    private Person person2;
    private Person person3;
    private Post post1;
    private Post post2;
    private Post post3;
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private OrganizationUnit organizationUnit3;

    public void createTestData() {
        this.organizationUnit1 = new OrganizationUnit();
        this.organizationUnit1.setType("type1");
        this.setBusinessDomain("business1", this.organizationUnit1);
        this.setAddresses(null, null, null, null, null, null, "city1", this.organizationUnit1);
        this.setName("name1", this.organizationUnit1);
        this.organizationUnit2 = new OrganizationUnit();
        this.organizationUnit2.setType("type2");
        this.setBusinessDomain("business2", this.organizationUnit2);
        this.setAddresses(null, null, null, null, null, null, "city2", this.organizationUnit2);
        this.setName("name2", this.organizationUnit2);
        this.organizationUnit3 = new OrganizationUnit();
        this.organizationUnit3.setType("type3");
        this.setBusinessDomain("business3", this.organizationUnit3);
        this.setAddresses(null, null, null, null, null, null, "city3", this.organizationUnit3);
        this.setName("name3", this.organizationUnit3);
        this.person1 = new Person();
        this.person1.setFirstName("foo1");
        this.person1.setMiddleName("bar1");
        this.person1.setLastName("foobar1");
        this.person1.setLocation("A1");
        this.person2 = new Person();
        this.person2.setFirstName("foo2");
        this.person2.setMiddleName("bar1");
        this.person2.setLastName("foobar2");
        this.person2.setLocation("A2");
        this.person3 = new Person();
        this.person3.setFirstName("foo3");
        this.person3.setMiddleName("bar3");
        this.person3.setLastName("foobar3");
        this.person3.setLocation("A3");
        this.post1 = new Post();
        this.post1.setName("post1");
        this.post1.setNature("nature1");
        this.post1.setDescription("desc1");
        this.post2 = new Post();
        this.post2.setName("post2");
        this.post2.setNature("nature2");
        this.post2.setDescription("desc2");
        this.post3 = new Post();
        this.post3.setName("post3");
        this.post3.setNature("nature3");
        this.post3.setDescription("desc3");
        this.person1.setParentOrganization(this.organizationUnit1);
        this.person2.setParentOrganization(this.organizationUnit2);
        this.person3.setParentOrganization(this.organizationUnit3);
        this.person1.setPost(this.post1);
        this.person2.setPost(this.post2);
        this.person3.setPost(this.post1);
        this.organizationUnit1.addPost(this.post1);
        this.organizationUnit2.addPost(this.post2);
        this.organizationUnit3.addPost(this.post1);
        this.organizationUnit3.addPost(this.post3);
        this.postDAO.save((Object)this.post1);
        this.postDAO.save((Object)this.post2);
        this.postDAO.save((Object)this.post3);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.organizationUnitDAO.save((Object)this.organizationUnit3);
        this.personDAO.save((Object)this.person1);
        this.personDAO.save((Object)this.person2);
        this.personDAO.save((Object)this.person3);
        this.getHibernateSession().flush();
    }

    private void setBusinessDomain(String businessDomain, OrganizationUnit organizationUnitBO) {
        CategoryBag categoryBag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(BUSINESS_DOMAIN_KEY);
        keyedReference.setKeyValue(businessDomain);
        categoryBag.addKeyedReference(keyedReference);
        organizationUnitBO.setCategoryBag(categoryBag);
    }

    private void setName(String nameString, OrganizationUnit organizationUnit) {
        Name name = new Name();
        name.setName(nameString);
        organizationUnit.addName(name);
    }

    private void setAddresses(String streetNum, String street, String complement, String country, String state, String zipcode, String city, OrganizationUnit organizationUnitBO) {
        Address address = new Address();
        this.addAddressLine(address, STREET_NUMBER_KEY, null, streetNum);
        this.addAddressLine(address, STREET_KEY, null, street);
        this.addAddressLine(address, COMPLEMENT_KEY, null, complement);
        this.addAddressLine(address, COUNTRY_KEY, null, country);
        this.addAddressLine(address, STATE_KEY, null, state);
        this.addAddressLine(address, ZIPCODE_KEY, null, zipcode);
        this.addAddressLine(address, CITY_KEY, null, city);
        organizationUnitBO.addAddress(address);
    }

    private void addAddressLine(Address address, String keyName, String keyValue, String line) {
        AddressLine addressLine = new AddressLine();
        addressLine.setAddressLine(line);
        addressLine.setKeyName(keyName);
        addressLine.setKeyValue(keyValue);
        address.addAddressLine(addressLine);
    }

    @Test
    public void testSearchLike() {
        this.createTestData();
        String[] criteria = new String[]{"bar1"};
        String[] properties = new String[]{"firstName", "lastName", "middleName"};
        List persons = this.personDAO.searchLike(criteria, properties, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)persons.size());
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person1));
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person2));
    }

    @Test
    public void testSearchLike2() {
        this.createTestData();
        String[] criteria2 = new String[]{"post1"};
        String[] properties2 = new String[]{"post.name", "post.nature", "post.description"};
        List persons2 = this.personDAO.searchLike(criteria2, properties2, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons2);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)persons2.size());
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons2.contains(this.person1));
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons2.contains(this.person3));
    }

    @Test
    public void testSearchLike3() {
        this.createTestData();
        String[] criteria3 = new String[]{"post1", "name3"};
        String[] properties3 = new String[]{"post.name", "post.nature", "post.description", "parentOrganization.names.name"};
        List persons3 = this.personDAO.searchLike(criteria3, properties3, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons3);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)1, (int)persons3.size());
        PersonDAOTest.assertTrue((String)"Bad list of person name", (boolean)persons3.contains(this.person3));
    }

    @Test
    public void testSearchLike5() {
        this.createTestData();
        String[] criteria5 = new String[]{"ost"};
        String[] properties5 = new String[]{"post.name"};
        List persons5 = this.personDAO.searchLike(criteria5, properties5, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons5);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)3, (int)persons5.size());
    }

    @Test
    public void testSearchLike6() {
        this.createTestData();
        String[] criteria6 = new String[]{"ost2"};
        String[] properties6 = new String[]{"post.name"};
        List persons6 = this.personDAO.searchLike(criteria6, properties6, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons6);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)1, (int)persons6.size());
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons6.contains(this.person2));
    }

    @Test
    public void testSearchEquals() {
        this.createTestData();
        String[] criteria = new String[]{this.post1.getId()};
        String[] properties = new String[]{"post.id"};
        List persons = this.personDAO.searchLike(criteria, properties, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)persons.size());
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person1));
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person3));
    }

    @Test
    public void testSearchEquals2() {
        this.createTestData();
        String[] criteria = new String[]{"post1"};
        String[] properties = new String[]{"post.name"};
        List persons = this.personDAO.searchEquals(criteria, properties, null);
        PersonDAOTest.assertNotNull((String)"Person list must not be null", (Object)persons);
        PersonDAOTest.assertEquals((String)"Bad number of results", (int)2, (int)persons.size());
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person1));
        PersonDAOTest.assertTrue((String)"Bad list of person", (boolean)persons.contains(this.person3));
    }
}

