/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.organization;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.CommonDAOTestConfig;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class PersonUnifiedDAOTest
extends CommonDAOTestConfig {
    private static final String BUSINESS_DOMAIN_KEY = "businessDomain";
    private static final String STREET_NUMBER_KEY = "streetNumber";
    private static final String COMPLEMENT_KEY = "complement";
    private static final String STREET_KEY = "street";
    private static final String COUNTRY_KEY = "country";
    private static final String STATE_KEY = "state";
    private static final String ZIPCODE_KEY = "zipcode";
    private static final String CITY_KEY = "city";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private PersonDAO personDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    private Person person1;
    private Person person2;
    private Person person3;
    private Post post1;
    private Post post2;
    private Post post3;
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private OrganizationUnit organizationUnit3;

    public void createTestData() {
        this.log.info((Object)"#### Call create test data");
        this.organizationUnit1 = new OrganizationUnit();
        this.organizationUnit1.setType("type1");
        this.setBusinessDomain("business1", this.organizationUnit1);
        this.setAddresses(null, null, null, null, null, null, "city1", this.organizationUnit1);
        this.setName("name1", this.organizationUnit1);
        this.organizationUnit2 = new OrganizationUnit();
        this.organizationUnit2.setType("type2");
        this.setBusinessDomain("business2", this.organizationUnit2);
        this.setAddresses(null, null, null, null, null, null, "city2", this.organizationUnit2);
        this.setName("name2", this.organizationUnit2);
        this.organizationUnit3 = new OrganizationUnit();
        this.organizationUnit3.setType("type3");
        this.setBusinessDomain("business3", this.organizationUnit3);
        this.setAddresses(null, null, null, null, null, null, "city3", this.organizationUnit3);
        this.setName("name3", this.organizationUnit3);
        this.person1 = new Person();
        this.person1.setFirstName("foo1");
        this.person1.setMiddleName("bar1");
        this.person1.setLastName("foobar1");
        this.person1.setLocation("A1");
        this.setName("fooParty1", this.person1);
        this.person2 = new Person();
        this.person2.setFirstName("foo2");
        this.person2.setMiddleName("bar1");
        this.person2.setLastName("foobar2");
        this.person2.setLocation("A2");
        this.setName("fooParty2", this.person2);
        this.person3 = new Person();
        this.person3.setFirstName("foo3");
        this.person3.setMiddleName("bar3");
        this.person3.setLastName("foobar3");
        this.person3.setLocation("A3");
        this.setName("fooParty3", this.person3);
        this.post1 = new Post();
        this.post1.setName("post1");
        this.post1.setNature("nature1");
        this.post1.setDescription("description of post1");
        this.post2 = new Post();
        this.post2.setName("post2");
        this.post2.setNature("nature2");
        this.post2.setDescription("description of post2");
        this.post3 = new Post();
        this.post3.setName("post3");
        this.post3.setNature("nature3");
        this.post3.setDescription("description of post3");
        this.person1.setParentOrganization(this.organizationUnit1);
        this.person2.setParentOrganization(this.organizationUnit2);
        this.person3.setParentOrganization(this.organizationUnit3);
        this.person1.setPost(this.post1);
        this.person2.setPost(this.post2);
        this.person3.setPost(this.post1);
        this.organizationUnit1.addPost(this.post1);
        this.organizationUnit2.addPost(this.post2);
        this.organizationUnit3.addPost(this.post1);
        this.organizationUnit3.addPost(this.post3);
        this.postDAO.save((Object)this.post1);
        this.postDAO.save((Object)this.post2);
        this.postDAO.save((Object)this.post3);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.organizationUnitDAO.save((Object)this.organizationUnit3);
        this.personDAO.save((Object)this.person1);
        this.personDAO.save((Object)this.person2);
        this.personDAO.save((Object)this.person3);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    private void setName(String nameString, Person person) {
        Name name = new Name();
        name.setName(nameString);
        person.addName(name);
    }

    private void setBusinessDomain(String businessDomain, OrganizationUnit organizationUnitBO) {
        CategoryBag categoryBag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName(BUSINESS_DOMAIN_KEY);
        keyedReference.setKeyValue(businessDomain);
        categoryBag.addKeyedReference(keyedReference);
        organizationUnitBO.setCategoryBag(categoryBag);
    }

    private void setName(String nameString, OrganizationUnit organizationUnit) {
        Name name = new Name();
        name.setName(nameString);
        organizationUnit.addName(name);
    }

    private void setAddresses(String streetNum, String street, String complement, String country, String state, String zipcode, String city, OrganizationUnit organizationUnitBO) {
        Address address = new Address();
        this.addAddressLine(address, STREET_NUMBER_KEY, null, streetNum);
        this.addAddressLine(address, STREET_KEY, null, street);
        this.addAddressLine(address, COMPLEMENT_KEY, null, complement);
        this.addAddressLine(address, COUNTRY_KEY, null, country);
        this.addAddressLine(address, STATE_KEY, null, state);
        this.addAddressLine(address, ZIPCODE_KEY, null, zipcode);
        this.addAddressLine(address, CITY_KEY, null, city);
        organizationUnitBO.addAddress(address);
    }

    private void addAddressLine(Address address, String keyName, String keyValue, String line) {
        AddressLine addressLine = new AddressLine();
        addressLine.setAddressLine(line);
        addressLine.setKeyName(keyName);
        addressLine.setKeyValue(keyValue);
        address.addAddressLine(addressLine);
    }

    @Test
    public void testGetAll() {
        this.createTestData();
        PersonUnifiedDAOTest.assertEquals((String)"Bad number of person retrieved", (int)3, (int)this.personDAO.getAll().size());
    }

    @Test
    public void testSearchORMResult6() throws DAOLayerException {
        this.createTestData();
        String[] criteria = new String[]{"description", "post1"};
        String[] searchedProperties = new String[]{"post.description", "post.name"};
        List persons = this.personDAO.searchLucene(criteria, searchedProperties);
        PersonUnifiedDAOTest.assertEquals((String)"Bad number of person retrieved", (int)2, (int)persons.size());
        PersonUnifiedDAOTest.assertTrue((String)"Bad person retrieved", (boolean)persons.contains(this.person1));
        PersonUnifiedDAOTest.assertTrue((String)"Bad person retrieved", (boolean)persons.contains(this.person3));
    }
}

