/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service;

import java.io.File;
import javax.annotation.Resource;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.junit.BeforeClass;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.transaction.annotation.Transactional;

@ContextConfiguration(locations={"classpath:applicationContext-test-hibernate.xml", "classpath:applicationContext-test-jdbc.xml", "classpath:applicationContext-transaction.xml", "classpath:applicationContext-annotation.xml", "classpath:applicationContext-test-cxf.xml", "classpath:applicationContext-service.xml", "classpath:applicationContext-test-repository.xml", "classpath:applicationContext-aop.xml"})
@Transactional
public class CommonServiceConfig
extends Assert {
    public static final String TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MetadataService metadataService;
    @Resource
    private SessionFactory sessionFactory;

    public Session getHibernateSession() {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)false);
    }

    public FullTextSession getFullTextSession() {
        return Search.getFullTextSession((Session)this.getHibernateSession());
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @AfterTransaction
    public void after() {
        this.logger.info((Object)"############## Delete repository directory if repo type is filesystem");
        String repoRoot = this.metadataService.getRepositoryRootPath();
        if (repoRoot != null) {
            File repoRootDir = new File(repoRoot);
            FileUtils.deleteQuietly((File)repoRootDir);
        }
    }
}

