/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.administration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.administration.UserManager;
import org.ow2.dragon.api.to.administration.UserTO;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.bo.administration.RoleGroup;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.administration.RoleDAO;
import org.ow2.dragon.persistence.dao.administration.RoleGroupDAO;
import org.ow2.dragon.persistence.dao.administration.UserDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.administration.RolesAndUsersTransfertObjectAssembler;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class UserManagerImplTest
extends CommonServiceConfig {
    private static String ROLE_NAME_1 = "role_1";
    private static String ROLE_NAME_2 = "role_2";
    private static String ROLE_GROUP_NAME_1 = "roleGroup1";
    private static String ROLE_GROUP_NAME_2 = "roleGroup2";
    private static String USER_NAME_1 = "user1";
    private static String USER_NAME_2 = "user2";
    private static String NAME_ORGA_1 = "orga1";
    private static String ORGA_CITY = "city Org 1";
    private static String ORGA_POST = "post1";
    private Role role1;
    private Role role2;
    private RoleGroup roleGroup1;
    private RoleGroup roleGroup2;
    private User user1;
    private User user2;
    private static OrganizationUnit orga1;
    private static Person pers1;
    private static Person pers2;
    @Resource
    private UserManager userManager;
    @Resource
    private RolesAndUsersTransfertObjectAssembler rolesAndUsersTransfertObjectAssembler;
    @Resource
    private RoleGroupDAO roleGroupDAO;
    @Resource
    private RoleDAO roleDAO;
    @Resource
    private UserDAO userDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private PersonDAO personDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;

    public void createTestData() {
        this.role1 = new Role();
        this.role1.setName(ROLE_NAME_1);
        this.role2 = new Role();
        this.role2.setName(ROLE_NAME_2);
        this.roleGroup1 = new RoleGroup();
        this.roleGroup1.setName(ROLE_GROUP_NAME_1);
        ArrayList<Role> listRoles = new ArrayList<Role>();
        listRoles.add(this.role1);
        listRoles.add(this.role2);
        this.roleGroup1.setListRoles(listRoles);
        this.roleGroup2 = new RoleGroup();
        this.roleGroup2.setName(ROLE_GROUP_NAME_2);
        listRoles = new ArrayList();
        listRoles.add(this.role1);
        listRoles.add(this.role2);
        this.roleGroup2.setListRoles(listRoles);
        this.roleGroupDAO.save((Object)this.roleGroup2);
        this.roleGroupDAO.save((Object)this.roleGroup1);
        this.roleDAO.save((Object)this.role1);
        this.roleDAO.save((Object)this.role2);
        this.getHibernateSession().flush();
    }

    public void createUser() {
        this.createTestData();
        this.user1 = new User();
        this.user1.setName(USER_NAME_1);
        this.user1.setPassword("pass");
        this.user1.setPerson(pers1);
        this.user1.addRoleGroup(this.roleGroup1);
        this.user1.addRoleGroup(this.roleGroup2);
    }

    public void createUserInDatabase() {
        this.userDAO.save((Object)this.user1);
    }

    public void createAllUserData() {
        this.createTestData();
        this.user1 = new User();
        this.user1.setName(USER_NAME_1);
        this.user1.setPassword("pass");
        this.user2 = new User();
        this.user2.setName(USER_NAME_2);
        this.user2.setPassword("pass");
        this.user2.addRoleGroup(this.roleGroup1);
        this.user2.addRoleGroup(this.roleGroup2);
        this.userDAO.save((Object)this.user1);
        this.userDAO.save((Object)this.user2);
        this.getHibernateSession().flush();
    }

    public void createOrgaPersData() {
        orga1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName(NAME_ORGA_1);
        nameOrg1.setLangCode("en");
        orga1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine(ORGA_CITY);
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        orga1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        orga1.addEmail(email);
        Post post1 = new Post();
        post1.setName(ORGA_POST);
        post1.setDescription("descPost1");
        post1.setNature("naturePost1");
        pers1 = new Person();
        pers1.setFirstName("firstName1");
        pers1.setLastName("lastName2");
        Email emailPers1 = new Email();
        emailPers1.setEmail("person1@email.com");
        pers1.addEmail(emailPers1);
        pers1.setParentOrganization(orga1);
        pers1.setPost(post1);
        PhoneNumber phoneNumber1 = new PhoneNumber();
        phoneNumber1.setPhoneNumber("0505050505");
        pers1.addPhoneNumber(phoneNumber1);
        pers2 = new Person();
        pers2.setFirstName("firstName2");
        pers2.setLastName("lastName2");
        Email emailPers2 = new Email();
        emailPers2.setEmail("person2@email.com");
        pers2.addEmail(emailPers2);
        pers2.setParentOrganization(orga1);
        pers2.setPost(post1);
        PhoneNumber phoneNumber2 = new PhoneNumber();
        phoneNumber2.setPhoneNumber("0505050506");
        pers2.addPhoneNumber(phoneNumber2);
        this.organizationUnitDAO.save((Object)orga1);
        this.postDAO.save((Object)post1);
        this.personDAO.save((Object)pers1);
        this.personDAO.save((Object)pers2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testCreateUserNominal() throws UserException {
        this.createOrgaPersData();
        this.createUser();
        UserTO user = this.rolesAndUsersTransfertObjectAssembler.toUserTO(this.user1);
        String id = this.userManager.createUser(user);
        this.getHibernateSession().flush();
        User user2 = (User)this.userDAO.get((Serializable)((Object)id));
        UserManagerImplTest.assertEquals((String)USER_NAME_1, (String)user2.getName());
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testCreateUserTwice() throws UserException {
        this.createOrgaPersData();
        this.createUser();
        this.createUserInDatabase();
        UserTO userTO = new UserTO();
        userTO.setName(USER_NAME_1);
        userTO.setPassword("test");
        this.userManager.createUser(userTO);
        this.getHibernateSession().flush();
    }

    @Test
    public void testgetAllNominal() throws UserException {
        this.createAllUserData();
        List listUser = this.userManager.getAllUser();
        for (UserTO us : listUser) {
            if (us.getName().equals(USER_NAME_1)) {
                UserManagerImplTest.assertEquals((String)us.getName(), (String)this.user1.getName());
            }
            if (!us.getName().equals(USER_NAME_2)) continue;
            UserManagerImplTest.assertEquals((String)us.getName(), (String)this.user2.getName());
        }
    }

    @Test
    public void testgetAllNotInRoleGroup() throws UserException {
        this.createAllUserData();
        String id = this.roleGroup2.getId();
        List listUser = this.userManager.getUserNotInRoleGroup(id);
        for (UserTO us : listUser) {
            UserManagerImplTest.assertEquals((String)us.getName(), (String)this.user1.getName());
        }
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testgetAllNotInRoleGroupIdNull() throws UserException {
        this.createAllUserData();
        String id = "none";
        this.userManager.getUserNotInRoleGroup(id);
    }

    @Test
    public void testgetUserNominal() throws UserException {
        this.createAllUserData();
        String id = this.user1.getId();
        UserTO user = this.userManager.getUser(id);
        UserManagerImplTest.assertEquals((String)this.user1.getName(), (String)user.getName());
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testgetUserIdNull() throws UserException {
        this.createAllUserData();
        String id = "none";
        this.userManager.getUser(id);
    }

    @Test
    public void testgetUserByNameNominal() throws UserException {
        this.createAllUserData();
        String name = this.user1.getName();
        UserTO user = this.userManager.getUserByLogin(name);
        UserManagerImplTest.assertEquals((String)this.user1.getPassword(), (String)user.getPassword());
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testgetUserByNameNull() throws UserException {
        String name = "none";
        this.userManager.getUserByLogin(name);
    }

    @Test
    public void testremoveUserNominal() throws UserException {
        this.createAllUserData();
        String id = this.user1.getId();
        this.userManager.removeUser(id);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testremoveUserIdNull() throws UserException {
        String id = "none";
        this.userManager.removeUser(id);
        this.getHibernateSession().flush();
    }

    @Test
    public void testupdateUserNominal() throws UserException {
        this.createAllUserData();
        UserTO user = this.rolesAndUsersTransfertObjectAssembler.toUserTO(this.user1);
        user.setName("test");
        String id = this.userManager.updateUser(user);
        this.getHibernateSession().flush();
        UserTO us = this.userManager.getUser(id);
        UserManagerImplTest.assertEquals((String)us.getName(), (String)"test");
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testupdateUserTwice() throws UserException {
        this.createAllUserData();
        UserTO user = this.rolesAndUsersTransfertObjectAssembler.toUserTO(this.user1);
        user.setName(USER_NAME_2);
        this.userManager.updateUser(user);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testupdateUserIdNull() throws UserException {
        this.createAllUserData();
        UserTO user = this.rolesAndUsersTransfertObjectAssembler.toUserTO(this.user1);
        user.setId(null);
        this.userManager.updateUser(user);
        this.getHibernateSession().flush();
    }

    @Test
    public void testupdateListRoleGroupNull() throws UserException {
        this.createAllUserData();
        UserTO user = this.rolesAndUsersTransfertObjectAssembler.toUserTO(this.user2);
        user.setListRoleGroup(null);
        String id = this.userManager.updateUser(user);
        this.getHibernateSession().flush();
        UserTO us = this.userManager.getUser(id);
        UserManagerImplTest.assertEquals((String)this.user2.getName(), (String)us.getName());
    }

    @Test
    public void testaddRoleGroupNominal() throws UserException {
        this.createAllUserData();
        this.userManager.addRoleGroup(this.user1.getId(), this.roleGroup1.getId());
        this.getHibernateSession().flush();
        UserManagerImplTest.assertNotNull((Object)this.user1.getListRoleGroup());
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testaddRoleGroupIdRoleNull() throws UserException {
        this.createAllUserData();
        this.userManager.addRoleGroup(this.user1.getId(), "none");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testaddRoleGroupIdUserNull() throws UserException {
        this.createAllUserData();
        this.userManager.addRoleGroup("none", this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    public void testremoveRoleGroupNominal() throws UserException {
        this.createAllUserData();
        this.userManager.removeRoleGroup(this.user2.getId(), this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testremoveRoleGroupIdRoleNull() throws UserException {
        this.createAllUserData();
        this.userManager.removeRoleGroup(this.user2.getId(), "none");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=UserException.class)
    public void testremoveRoleGroupIdUserNull() throws UserException {
        this.createAllUserData();
        this.userManager.removeRoleGroup("none", this.roleGroup1.getId());
        this.getHibernateSession().flush();
    }
}

