/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.common.TModelManager;
import org.ow2.dragon.api.to.common.CategoryTO;
import org.ow2.dragon.api.to.common.IdentifierTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class TModelManagerImplTest
extends CommonServiceConfig {
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private TransportDAO transportDAO;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();
    @Resource
    private TModelManager tModelManager;

    public void createTestData() {
    }

    @Before
    public void before() {
        TModel tModel1;
        int i = 0;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "tmodel" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "protocol" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "transport" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        Category category = new Category();
        category.setId("uddi:uddi.org:ubr:categorization:naics:1997");
        CategoryBag bag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setKeyName("dragon.org:category:type");
        keyedReference.setKeyValue("all");
        keyedReference.setTmodel((TModel)this.tModelDAO.get((Serializable)((Object)"uddi:uddi.org:categorization:general_keywords")));
        bag.addKeyedReference(keyedReference);
        category.setCategoryBag(bag);
        category.setName(new Name("en", "cat1"));
        CategoryValue categoryValue = new CategoryValue("foo", "bar");
        CategoryValue categoryValue2 = new CategoryValue("foo2", "bar2");
        category.addValue(categoryValue);
        category.addValue(categoryValue2);
        this.tModelDAO.save((Object)category);
        Category category2 = new Category();
        category2.setId("uddi:uddi.org:ubr:categorization:naics:2002");
        CategoryBag bag2 = new CategoryBag();
        KeyedReference keyedReference2 = new KeyedReference();
        keyedReference2.setKeyName("dragon.org:category:type");
        keyedReference2.setKeyValue("businessService");
        keyedReference2.setTmodel((TModel)this.tModelDAO.get((Serializable)((Object)"uddi:uddi.org:categorization:general_keywords")));
        bag2.addKeyedReference(keyedReference2);
        category2.setCategoryBag(bag2);
        category2.setName(new Name("en", "cat2"));
        this.tModelDAO.save((Object)category2);
        Identifier identifier = new Identifier();
        identifier.setId("uddi:uddi.org:ubr:identifier:dnb.com:d-u-n-s");
        CategoryBag bag3 = new CategoryBag();
        KeyedReference keyedReference3 = new KeyedReference();
        keyedReference3.setKeyName("dragon.org:category:type");
        keyedReference3.setKeyValue("businessEntity");
        keyedReference3.setTmodel((TModel)this.tModelDAO.get((Serializable)((Object)"uddi:uddi.org:categorization:general_keywords")));
        bag3.addKeyedReference(keyedReference3);
        identifier.setCategoryBag(bag3);
        identifier.setName(new Name("en", "ident"));
        this.tModelDAO.save((Object)identifier);
        this.getHibernateSession().flush();
    }

    @Override
    @After
    public void after() {
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
    }

    @Test
    public void testLoadEndpointCategoriesAndCatValues() {
        List categoryTOs = this.tModelManager.loadEndpointCategories();
        TModelManagerImplTest.assertEquals((int)1, (int)categoryTOs.size());
        String catId = ((CategoryTO)categoryTOs.get(0)).getId();
        TModelManagerImplTest.assertEquals((String)"uddi:uddi.org:ubr:categorization:naics:1997", (String)catId);
        List categoryValueTOs = this.tModelManager.loadCategoryValues(catId);
        TModelManagerImplTest.assertEquals((int)2, (int)categoryValueTOs.size());
    }

    @Test
    public void testLoadOrgCategories() {
        List categoryTOs = this.tModelManager.loadOrganizationCategories();
        TModelManagerImplTest.assertEquals((int)1, (int)categoryTOs.size());
        TModelManagerImplTest.assertEquals((String)"uddi:uddi.org:ubr:categorization:naics:1997", (String)((CategoryTO)categoryTOs.get(0)).getId());
    }

    @Test
    public void testLoadServiceCategories() {
        List categoryTOs = this.tModelManager.loadServiceCategories();
        TModelManagerImplTest.assertEquals((int)2, (int)categoryTOs.size());
    }

    @Test
    public void testLoadOrgIdentifiers() {
        List identifierTOs = this.tModelManager.loadOrganizationIdentifierSystems();
        TModelManagerImplTest.assertEquals((int)1, (int)identifierTOs.size());
        TModelManagerImplTest.assertEquals((String)"uddi:uddi.org:ubr:identifier:dnb.com:d-u-n-s", (String)((IdentifierTO)identifierTOs.get(0)).getId());
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
        tModelsIds.add("uddi:uddi.org:categorization:general_keywords");
    }
}

