/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.util.JettyServer;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.w3c.dom.Document;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class EndpointManagerImplTest
extends CommonServiceConfig {
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private SimpleFileDAO simpleFileDAO;
    @Resource
    private BindingDAO bindingDAO;
    @Resource
    private ServiceInterfaceDAO serviceInterfaceDAO;
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private ServiceSpecificationDAO serviceSpecificationDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private EndpointDAO endpointDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    @Resource
    private TransportDAO transportDAO;
    private static final String CAT_VALUE1_DESC = "valueDesc1";
    private static final String CAT_VALUE1_VALUE = "value1";
    private static final String CAT_VALUE2_DESC = "valueDesc2";
    private static final String CAT_VALUE2_VALUE = "value2";
    private OrganizationUnit organizationUnit1;
    private Category category1;
    private CategoryValue categoryValue1;
    private Category category2;
    private CategoryValue categoryValue2;
    private KeyedReference categoryRef1;
    private KeyedReference categoryRef2;
    private TModel categoryTModel1;
    private String servId;
    private String servId2;
    @Resource
    private EndpointManager endpointManager;
    @Resource
    private WSDLManager wsdlManager;
    @Resource
    private TechServiceManager techServiceManager;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();
    private int tModelsInDB;
    private int simpleFileInDB;
    private static JettyServer jettyServer;

    public void createTestData() {
        this.category1 = new Category();
        this.category1.setName(new Name("en", "cat1"));
        this.categoryValue1 = new CategoryValue();
        this.categoryValue1.setValue(CAT_VALUE1_VALUE);
        this.categoryValue1.setDescription(CAT_VALUE1_DESC);
        this.category1.addValue(this.categoryValue1);
        this.category2 = new Category();
        this.category2.setName(new Name("en", "cat2"));
        this.categoryValue2 = new CategoryValue();
        this.categoryValue2.setValue(CAT_VALUE2_VALUE);
        this.categoryValue2.setDescription(CAT_VALUE2_DESC);
        this.category2.addValue(this.categoryValue2);
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.categoryRef1 = new KeyedReference();
        this.categoryRef1.setKeyName(this.categoryValue1.getDescription());
        this.categoryRef1.setKeyValue(this.categoryValue1.getValue());
        this.categoryRef1.setTmodel(this.categoryTModel1);
        this.categoryRef2 = new KeyedReference();
        this.categoryRef2.setKeyName(this.categoryValue2.getDescription());
        this.categoryRef2.setKeyValue(this.categoryValue2.getValue());
        this.categoryRef2.setTmodel(this.categoryTModel1);
        this.organizationUnit1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName("org1");
        nameOrg1.setLangCode("en");
        this.organizationUnit1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine("Org City 1");
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnit1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnit1.addEmail(email);
    }

    public void registerAddCategoryData() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.tModelDAO.save((Object)this.categoryTModel1);
        this.categoryDAO.save((Object)this.category1);
        this.categoryDAO.save((Object)this.category2);
        this.getHibernateSession().flush();
    }

    public void registerServices() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        Document document2 = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.servId2 = this.wsdlManager.importServiceDefFile(document2)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerService() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerServiceSingleEp() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testendpoint.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerServicesSingleEp() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testendpoint.wsdl"));
        Document document2 = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.servId2 = this.wsdlManager.importServiceDefFile(document2)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    @Before
    public void before() {
        TModel tModel1;
        int i = 0;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "tmodel" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "protocol" + i));
            ++i;
            this.protocolDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "transport" + i));
            ++i;
            this.transportDAO.save((Object)tModel1);
        }
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddServiceSpecFromDomStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        String epId = this.endpointManager.createEndpoint("testEp", "testEpAddress", servId);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.endpointManager.addServiceDefFile(document, "spec name", epId, true);
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)2, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)3, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)endpoint.getServiceSpecifications());
        EndpointManagerImplTest.assertEquals((int)1, (int)endpoint.getServiceSpecifications().size());
    }

    @Test
    public void testAddServiceSpecFromURIStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        String epId = this.endpointManager.createEndpoint("testEp", "testEpAddress", servId);
        this.endpointManager.addServiceDefFile(URI.create("http://localhost:8085/Repository?filename=testservice.wsdl"), "spec name", epId, true);
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)2, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)3, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)endpoint.getServiceSpecifications());
        EndpointManagerImplTest.assertEquals((int)1, (int)endpoint.getServiceSpecifications().size());
    }

    @Test
    public void testAddServiceSpecFromDomNotStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        String epId = this.endpointManager.createEndpoint("testEp", "testEpAddress", servId);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.endpointManager.addServiceDefFile(document, "spec name", epId, false);
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)endpoint.getServiceSpecifications());
        EndpointManagerImplTest.assertEquals((int)1, (int)endpoint.getServiceSpecifications().size());
    }

    private String createTestService(String servName, String servPurpose) throws DeploymentException {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        technicalServiceTO.setName(servName);
        technicalServiceTO.setPurpose(servPurpose);
        String servId = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        return servId;
    }

    @Test
    public void testRemoveServiceSpecLinkedToServAndEp() throws Exception {
        this.registerService();
        ServiceSpecification serviceSpecification = (ServiceSpecification)this.serviceSpecificationDAO.getAll().get(0);
        Endpoint endpoint = (Endpoint)this.endpointDAO.getAll().get(0);
        this.endpointManager.removeServiceSpec(endpoint.getId(), serviceSpecification.getId());
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        List serviceSpecificationTOs = this.wsdlManager.getServSpecsForEndpoint(endpoint.getId());
        EndpointManagerImplTest.assertEquals((int)0, (int)serviceSpecificationTOs.size());
    }

    @Test
    public void testRemoveServiceSpecLinkedToServOnly() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        String epId = this.endpointManager.createEndpoint("testEp", "testEpAddress", servId);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String specId = this.endpointManager.addServiceDefFile(document, null, epId, false);
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        this.endpointManager.removeServiceSpec(epId, specId);
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)0, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
    }

    @Test
    public void testGetAllNominal() throws Exception {
        this.registerServices();
        List eps1 = this.endpointManager.getAllEndpoints(null);
        EndpointManagerImplTest.assertNotNull((Object)eps1);
        EndpointManagerImplTest.assertEquals((int)4, (int)eps1.size());
    }

    @Test
    public void testGetEndpointsByTechServNominal() throws Exception {
        this.registerServicesSingleEp();
        List eps1 = this.endpointManager.getAllEndpoints(null);
        EndpointManagerImplTest.assertNotNull((Object)eps1);
        EndpointManagerImplTest.assertEquals((int)3, (int)eps1.size());
        List endpoints = this.endpointManager.getEndpointsByTechService(this.servId, null);
        EndpointManagerImplTest.assertNotNull((Object)endpoints);
        EndpointManagerImplTest.assertEquals((int)1, (int)endpoints.size());
        EndpointManagerImplTest.assertEquals((String)"PhotoServiceSoapTest", (String)((EndpointTO)endpoints.get(0)).getName());
    }

    @Test
    public void testAddCategoryNominal() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
        List keyedReferences = ((Endpoint)this.endpointDAO.get((Serializable)((Object)anEpId))).getCategoryBag().getKeyedReferences();
        EndpointManagerImplTest.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
        }
        EndpointManagerImplTest.assertTrue((boolean)ok);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryEmptyValue() throws Exception {
        this.registerAddCategoryData();
        this.endpointManager.addCategory("", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValue() throws Exception {
        this.registerAddCategoryData();
        this.endpointManager.addCategory(null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddCategoryNominal2() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
        List keyedReferences = ((Endpoint)this.endpointDAO.get((Serializable)((Object)anEpId))).getCategoryBag().getKeyedReferences();
        EndpointManagerImplTest.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
        }
        EndpointManagerImplTest.assertTrue((boolean)ok);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryEmptyValue2() throws Exception {
        this.registerAddCategoryData();
        this.endpointManager.addCategory("", "", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValue2() throws Exception {
        this.registerAddCategoryData();
        this.endpointManager.addCategory(null, null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryTwice() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryTwice2() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.endpointManager.addCategory(anEpId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
    }

    @Override
    @After
    public void after() {
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
    }

    @Test
    public void testGetCategoriesNominal() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.endpointManager.addCategory(anEpId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        List keyedReferences = this.endpointManager.getCategoriesForEndpoint(anEpId);
        EndpointManagerImplTest.assertNotNull((Object)keyedReferences);
        boolean ok1 = false;
        for (KeyedRefTO keyedReference : keyedReferences) {
            if (!keyedReference.getName().equals(CAT_VALUE1_DESC) || !keyedReference.getValue().equals(CAT_VALUE1_VALUE) || ok1) continue;
            ok1 = true;
        }
        EndpointManagerImplTest.assertTrue((boolean)ok1);
        boolean ok2 = false;
        for (KeyedRefTO keyedReference : keyedReferences) {
            if (!keyedReference.getName().equals(CAT_VALUE2_DESC) || !keyedReference.getValue().equals(CAT_VALUE2_VALUE) || ok2) continue;
            ok2 = true;
        }
        EndpointManagerImplTest.assertTrue((boolean)ok2);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetCategoriesNullValue() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.endpointManager.addCategory(anEpId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        this.endpointManager.getCategoriesForEndpoint(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetCategoriesBadValue() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.endpointManager.addCategory(anEpId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        this.endpointManager.getCategoriesForEndpoint("");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetEndpointNullValue() throws Exception {
        this.registerService();
        this.endpointManager.getEndpoint(null, null);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveEndpointNullValue() throws Exception {
        this.endpointManager.removeEndpoint(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveEndpointBadValue() throws Exception {
        this.endpointManager.removeEndpoint("");
    }

    @Test
    public void testRemoveEndpoint() throws Exception {
        this.registerService();
        List endpoints = this.endpointManager.getAllEndpoints(null);
        this.endpointManager.removeEndpoint(((EndpointTO)endpoints.get(0)).getId());
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.bindingDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        this.endpointManager.removeEndpoint(((EndpointTO)endpoints.get(1)).getId());
        this.getHibernateSession().flush();
        EndpointManagerImplTest.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)0, (int)this.bindingDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)0, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        EndpointManagerImplTest.assertEquals((int)0, (int)this.endpointDAO.count((IMutableSearch)new Search()));
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetEndpointBadValue() throws Exception {
        this.registerService();
        this.endpointManager.getEndpoint("", null);
    }

    @Test
    public void testGetEndpointNominal() throws Exception {
        this.registerServiceSingleEp();
        List eps = this.endpointManager.getAllEndpoints(null);
        EndpointManagerImplTest.assertEquals((int)1, (int)eps.size());
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        EndpointTO endpointTO = this.endpointManager.getEndpoint(anEpId, null);
        EndpointManagerImplTest.assertNotNull((Object)endpointTO);
        EndpointManagerImplTest.assertEquals((String)"PhotoServiceSoapTest", (String)endpointTO.getName());
        EndpointManagerImplTest.assertEquals((String)anEpId, (String)endpointTO.getId());
        EndpointManagerImplTest.assertEquals((String)"http://test.org/PhotoService.asmx", (String)endpointTO.getNetworkAddress());
        EndpointManagerImplTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(endpointTO.getGlobalRating()));
        EndpointManagerImplTest.assertNotNull((Object)endpointTO.getRatingTO());
        EndpointManagerImplTest.assertNull((Object)endpointTO.getRatingTO().getUserName());
        String userName = "toto";
        EndpointTO endpointTO2 = this.endpointManager.getEndpoint(anEpId, userName);
        EndpointManagerImplTest.assertNotNull((Object)endpointTO2);
        EndpointManagerImplTest.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(endpointTO2.getGlobalRating()));
        EndpointManagerImplTest.assertNotNull((Object)endpointTO2.getRatingTO());
        EndpointManagerImplTest.assertEquals((String)userName, (String)endpointTO2.getRatingTO().getUserName());
        EndpointManagerImplTest.assertEquals((int)0, (int)endpointTO2.getRatingTO().getMyRating());
    }

    @Test
    public void testRemoveCategoriesNominal() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        this.endpointManager.addCategory(anEpId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
        List keyedReferences = ((Endpoint)this.endpointDAO.get((Serializable)((Object)anEpId))).getCategoryBag().getKeyedReferences();
        EndpointManagerImplTest.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        String catId = "";
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
            catId = keyedReference.getId();
        }
        EndpointManagerImplTest.assertTrue((boolean)ok);
        this.endpointManager.removeCategories(anEpId, Arrays.asList(catId));
        this.getHibernateSession().flush();
        List keyedReferences2 = ((Endpoint)this.endpointDAO.get((Serializable)((Object)anEpId))).getCategoryBag().getKeyedReferences();
        EndpointManagerImplTest.assertNotNull((Object)keyedReferences2);
        boolean ok2 = false;
        for (KeyedReference keyedReference : keyedReferences2) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok2) continue;
            ok2 = true;
        }
        EndpointManagerImplTest.assertTrue((!ok2 ? 1 : 0) != 0);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveCategoriesNullValue() throws Exception {
        this.endpointManager.removeCategories(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveCategoriesBadValue() throws Exception {
        this.endpointManager.removeCategories("", Arrays.asList(""));
    }

    @Test
    public void testUpdateEndpointNominal() throws Exception {
        this.registerService();
        String epName = "epName";
        String networkAddress = "epAddress";
        String epId = this.createTestEp(epName, networkAddress);
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)endpoint);
        EndpointManagerImplTest.assertEquals((String)epName, (String)endpoint.getName());
        EndpointManagerImplTest.assertEquals((String)networkAddress, (String)endpoint.getNetworkAddress());
        EndpointManagerImplTest.assertNotNull((Object)endpoint.getTechnicalService());
        EndpointManagerImplTest.assertEquals((String)endpoint.getTechnicalService().getId(), (String)this.servId);
        String epName2 = "epName2";
        String networkAddress2 = "epAddress2";
        this.updateTestEp(epId, epName2, networkAddress2);
        Endpoint updatedEndpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)updatedEndpoint);
        EndpointManagerImplTest.assertEquals((String)epName2, (String)updatedEndpoint.getName());
        EndpointManagerImplTest.assertEquals((String)networkAddress2, (String)updatedEndpoint.getNetworkAddress());
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testUpdateEndpointBadValue() throws Exception {
        EndpointTO endpointTO = new EndpointTO();
        endpointTO.setId("");
        this.endpointManager.updateEndpoint(endpointTO);
    }

    @Test
    public void testCreateEndpointNominal() throws Exception {
        this.registerService();
        String epName = "epName";
        String networkAddress = "epAddress";
        String epId = this.createTestEp(epName, networkAddress);
        Endpoint endpoint = (Endpoint)this.endpointDAO.get((Serializable)((Object)epId));
        EndpointManagerImplTest.assertNotNull((Object)endpoint);
        EndpointManagerImplTest.assertEquals((String)epName, (String)endpoint.getName());
        EndpointManagerImplTest.assertEquals((String)networkAddress, (String)endpoint.getNetworkAddress());
        EndpointManagerImplTest.assertNotNull((Object)endpoint.getTechnicalService());
        EndpointManagerImplTest.assertEquals((String)endpoint.getTechnicalService().getId(), (String)this.servId);
    }

    private String createTestEp(String epName, String networkAddress) throws DeploymentException {
        String epId = this.endpointManager.createEndpoint(epName, networkAddress, this.servId);
        this.getHibernateSession().flush();
        return epId;
    }

    private void updateTestEp(String epId, String epName, String networkAddress) throws DeploymentException {
        EndpointTO endpointTO = new EndpointTO();
        endpointTO.setId(epId);
        endpointTO.setName(epName);
        endpointTO.setNetworkAddress(networkAddress);
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        technicalServiceTO.setId(this.servId);
        endpointTO.setTechService(technicalServiceTO);
        this.endpointManager.updateEndpoint(endpointTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateEndpointNameEmpty() throws Exception {
        this.registerService();
        this.createTestEp("", "epAddress");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreateEndpointNameNull() throws Exception {
        this.registerService();
        this.createTestEp(null, "epAddress");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreateEndpointServIdNull() throws Exception {
        this.registerService();
        this.endpointManager.createEndpoint("epName", "epAddress", null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateEndpointServNameEmpty() throws Exception {
        this.registerService();
        this.endpointManager.createEndpoint("epName", "epAddress", "");
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateEndpointServNotExist() throws Exception {
        this.registerService();
        this.endpointManager.createEndpoint("epName", "epAddress", "badId");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreateEndpointNullValue() throws Exception {
        this.registerService();
        this.endpointManager.createEndpoint(null, null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateEndpointTwice() throws Exception {
        this.registerService();
        String epName = "epName";
        String networkAddress = "epAddress";
        this.createTestEp(epName, networkAddress);
        this.createTestEp(epName, networkAddress);
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        try {
            jettyServer = JettyServer.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void afterClass() {
        try {
            jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
        jettyServer = null;
    }
}

