/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.deployment.CommentTO;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.deployment.RatingTO;
import org.ow2.dragon.api.to.deployment.ServiceSearchProperties;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.CommentDAO;
import org.ow2.dragon.persistence.dao.common.LinkDAO;
import org.ow2.dragon.persistence.dao.common.RatingDAO;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingOperationDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.persistence.dao.specification.SpecifiedOperationDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.deployment.TechServiceManagerImplTest;
import org.ow2.dragon.service.util.JettyServer;
import org.ow2.dragon.util.ContentType;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.w3c.dom.Document;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class TechServiceManagerImpl2Test
extends CommonServiceConfig {
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private SimpleFileDAO simpleFileDAO;
    @Resource
    private BindingOperationDAO bindingOperationDAO;
    @Resource
    private BindingDAO bindingDAO;
    @Resource
    private ServiceInterfaceDAO serviceInterfaceDAO;
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private ServiceSpecificationDAO serviceSpecificationDAO;
    @Resource
    private SpecifiedOperationDAO specifiedOperationDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private RatingDAO ratingDAO;
    @Resource
    private CommentDAO commentDAO;
    @Resource
    private EndpointDAO endpointDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private LinkDAO linkDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    @Resource
    private TransportDAO transportDAO;
    @Resource
    private RoleOfPartyManager roleOfPartyManager;
    private static final String CAT_VALUE1_DESC = "valueDesc1";
    private static final String CAT_VALUE1_VALUE = "value1";
    private static final String CAT_VALUE2_DESC = "valueDesc2";
    private static final String CAT_VALUE2_VALUE = "value2";
    private OrganizationUnit organizationUnit1;
    private Category category1;
    private CategoryValue categoryValue1;
    private Category category2;
    private CategoryValue categoryValue2;
    private KeyedReference categoryRef1;
    private KeyedReference categoryRef2;
    private TModel categoryTModel1;
    private String servId;
    private String servId2;
    private static Logger logger = Logger.getLogger(TechServiceManagerImplTest.class);
    @Resource
    private TechServiceManager techServiceManager;
    @Resource
    private EndpointManager endpointManager;
    @Resource
    private WSDLManager wsdlManager;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();
    private int tModelsInDB;
    private int simpleFileInDB;
    private static JettyServer jettyServer;

    public void createTestData() {
        this.category1 = new Category();
        this.category1.setName(new Name("en", "cat1"));
        this.categoryValue1 = new CategoryValue();
        this.categoryValue1.setValue(CAT_VALUE1_VALUE);
        this.categoryValue1.setDescription(CAT_VALUE1_DESC);
        this.category1.addValue(this.categoryValue1);
        this.category2 = new Category();
        this.category2.setName(new Name("en", "cat2"));
        this.categoryValue2 = new CategoryValue();
        this.categoryValue2.setValue(CAT_VALUE2_VALUE);
        this.categoryValue2.setDescription(CAT_VALUE2_DESC);
        this.category2.addValue(this.categoryValue2);
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.categoryRef1 = new KeyedReference();
        this.categoryRef1.setKeyName(this.categoryValue1.getDescription());
        this.categoryRef1.setKeyValue(this.categoryValue1.getValue());
        this.categoryRef1.setTmodel(this.categoryTModel1);
        this.categoryRef2 = new KeyedReference();
        this.categoryRef2.setKeyName(this.categoryValue2.getDescription());
        this.categoryRef2.setKeyValue(this.categoryValue2.getValue());
        this.categoryRef2.setTmodel(this.categoryTModel1);
        this.organizationUnit1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName("org1");
        nameOrg1.setLangCode("en");
        this.organizationUnit1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine("Org City 1");
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnit1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnit1.addEmail(email);
    }

    public void registerAddCategoryData() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.tModelDAO.save((Object)this.categoryTModel1);
        this.categoryDAO.save((Object)this.category1);
        this.categoryDAO.save((Object)this.category2);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerServices() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        Document document2 = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.servId2 = this.wsdlManager.importServiceDefFile(document2)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerServices2() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        Document document2 = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice2.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.servId2 = this.wsdlManager.importServiceDefFile(document2)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerService() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerTwoServices() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-two-services.wsdl"));
        String[] servIds = this.wsdlManager.importServiceDefFile(document);
        this.servId = servIds[0];
        this.servId2 = servIds[1];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerTwoServicesWithoutEps() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-two-services-without-eps.wsdl"));
        String[] servIds = this.wsdlManager.importServiceDefFile(document);
        this.servId = servIds[0];
        this.servId2 = servIds[1];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    @Before
    public void before() {
        TModel tModel1;
        int i = 0;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "tmodel" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "protocol" + i));
            ++i;
            this.protocolDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "transport" + i));
            ++i;
            this.transportDAO.save((Object)tModel1);
        }
        this.getHibernateSession().flush();
    }

    @Test
    public void testCreateTechServiceNominalQname() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        TechnicalService technicalService = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalService);
        TechServiceManagerImpl2Test.assertEquals((String)servName, (String)technicalService.getFullName());
        List descriptions = technicalService.getDescriptions();
        TechServiceManagerImpl2Test.assertNotNull((Object)descriptions);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)descriptions.size());
        TechServiceManagerImpl2Test.assertEquals((String)servPurpose, (String)((Description)descriptions.get(0)).getDescription());
    }

    @Test
    public void testCreateTechServiceNominalLocalPartOnly() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        String servId = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        TechnicalService technicalService = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalService);
        TechServiceManagerImpl2Test.assertEquals((String)servName, (String)technicalService.getFullName());
        List descriptions = technicalService.getDescriptions();
        TechServiceManagerImpl2Test.assertNotNull((Object)descriptions);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)descriptions.size());
        TechServiceManagerImpl2Test.assertEquals((String)servPurpose, (String)((Description)descriptions.get(0)).getDescription());
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateTechServiceNameEmpty() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        this.techServiceManager.createTechService(technicalServiceTO);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateTechServiceNameNull() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = null;
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        this.techServiceManager.createTechService(technicalServiceTO);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreateTechServiceNullValue() throws Exception {
        this.techServiceManager.createTechService(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testCreateTechServiceTwice() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "{testNS}testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        this.techServiceManager.createTechService(technicalServiceTO);
        this.techServiceManager.createTechService(technicalServiceTO);
    }

    @Test
    public void testAddCategoryNominal() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
        List keyedReferences = ((TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)this.servId))).getCategoryBag().getKeyedReferences();
        TechServiceManagerImpl2Test.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
        }
        TechServiceManagerImpl2Test.assertTrue((boolean)ok);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryEmptyValue() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory("", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValue() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddCategoryNominal2() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
        List keyedReferences = ((TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)this.servId))).getCategoryBag().getKeyedReferences();
        TechServiceManagerImpl2Test.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
        }
        TechServiceManagerImpl2Test.assertTrue((boolean)ok);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryEmptyValue2() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory("", "", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValue2() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(null, null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryTwice() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddCategoryTwice2() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetAllNominal() throws Exception {
        this.registerServices();
        List techServs1 = this.techServiceManager.getAllTechServices(null);
        TechServiceManagerImpl2Test.assertNotNull((Object)techServs1);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)techServs1.size());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.SERVICE_NAME);
        List techServs2 = this.techServiceManager.getAllTechServices(requestOptionsTO);
        TechServiceManagerImpl2Test.assertNotNull((Object)techServs2);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)techServs2.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)techServs2.get(0)).getId());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId2, (String)((TechnicalServiceTO)techServs2.get(1)).getId());
        RequestOptionsTO requestOptionsTO2 = new RequestOptionsTO();
        requestOptionsTO2.setSortAscendingly(false);
        requestOptionsTO2.setSortCriteria(SortCriteria.SERVICE_NAME);
        List techServs3 = this.techServiceManager.getAllTechServices(requestOptionsTO2);
        TechServiceManagerImpl2Test.assertNotNull((Object)techServs3);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)techServs3.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId2, (String)((TechnicalServiceTO)techServs3.get(0)).getId());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)techServs3.get(1)).getId());
    }

    @Override
    @After
    public void after() {
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
    }

    @Test
    public void testGetCategoriesNominal() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.techServiceManager.addCategory(this.servId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        List keyedReferences = this.techServiceManager.getCategoriesForTechServ(this.servId);
        TechServiceManagerImpl2Test.assertNotNull((Object)keyedReferences);
        boolean ok1 = false;
        for (KeyedRefTO keyedReference : keyedReferences) {
            if (!keyedReference.getName().equals(CAT_VALUE1_DESC) || !keyedReference.getValue().equals(CAT_VALUE1_VALUE) || ok1) continue;
            ok1 = true;
        }
        TechServiceManagerImpl2Test.assertTrue((boolean)ok1);
        boolean ok2 = false;
        for (KeyedRefTO keyedReference : keyedReferences) {
            if (!keyedReference.getName().equals(CAT_VALUE2_DESC) || !keyedReference.getValue().equals(CAT_VALUE2_VALUE) || ok2) continue;
            ok2 = true;
        }
        TechServiceManagerImpl2Test.assertTrue((boolean)ok2);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetCategoriesNullValue() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.techServiceManager.addCategory(this.servId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        this.techServiceManager.getCategoriesForTechServ(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetCategoriesBadValue() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.techServiceManager.addCategory(this.servId, this.category2.getId(), this.categoryValue2.getId());
        this.getHibernateSession().flush();
        this.techServiceManager.getCategoriesForTechServ("");
    }

    @Test
    public void testGetEndpointNominal() throws Exception {
        this.registerService();
        EndpointTO endpointTO = this.techServiceManager.getEndpoint("{http://test.org/}PhotoService", "PhotoServiceSoap");
        TechServiceManagerImpl2Test.assertNotNull((Object)endpointTO);
        TechServiceManagerImpl2Test.assertEquals((String)"PhotoServiceSoap", (String)endpointTO.getName());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetEndpointNominalNotNull() throws Exception {
        this.registerService();
        EndpointTO endpointTO = this.techServiceManager.getEndpoint(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetEndpointNominalBadValue() throws Exception {
        this.registerService();
        EndpointTO endpointTO = this.techServiceManager.getEndpoint("", "");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetTechServiceNullValue() throws Exception {
        this.registerService();
        this.techServiceManager.getTechService(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetTechServiceBadValue() throws Exception {
        this.registerService();
        this.techServiceManager.getTechService("", null);
    }

    @Test
    public void testGetTechServiceNominal() throws Exception {
        this.registerService();
        TechnicalServiceTO technicalServiceTO = this.techServiceManager.getTechService(this.servId, null);
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalServiceTO);
        TechServiceManagerImpl2Test.assertEquals((String)"{http://test.org/}PhotoService", (String)technicalServiceTO.getName());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)technicalServiceTO.getId());
        TechServiceManagerImpl2Test.assertEquals((String)"This is a test service description", (String)technicalServiceTO.getPurpose());
        List categories = technicalServiceTO.getCategories();
        TechServiceManagerImpl2Test.assertNotNull((Object)categories);
        TechServiceManagerImpl2Test.assertEquals((int)3, (int)categories.size());
        TechServiceManagerImpl2Test.assertTrue((boolean)categories.contains(new KeyedRefTO(null, "tmodel5", "service local name", "PhotoService")));
        TechServiceManagerImpl2Test.assertTrue((boolean)categories.contains(new KeyedRefTO(null, "tmodel6", "service namespace", "http://test.org/")));
        TechServiceManagerImpl2Test.assertTrue((boolean)categories.contains(new KeyedRefTO(null, "tmodel4", "WSDL type", "service")));
        TechServiceManagerImpl2Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(technicalServiceTO.getGlobalRating()));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalServiceTO.getRatingTO());
        TechServiceManagerImpl2Test.assertNull((Object)technicalServiceTO.getRatingTO().getUserName());
        String userName = "toto";
        TechnicalServiceTO technicalServiceTO2 = this.techServiceManager.getTechService(this.servId, userName);
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalServiceTO2);
        TechServiceManagerImpl2Test.assertEquals((String)"{http://test.org/}PhotoService", (String)technicalServiceTO2.getName());
        TechServiceManagerImpl2Test.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(technicalServiceTO2.getGlobalRating()));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalServiceTO2.getRatingTO());
        TechServiceManagerImpl2Test.assertEquals((String)userName, (String)technicalServiceTO2.getRatingTO().getUserName());
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)technicalServiceTO2.getRatingTO().getMyRating());
    }

    @Test
    public void testRegisterRelatedDocPDF() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:I_lucene_search.pdf");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.PDF.toString(), bytesIn, "I_lucene_search.pdf");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("Dspace uses the Lucene Search Engine for searching and", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocDOC() throws Exception {
        this.registerService();
        InputStream docRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.doc");
        byte[] bytesIn2 = InputStreamUtil.getBytes((InputStream)docRelatedDoc);
        String docId2 = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.DOC.toString(), bytesIn2, "testDocument.doc");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent2 = this.techServiceManager.getRelatedDocContent(docId2);
        byte[] bytesOut2 = InputStreamUtil.getBytes((InputStream)docContent2);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn2, bytesOut2));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs2 = this.techServiceManager.searchTechService("A test Doc title", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs2.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs2.get(0)).getId());
        List technicalServiceTOs2bis = this.techServiceManager.searchTechService("A test Doc content", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs2bis.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs2bis.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId2);
    }

    @Test
    public void testRegisterRelatedDocHTML() throws Exception {
        this.registerService();
        InputStream htmlRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.html");
        byte[] bytesIn3 = InputStreamUtil.getBytes((InputStream)htmlRelatedDoc);
        String docId3 = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.HTML.toString(), bytesIn3, "testDocument.html");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent3 = this.techServiceManager.getRelatedDocContent(docId3);
        byte[] bytesOut3 = InputStreamUtil.getBytes((InputStream)docContent3);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn3, bytesOut3));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs3 = this.techServiceManager.searchTechService("a test HTML document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs3.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs3.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId3);
    }

    @Test
    public void testRegisterRelatedDocXML() throws Exception {
        this.registerService();
        InputStream xmlRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.xml");
        byte[] bytesIn4 = InputStreamUtil.getBytes((InputStream)xmlRelatedDoc);
        String docId4 = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.XML.toString(), bytesIn4, "testDocument.xml");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent4 = this.techServiceManager.getRelatedDocContent(docId4);
        byte[] bytesOut4 = InputStreamUtil.getBytes((InputStream)docContent4);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn4, bytesOut4));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs4 = this.techServiceManager.searchTechService("A test XML document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs4.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs4.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId4);
    }

    @Test
    public void testRegisterRelatedDocODT() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.odt");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.ODT.toString(), bytesIn, "testDocument.odt");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test ODT content", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocXLS() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.xls");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.XLS.toString(), bytesIn, "testDocument.xls");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test XLS document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocPPT() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.ppt");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.PPT.toString(), bytesIn, "testDocument.ppt");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test PPT document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocODS() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.ods");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.ODS.toString(), bytesIn, "testDocument.ods");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test ODS document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocODP() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.odp");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.ODP.toString(), bytesIn, "testDocument.odp");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test ODP document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocTXT() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.txt");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.TXT.toString(), bytesIn, "testDocument.txt");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test TXT document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testRegisterRelatedDocRTF() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.rtf");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.RTF.toString(), bytesIn, "testDocument.rtf");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test RTF document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRegisterRelatedDocNull() throws Exception {
        this.techServiceManager.registerRelatedDoc(null, null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRegisterRelatedDocBadServId() throws Exception {
        this.techServiceManager.registerRelatedDoc("", ContentType.TXT.toString(), "toto".getBytes(), "toto.txt");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRegisterRelatedDocContentTypeNotSupported() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.rtf");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        this.techServiceManager.registerRelatedDoc(this.servId, "bad/contenttype", bytesIn, "testDocument.rtf");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetRelatedDocContentNull() throws Exception {
        this.techServiceManager.getRelatedDocContent(null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testGetRelatedDocContentBadId() throws Exception {
        this.techServiceManager.getRelatedDocContent("");
        this.getHibernateSession().flush();
    }

    @Test
    public void testSearchTechServiceOnRelatedDoc() throws Exception {
        this.registerServices();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.rtf");
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.RTF.toString(), InputStreamUtil.getBytes((InputStream)pdfRelatedDoc), "testDocument.rtf");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test RTF document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
    }

    @Test
    public void testSearchTechServiceOnName() throws Exception {
        this.registerServices();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.NAME);
        List technicalServiceTOs = this.techServiceManager.searchTechService("{http://test.org/}PhotoService", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId2, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        List technicalServiceTO2s = this.techServiceManager.searchTechService("PhotoService", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)technicalServiceTO2s.size());
    }

    @Test
    public void testSearchTechServiceOnCategory() throws Exception {
        this.registerServices();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.CATEGORY);
        List technicalServiceTOs = this.techServiceManager.searchTechService("PhotoService local name", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)technicalServiceTOs.size());
    }

    @Test
    public void testSearchTechServiceOnOperations() throws Exception {
        this.registerServices();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.OPERATIONS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("GetSlidesJK", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
    }

    @Test
    public void testSearchTechServiceOnOrgAndRole() throws Exception {
        this.registerServices();
        this.roleOfPartyManager.createTechServiceRole(this.organizationUnit1.getId(), this.servId, "User");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.ORGANIZATION);
        List technicalServiceTOs = this.techServiceManager.searchTechService("org1 user", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
    }

    @Test
    public void testSearchTechServiceOnPurpose() throws Exception {
        this.registerServices();
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.PURPOSE);
        List technicalServiceTOs = this.techServiceManager.searchTechService("This is a test service description", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId2, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testSearchTechServiceNullValue() throws Exception {
        this.techServiceManager.searchTechService(null, null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testSearchTechServiceEmptyValues() throws Exception {
        String searchCriteria = "";
        ArrayList<ServiceSearchProperties> searchedProperties = new ArrayList<ServiceSearchProperties>();
        searchedProperties.add(ServiceSearchProperties.PURPOSE);
        RequestOptionsTO requestOptions = null;
        this.techServiceManager.searchTechService(searchCriteria, searchedProperties, requestOptions);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveRelatedDocNullValue() throws Exception {
        this.techServiceManager.removeRelatedDoc(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveRelatedDocBadValue() throws Exception {
        this.techServiceManager.removeRelatedDoc("", "");
    }

    @Test
    public void testRemoveRelatedDocNominal() throws Exception {
        this.registerService();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.rtf");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.RTF.toString(), bytesIn, "testDocument.rtf");
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        InputStream docContent = this.techServiceManager.getRelatedDocContent(docId);
        byte[] bytesOut = InputStreamUtil.getBytes((InputStream)docContent);
        TechServiceManagerImpl2Test.assertTrue((boolean)Arrays.equals(bytesIn, bytesOut));
        ArrayList<ServiceSearchProperties> searchProperties = new ArrayList<ServiceSearchProperties>();
        searchProperties.add(ServiceSearchProperties.RELATED_DOCS);
        List technicalServiceTOs = this.techServiceManager.searchTechService("A test RTF document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)technicalServiceTOs.size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId, (String)((TechnicalServiceTO)technicalServiceTOs.get(0)).getId());
        this.techServiceManager.removeRelatedDoc(this.servId, docId);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        List technicalServiceTO2s = this.techServiceManager.searchTechService("A test RTF document", searchProperties, null);
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)technicalServiceTO2s.size());
        TechServiceManagerImpl2Test.assertNull((Object)this.simpleFileDAO.get((Serializable)((Object)docId)));
    }

    @Test
    public void testRemoveCategoriesNominal() throws Exception {
        this.registerAddCategoryData();
        this.techServiceManager.addCategory(this.servId, this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
        List keyedReferences = ((TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)this.servId))).getCategoryBag().getKeyedReferences();
        TechServiceManagerImpl2Test.assertNotNull((Object)keyedReferences);
        boolean ok = false;
        String catId = "";
        for (KeyedReference keyedReference : keyedReferences) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok) continue;
            ok = true;
            catId = keyedReference.getId();
        }
        TechServiceManagerImpl2Test.assertTrue((boolean)ok);
        this.techServiceManager.removeCategories(this.servId, Arrays.asList(catId));
        this.getHibernateSession().flush();
        List keyedReferences2 = ((TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)this.servId))).getCategoryBag().getKeyedReferences();
        TechServiceManagerImpl2Test.assertNotNull((Object)keyedReferences2);
        boolean ok2 = false;
        for (KeyedReference keyedReference : keyedReferences2) {
            if (!keyedReference.getKeyName().equals(CAT_VALUE1_DESC) || !keyedReference.getKeyValue().equals(CAT_VALUE1_VALUE) || ok2) continue;
            ok2 = true;
        }
        TechServiceManagerImpl2Test.assertTrue((!ok2 ? 1 : 0) != 0);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveCategoriesNullValue() throws Exception {
        this.techServiceManager.removeCategories(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveCategoriesBadValue() throws Exception {
        this.techServiceManager.removeCategories("", Arrays.asList(""));
    }

    @Test
    public void testRemoveTechService() throws Exception {
        this.registerService();
        String roleId = this.roleOfPartyManager.createTechServiceRole(this.organizationUnit1.getId(), this.servId, "User");
        this.getHibernateSession().flush();
        TechnicalServiceTO serviceTO = this.techServiceManager.getTechService(this.servId, null);
        this.rateService(serviceTO);
        this.commentService(serviceTO);
        this.techServiceManager.updateTechService(serviceTO);
        this.getHibernateSession().flush();
        InputStream pdfRelatedDoc = InputStreamUtil.getInputStream((String)"classpath:testDocument.rtf");
        byte[] bytesIn = InputStreamUtil.getBytes((InputStream)pdfRelatedDoc);
        String docId = this.techServiceManager.registerRelatedDoc(this.servId, ContentType.RTF.toString(), bytesIn, "testDocument.rtf");
        this.getHibernateSession().flush();
        this.techServiceManager.removeTechService(this.servId);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)this.simpleFileInDB, (int)this.simpleFileDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.bindingDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.bindingOperationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.specifiedOperationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.ratingDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.commentDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.linkDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)this.tModelsInDB, (int)this.tModelDAO.count((IMutableSearch)new Search()));
    }

    @Test
    public void testRemoveTechServiceTwoServicesInWSDL() throws Exception {
        this.registerTwoServices();
        this.techServiceManager.removeTechService(this.servId);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.bindingDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        this.techServiceManager.removeTechService(this.servId2);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.bindingDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.endpointDAO.count((IMutableSearch)new Search()));
    }

    private void commentService(TechnicalServiceTO serviceTO) {
        CommentTO commentTO = new CommentTO();
        commentTO.setContent("foo bar");
        commentTO.setDate(new Date());
        commentTO.setUserName("foo");
        ArrayList<CommentTO> commentTOs = new ArrayList<CommentTO>();
        commentTOs.add(commentTO);
        serviceTO.setComments(commentTOs);
    }

    private void rateService(TechnicalServiceTO serviceTO) {
        RatingTO ratingTO = new RatingTO();
        ratingTO.setMyRating(4);
        ratingTO.setUserName("foo");
        serviceTO.setRatingTO(ratingTO);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveTechServiceNullValue() throws Exception {
        this.techServiceManager.removeTechService(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveTechServiceBadValue() throws Exception {
        this.techServiceManager.removeTechService("");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveServiceSpecNullValue() throws Exception {
        this.techServiceManager.removeServiceSpec(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testRemoveServiceSpecBadValue() throws Exception {
        this.techServiceManager.removeServiceSpec("", "");
    }

    @Test
    public void testRemoveServiceSpecLinkedToServAndEp() throws Exception {
        this.registerService();
        ServiceSpecification serviceSpecification = (ServiceSpecification)this.serviceSpecificationDAO.getAll().get(0);
        this.techServiceManager.removeServiceSpec(this.servId, serviceSpecification.getId());
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceInterfaceDAO.count((IMutableSearch)new Search()));
        List serviceSpecificationTOs = this.wsdlManager.getServSpecsForTechServ(this.servId);
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)serviceSpecificationTOs.size());
    }

    @Test
    public void testRemoveServiceSpecLinkedToServOnly() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        String servId = this.techServiceManager.createTechService(technicalServiceTO);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String specId = this.techServiceManager.addServiceDefFile(document, null, servId, false);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        this.techServiceManager.removeServiceSpec(servId, specId);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
    }

    @Test
    public void testAddServiceSpecFromDomStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.techServiceManager.addServiceDefFile(document, "spec name", servId, true);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    @Test
    public void testAddServiceSpecFromURIStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        this.techServiceManager.addServiceDefFile(URI.create("http://localhost:8085/Repository?filename=testservice.wsdl"), "spec name", servId, true);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    @Test
    public void testAddAbstractServiceSpecFromDomStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        this.techServiceManager.addServiceDefFile(document, "spec name", servId, true);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    @Test
    public void testAddAbstractServiceSpecFromDomNotStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        this.techServiceManager.addServiceDefFile(document, "spec name", servId, false);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    private String createTestService(String servName, String servPurpose) throws DeploymentException {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        technicalServiceTO.setName(servName);
        technicalServiceTO.setPurpose(servPurpose);
        String servId = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        return servId;
    }

    @Test
    public void testAddServiceSpecFromDomNotStoreEntities() throws Exception {
        String servName = "{testNS}testName";
        String servPurpose = "a test purpose";
        String servId = this.createTestService(servName, servPurpose);
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.techServiceManager.addServiceDefFile(document, "spec name", servId, false);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    @Test
    public void testAddServiceSpecFromDomStoreEntitiesSameService() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "{http://test.org/}PhotoService";
        technicalServiceTO.setName(servName);
        String servId = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.techServiceManager.addServiceDefFile(document, "spec name", servId, true);
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.technicalServiceDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)this.endpointDAO.count((IMutableSearch)new Search()));
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servId));
        Set endpoints = service.getEndpoints();
        TechServiceManagerImpl2Test.assertNotNull((Object)endpoints);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)endpoints.size());
        TechServiceManagerImpl2Test.assertNotNull((Object)service.getServiceSpecifications());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)service.getServiceSpecifications().size());
    }

    @Test
    public void testRemoveServiceSpecLinkedTo2Services() throws Exception {
        this.registerTwoServicesWithoutEps();
        ServiceSpecification serviceSpecification = (ServiceSpecification)this.serviceSpecificationDAO.getAll().get(0);
        this.techServiceManager.removeServiceSpec(this.servId, serviceSpecification.getId());
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
        TechServiceManagerImpl2Test.assertNotNull((Object)serviceSpecification.getTechnicalServices());
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)serviceSpecification.getTechnicalServices().size());
        TechServiceManagerImpl2Test.assertEquals((String)this.servId2, (String)((TechnicalService)serviceSpecification.getTechnicalServices().iterator().next()).getId());
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)((TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)this.servId))).getServiceSpecifications().size());
        this.techServiceManager.removeServiceSpec(this.servId2, serviceSpecification.getId());
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.serviceSpecificationDAO.count((IMutableSearch)new Search()));
    }

    @Test
    public void testUpdateTechServiceNominal() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "{testNS}testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        String id = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        technicalServiceTO.setId(id);
        String servName2 = "testName2";
        technicalServiceTO.setName(servName2);
        String servPurpose2 = "a test purpose 2";
        technicalServiceTO.setPurpose(servPurpose2);
        this.techServiceManager.updateTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        TechnicalService technicalService = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)id));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalService);
        TechServiceManagerImpl2Test.assertEquals((String)servName2, (String)technicalService.getFullName());
        List descriptions = technicalService.getDescriptions();
        TechServiceManagerImpl2Test.assertNotNull((Object)descriptions);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)descriptions.size());
        TechServiceManagerImpl2Test.assertEquals((String)servPurpose2, (String)((Description)descriptions.get(0)).getDescription());
    }

    @Test
    public void testUpdateTechServiceSameNameId() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "{testNS}testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        String id = this.techServiceManager.createTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        technicalServiceTO.setId(id);
        String servPurpose2 = "a test purpose 2";
        technicalServiceTO.setPurpose(servPurpose2);
        this.techServiceManager.updateTechService(technicalServiceTO);
        this.getHibernateSession().flush();
        TechnicalService technicalService = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)id));
        TechServiceManagerImpl2Test.assertNotNull((Object)technicalService);
        TechServiceManagerImpl2Test.assertEquals((String)servName, (String)technicalService.getFullName());
        List descriptions = technicalService.getDescriptions();
        TechServiceManagerImpl2Test.assertNotNull((Object)descriptions);
        TechServiceManagerImpl2Test.assertEquals((int)1, (int)descriptions.size());
        TechServiceManagerImpl2Test.assertEquals((String)servPurpose2, (String)((Description)descriptions.get(0)).getDescription());
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testUpdateTechServiceSameName() throws Exception {
        TechnicalServiceTO technicalServiceTO = new TechnicalServiceTO();
        String servName = "{testNS}testName";
        technicalServiceTO.setName(servName);
        String servPurpose = "a test purpose";
        technicalServiceTO.setPurpose(servPurpose);
        String id = this.techServiceManager.createTechService(technicalServiceTO);
        TechnicalServiceTO technicalServiceTO2 = new TechnicalServiceTO();
        String servName2 = "{testNS}testName2";
        technicalServiceTO2.setName(servName2);
        String servPurpose2 = "a test purpose 2";
        technicalServiceTO2.setPurpose(servPurpose2);
        this.techServiceManager.createTechService(technicalServiceTO2);
        this.getHibernateSession().flush();
        technicalServiceTO.setId(id);
        technicalServiceTO.setName(servName2);
        technicalServiceTO.setPurpose(servPurpose2);
        this.techServiceManager.updateTechService(technicalServiceTO);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdateTechServiceNullValue() throws Exception {
        this.techServiceManager.updateTechService(null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testUpdateTechServiceBadValue() throws Exception {
        TechnicalServiceTO serviceTO = new TechnicalServiceTO();
        serviceTO.setId("");
        this.techServiceManager.updateTechService(serviceTO);
    }

    @Test
    public void testAddEndpointNominal() throws Exception {
        this.registerServices2();
        List endpointTOs = this.endpointManager.getEndpointsByTechService(this.servId, null);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)endpointTOs.size());
        for (EndpointTO endpointTO : endpointTOs) {
            this.techServiceManager.addEndpoint(endpointTO.getId(), this.servId2);
        }
        this.getHibernateSession().flush();
        TechServiceManagerImpl2Test.assertEquals((int)0, (int)this.endpointManager.getEndpointsByTechService(this.servId, null).size());
        TechServiceManagerImpl2Test.assertEquals((int)4, (int)this.endpointManager.getEndpointsByTechService(this.servId2, null).size());
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddEndpointSameName() throws Exception {
        this.registerServices();
        List endpointTOs = this.endpointManager.getEndpointsByTechService(this.servId, null);
        TechServiceManagerImpl2Test.assertEquals((int)2, (int)endpointTOs.size());
        for (EndpointTO endpointTO : endpointTOs) {
            this.techServiceManager.addEndpoint(endpointTO.getId(), this.servId2);
        }
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddEndpointNullValue() throws Exception {
        this.techServiceManager.addEndpoint(null, null);
    }

    @Test
    @ExpectedException(value=DeploymentException.class)
    public void testAddEndpointBadValue() throws Exception {
        this.techServiceManager.addEndpoint("", "");
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        try {
            jettyServer = JettyServer.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void afterClass() {
        try {
            jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
        jettyServer = null;
    }
}

