/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.deployment.DeploymentException;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.metadata.MetadataService;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:applicationContext-test-hibernate.xml", "classpath:applicationContext-test-jdbc.xml", "classpath:applicationContext-transaction.xml", "classpath:applicationContext-annotation.xml", "classpath:applicationContext-test-cxf.xml", "classpath:applicationContext-service.xml", "classpath:applicationContext-test-repository.xml", "classpath:applicationContext-aop.xml"})
public class TechServiceManagerImplTest {
    private static final String TRANSFORMER_FACTORY = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    @Resource
    private SessionFactory sessionFactory;
    @Resource
    private MetadataService metadataService;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private TransportDAO transportDAO;
    @Resource
    private TModelDAO tModelDAO;
    private static Logger logger = Logger.getLogger(TechServiceManagerImplTest.class);
    @Resource
    private TechServiceManager techServiceManager;
    @Resource
    private WSDLManager wsdlManager;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();

    public org.hibernate.Session getHibernateSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Before
    public void before() {
        TModel tModel1;
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.tModelDAO.save((Object)tModel1);
        }
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.protocolDAO.save((Object)tModel1);
        }
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.transportDAO.save((Object)tModel1);
        }
        s.flush();
        tx.commit();
        s.close();
    }

    @Test
    public void testImportServiceAndRemove() throws IOException, SAXException, URISyntaxException, WSDLServiceException, TimeoutException, DeploymentException, LifecycleException {
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        logger.info((Object)"register the new service");
        String servId = this.wsdlManager.importServiceDefFile(document)[0];
        logger.info((Object)("service registered with id : " + servId));
        s.flush();
        tx.commit();
        s.close();
        s = this.getSessionFactory().openSession();
        tx = s.beginTransaction();
        tx.begin();
        logger.info((Object)("remove service with id : " + servId));
        this.techServiceManager.removeTechService(servId);
        s.flush();
        tx.commit();
        s.close();
    }

    @Test
    public void testImportServiceAddRelatedDocAndRemoveDoc() throws IOException, SAXException, URISyntaxException, WSDLServiceException, TimeoutException, DeploymentException, LifecycleException {
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:globalweather.wsdl"));
        InputStream relatedDoc = InputStreamUtil.getInputStream((String)"classpath:I_lucene_search.pdf");
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        logger.info((Object)"register the new service");
        String servId = this.wsdlManager.importServiceDefFile(document)[0];
        logger.info((Object)("service registered with id : " + servId));
        s.flush();
        tx.commit();
        s.close();
        s = this.getSessionFactory().openSession();
        tx = s.beginTransaction();
        tx.begin();
        logger.info((Object)("add related doc to service with id : " + servId));
        String relatedDocId = this.techServiceManager.registerRelatedDoc(servId, "application/pdf", InputStreamUtil.getBytes((InputStream)relatedDoc), "I_lucene_search.pdf");
        logger.info((Object)("related doc added with id : " + relatedDocId));
        s.flush();
        tx.commit();
        s.close();
        s = this.getSessionFactory().openSession();
        tx = s.beginTransaction();
        tx.begin();
        this.techServiceManager.removeRelatedDoc(servId, relatedDocId);
        this.techServiceManager.removeTechService(servId);
        s.flush();
        tx.commit();
        s.close();
    }

    @After
    public void after() {
        logger.info((Object)"############## Delete repository directory if repo type is filesystem");
        String repoRoot = this.metadataService.getRepositoryRootPath();
        if (repoRoot != null) {
            File repoRootDir = new File(repoRoot);
            FileUtils.deleteQuietly((File)repoRootDir);
        }
        Session s = this.getSessionFactory().openSession();
        Transaction tx = s.beginTransaction();
        tx.begin();
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
        s.flush();
        tx.commit();
        s.close();
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
    }
}

