/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.lifecycle;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.lifecycle.LifecycleManager;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepTO;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.lifecycle.Lifecycle;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStep;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStepService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStep;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.lifecycle.LifecycleTransfertObjectAssembler;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class LifecycleManagerImplTest
extends CommonServiceConfig {
    private static String LIFECYCLE_NAME1 = "Lifecycle1";
    private static String LIFECYCLE_NAME2 = "Lifecycle2";
    private static String LIFECYCLE_STEP_NAME1 = "Step1";
    private static String LIFECYCLE_STEP_NAME2 = "Step2";
    private static String LIFECYCLE_STEP_NAME3 = "Step3";
    private static String LIFECYCLE_STEP_NAME4 = "Step4";
    private static String LIFECYCLE_UNDERSTEP_NAME1 = "UnderStep1";
    private static String LIFECYCLE_UNDERSTEP_NAME2 = "UnderStep2";
    private static String LIFECYCLE_UNDERSTEP_NAME3 = "UnderStep3";
    private static String LIFECYCLE_UNDERSTEP_NAME4 = "UnderStep4";
    private static String LIFECYCLE_UNDERSTEP_NAME5 = "UnderStep5";
    private static String LIFECYCLE_UNDERSTEP_NAME6 = "UnderStep6";
    private static String LIFECYCLE_UNDERSTEP_NAME7 = "UnderStep7";
    private Lifecycle lifecycle1;
    private Lifecycle lifecycle2;
    private LifecycleStep lifecycleStep1;
    private LifecycleStep lifecycleStep2;
    private LifecycleStep lifecycleStep3;
    private LifecycleStep lifecycleStep4;
    private LifecycleUnderStep lifecycleUnderStep1;
    private LifecycleUnderStep lifecycleUnderStep2;
    private LifecycleUnderStep lifecycleUnderStep3;
    private LifecycleUnderStep lifecycleUnderStep4;
    private LifecycleUnderStep lifecycleUnderStep5;
    private LifecycleUnderStep lifecycleUnderStep6;
    @Resource
    private LifecycleDAO lifecycleDAO;
    @Resource
    private LifecycleStepDAO lifecycleStepDAO;
    @Resource
    private LifecycleManager lifecycleManager;
    @Resource
    private LifecycleTransfertObjectAssembler lifecycleTransfertObjectAssembler;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private LifecycleServiceDAO lifecycleServiceDAO;

    public void createTestLifecycle() {
        this.lifecycle1 = new Lifecycle();
        this.lifecycle1.setName(LIFECYCLE_NAME1);
        this.lifecycleDAO.save((Object)this.lifecycle1);
        this.getHibernateSession().flush();
    }

    public void createTestDataLifecycle1() {
        this.lifecycle1 = new Lifecycle();
        this.lifecycle1.setName(LIFECYCLE_NAME1);
        this.lifecycleStep1 = new LifecycleStep();
        this.lifecycleStep1.setName(LIFECYCLE_STEP_NAME1);
        this.lifecycleStep1.setIdx(0);
        this.lifecycleStep1.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep1 = new LifecycleUnderStep();
        this.lifecycleUnderStep1.setName(LIFECYCLE_UNDERSTEP_NAME1);
        this.lifecycleUnderStep1.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleStep1.addUnderStep(this.lifecycleUnderStep1);
        this.lifecycleStep2 = new LifecycleStep();
        this.lifecycleStep2.setName(LIFECYCLE_STEP_NAME2);
        this.lifecycleStep2.setIdx(1);
        this.lifecycleStep2.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep2 = new LifecycleUnderStep();
        this.lifecycleUnderStep2.setName(LIFECYCLE_UNDERSTEP_NAME2);
        this.lifecycleUnderStep2.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleStep2.addUnderStep(this.lifecycleUnderStep2);
        this.lifecycleUnderStep3 = new LifecycleUnderStep();
        this.lifecycleUnderStep3.setName(LIFECYCLE_UNDERSTEP_NAME3);
        this.lifecycleUnderStep3.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleStep2.addUnderStep(this.lifecycleUnderStep3);
        this.lifecycleDAO.save((Object)this.lifecycle1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep2);
        this.getHibernateSession().flush();
    }

    public void createTestDataLifecycle2() {
        this.lifecycle2 = new Lifecycle();
        this.lifecycle2.setName(LIFECYCLE_NAME2);
        this.lifecycleStep3 = new LifecycleStep();
        this.lifecycleStep3.setName(LIFECYCLE_STEP_NAME3);
        this.lifecycleStep3.setIdx(0);
        this.lifecycleStep3.setLifecycle(this.lifecycle2);
        this.lifecycleUnderStep4 = new LifecycleUnderStep();
        this.lifecycleUnderStep4.setName(LIFECYCLE_UNDERSTEP_NAME4);
        this.lifecycleUnderStep4.setLifecycleStep(this.lifecycleStep3);
        this.lifecycleStep3.addUnderStep(this.lifecycleUnderStep4);
        this.lifecycleStep4 = new LifecycleStep();
        this.lifecycleStep4.setName(LIFECYCLE_STEP_NAME4);
        this.lifecycleStep4.setIdx(1);
        this.lifecycleStep4.setLifecycle(this.lifecycle2);
        this.lifecycleUnderStep5 = new LifecycleUnderStep();
        this.lifecycleUnderStep5.setName(LIFECYCLE_UNDERSTEP_NAME5);
        this.lifecycleUnderStep5.setLifecycleStep(this.lifecycleStep4);
        this.lifecycleStep4.addUnderStep(this.lifecycleUnderStep5);
        this.lifecycleUnderStep6 = new LifecycleUnderStep();
        this.lifecycleUnderStep6.setName(LIFECYCLE_UNDERSTEP_NAME6);
        this.lifecycleUnderStep6.setLifecycleStep(this.lifecycleStep4);
        this.lifecycleStep4.addUnderStep(this.lifecycleUnderStep6);
        this.lifecycle2.addStep(this.lifecycleStep3);
        this.lifecycle2.addStep(this.lifecycleStep4);
        this.lifecycleDAO.save((Object)this.lifecycle2);
        this.getHibernateSession().flush();
    }

    public void createDataWithLifecycleServiceAndTechService() {
        TechnicalService techService = new TechnicalService();
        techService.setFullName("TechService1");
        this.technicalServiceDAO.save((Object)techService);
        this.getHibernateSession().flush();
        this.lifecycle1 = new Lifecycle();
        this.lifecycle1.setName(LIFECYCLE_NAME1);
        this.lifecycleStep1 = new LifecycleStep();
        this.lifecycleStep1.setName(LIFECYCLE_STEP_NAME1);
        this.lifecycleStep1.setIdx(0);
        this.lifecycleStep1.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep1 = new LifecycleUnderStep();
        this.lifecycleUnderStep1.setName(LIFECYCLE_UNDERSTEP_NAME1);
        this.lifecycleUnderStep1.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleStep1.addUnderStep(this.lifecycleUnderStep1);
        this.lifecycleStep2 = new LifecycleStep();
        this.lifecycleStep2.setName(LIFECYCLE_STEP_NAME2);
        this.lifecycleStep2.setIdx(1);
        this.lifecycleStep2.setLifecycle(this.lifecycle1);
        this.lifecycleDAO.save((Object)this.lifecycle1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep2);
        LifecycleService lifecycleService = new LifecycleService();
        lifecycleService.setLifecycle(this.lifecycle1);
        lifecycleService.setTechnicalService(techService);
        LifecycleStepService stepService = new LifecycleStepService();
        stepService.setLifecycleService(lifecycleService);
        stepService.setLifecycleStep(this.lifecycleStep1);
        stepService.setStartDate(new Date().getTime());
        lifecycleService.addStep(stepService);
        this.lifecycleServiceDAO.save((Object)lifecycleService);
    }

    @Test
    public void testCreateNewLifecycleNominal() throws LifecycleException {
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setName(LIFECYCLE_NAME1);
        String id = this.lifecycleManager.saveOrUpdateLifecycle(lifecycleTO);
        this.getHibernateSession().flush();
        Lifecycle lifecycle = (Lifecycle)this.lifecycleDAO.get((Serializable)((Object)id));
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((String)LIFECYCLE_NAME1, (String)lifecycle.getName());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleTwice() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setName(LIFECYCLE_NAME1);
        this.lifecycleManager.saveOrUpdateLifecycle(lifecycleTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleNameNull() throws LifecycleException {
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setName(null);
        this.lifecycleManager.saveOrUpdateLifecycle(lifecycleTO);
    }

    @Test
    public void testUpdateLifecycleNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleTO lifecycleTO = new LifecycleTO();
        this.lifecycleTransfertObjectAssembler.toLifecycleTO(lifecycleTO, this.lifecycle1);
        lifecycleTO.setName(LIFECYCLE_NAME2);
        this.lifecycleManager.saveOrUpdateLifecycle(lifecycleTO);
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((String)lifecycleTO.getId(), (String)this.lifecycle1.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testUpdateLifecycleIdNotInDatabase() throws LifecycleException {
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId("test");
        lifecycleTO.setName(LIFECYCLE_NAME2);
        this.lifecycleManager.saveOrUpdateLifecycle(lifecycleTO);
    }

    @Test
    public void testGetAllLifecycles() throws LifecycleException {
        this.createTestDataLifecycle1();
        this.createTestDataLifecycle2();
        List listLifecycles = this.lifecycleManager.getAll();
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((int)listLifecycles.size(), (int)2);
    }

    @Test
    public void testGetLifecycleNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleTO lifecycleTO = this.lifecycleManager.getLifecycle(this.lifecycle1.getId());
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((String)lifecycleTO.getName(), (String)LIFECYCLE_NAME1);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testGetLifecycleIdNotInDatabase() throws LifecycleException {
        this.lifecycleManager.getLifecycle("test");
    }

    @Test
    public void testDeleteLifecycleNominalFull() throws LifecycleException {
        this.createTestDataLifecycle1();
        this.lifecycleManager.deleteLifecycle(this.lifecycle1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    public void testDeleteLifecycleNominalMinimal() throws LifecycleException {
        this.createTestLifecycle();
        this.lifecycleManager.deleteLifecycle(this.lifecycle1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testDeleteLifecycleByIdNotInDatabase() throws LifecycleException {
        this.lifecycleManager.deleteLifecycle("test");
    }

    @Test
    public void testGetLifecycleStepNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleStepTO lifecycleStepTO = this.lifecycleManager.getStep(this.lifecycleStep1.getId());
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((String)lifecycleStepTO.getName(), (String)LIFECYCLE_STEP_NAME1);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testGetLifecycleStepByIdFalse() throws LifecycleException {
        this.lifecycleManager.getStep("test");
    }

    @Test
    public void testGellAllLifecycleStepForLifecycle() throws LifecycleException {
        this.createTestDataLifecycle2();
        LifecycleTO lifecycle = this.lifecycleManager.getLifecycle(this.lifecycle2.getId());
        this.getHibernateSession().flush();
        List listLifecycleStepTO = lifecycle.getListLifecycleStep();
        LifecycleManagerImplTest.assertEquals((int)listLifecycleStepTO.size(), (int)2);
    }

    @Test
    public void testCreateLifecycleStepNominal() throws LifecycleException {
        this.createTestLifecycle();
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setIdx(0);
        lifecycleStepTO.setName(LIFECYCLE_STEP_NAME1);
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle1.getId());
        lifecycleStepTO.setLifecycleTO(lifecycleTO);
        String id = this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
        this.getHibernateSession().flush();
        LifecycleStep lifecycleStep = (LifecycleStep)this.lifecycleStepDAO.get((Serializable)((Object)id));
        LifecycleManagerImplTest.assertEquals((String)lifecycleStepTO.getName(), (String)lifecycleStep.getName());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleStepWitheNameNull() throws LifecycleException {
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setIdx(0);
        lifecycleStepTO.setName(null);
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleStepWitheLifecycleNull() throws LifecycleException {
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setIdx(0);
        lifecycleStepTO.setName(LIFECYCLE_STEP_NAME1);
        lifecycleStepTO.setLifecycleTO(null);
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleStepLifecycleFalse() throws LifecycleException {
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setIdx(0);
        lifecycleStepTO.setName("testStep");
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId("test");
        lifecycleStepTO.setLifecycleTO(lifecycleTO);
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCreateLifecycleStepTwice() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setIdx(0);
        lifecycleStepTO.setName(LIFECYCLE_STEP_NAME1);
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle1.getId());
        lifecycleStepTO.setLifecycleTO(lifecycleTO);
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
    }

    @Test
    public void testUpdateLifecycleStepNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleStepTO lifecycleStepTO = this.lifecycleManager.getStep(this.lifecycleStep1.getId());
        lifecycleStepTO.setName("test");
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
        LifecycleManagerImplTest.assertEquals((String)lifecycleStepTO.getId(), (String)this.lifecycleStep1.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testUpdateLifecycleStepTwice() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleStepTO lifecycleStepTO = this.lifecycleManager.getStep(this.lifecycleStep1.getId());
        lifecycleStepTO.setName(LIFECYCLE_STEP_NAME2);
        this.lifecycleManager.saveOrUpadeLifecycleStep(lifecycleStepTO);
    }

    @Test
    public void testDeleteLifecycleStepNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        this.lifecycleManager.deleteLifecycleStep(this.lifecycleStep1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testDeleteLifecycleStepIdFalse() throws LifecycleException {
        this.lifecycleManager.deleteLifecycle("test");
    }

    @Test
    public void testAddUnderStepNominal() throws LifecycleException {
        this.createTestDataLifecycle2();
        LifecycleUnderStepTO underStepTO = new LifecycleUnderStepTO();
        underStepTO.setName(LIFECYCLE_UNDERSTEP_NAME7);
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setId(this.lifecycleStep3.getId());
        underStepTO.setLifecycleStepTO(lifecycleStepTO);
        this.lifecycleManager.saveOrUpdateUnderStep(underStepTO);
        this.getHibernateSession().flush();
        LifecycleManagerImplTest.assertEquals((String)underStepTO.getName(), (String)LIFECYCLE_UNDERSTEP_NAME7);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testAddUnderStepTwice() throws LifecycleException {
        this.createTestDataLifecycle2();
        LifecycleUnderStepTO underStepTO = new LifecycleUnderStepTO();
        underStepTO.setName(LIFECYCLE_UNDERSTEP_NAME4);
        LifecycleStepTO lifecycleStepTO = new LifecycleStepTO();
        lifecycleStepTO.setId(this.lifecycleStep3.getId());
        underStepTO.setLifecycleStepTO(lifecycleStepTO);
        this.lifecycleManager.saveOrUpdateUnderStep(underStepTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testAddUnderStepWithNameNull() throws LifecycleException {
        LifecycleUnderStepTO underStepTO = new LifecycleUnderStepTO();
        underStepTO.setName(null);
        this.lifecycleManager.saveOrUpdateUnderStep(underStepTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testAddUnderStepWithStepNull() throws LifecycleException {
        LifecycleUnderStepTO underStepTO = new LifecycleUnderStepTO();
        underStepTO.setName("test");
        underStepTO.setLifecycleStepTO(null);
        this.lifecycleManager.saveOrUpdateUnderStep(underStepTO);
    }

    @Test
    public void testDeleteUnderStepNominal() throws LifecycleException {
        this.createTestDataLifecycle2();
        this.lifecycleManager.deleteUnderStep(this.lifecycleUnderStep4.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testDeleteUnderStepIdFalse() throws LifecycleException {
        this.lifecycleManager.deleteUnderStep("test");
    }

    @Test
    public void testGetAllLinkedTechService() {
        this.createDataWithLifecycleServiceAndTechService();
        List allLinkedTechService = this.lifecycleManager.getAllLinkedServices(this.lifecycle1.getId());
        LifecycleManagerImplTest.assertEquals((int)allLinkedTechService.size(), (int)1);
    }

    @Test
    public void testCanChangeLifecycleTrue() {
        this.createTestDataLifecycle1();
        boolean canChange = this.lifecycleManager.canChangeLifecycle(this.lifecycle1.getId());
        LifecycleManagerImplTest.assertEquals((boolean)canChange, (boolean)true);
    }

    @Test
    public void testCanChangeLifecycleFalse() {
        this.createDataWithLifecycleServiceAndTechService();
        boolean canChange = this.lifecycleManager.canChangeLifecycle(this.lifecycle1.getId());
        LifecycleManagerImplTest.assertEquals((boolean)canChange, (boolean)false);
    }

    @Test
    public void testGetUnderStepNominal() throws LifecycleException {
        this.createTestDataLifecycle1();
        LifecycleUnderStepTO underStepTO = this.lifecycleManager.getUnderStep(this.lifecycleUnderStep1.getId());
        LifecycleManagerImplTest.assertEquals((String)underStepTO.getName(), (String)LIFECYCLE_UNDERSTEP_NAME1);
    }

    @Test
    public void testDeleteLifecycleWitheLifecycleServiceAssociate() throws LifecycleException {
        this.createDataWithLifecycleServiceAndTechService();
        this.lifecycleManager.deleteLifecycle(this.lifecycle1.getId());
    }
}

