/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.lifecycle;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.administration.UserException;
import org.ow2.dragon.api.service.lifecycle.LifecycleException;
import org.ow2.dragon.api.service.lifecycle.LifecycleServiceManager;
import org.ow2.dragon.api.to.deployment.TechnicalServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleStepServiceTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleTO;
import org.ow2.dragon.api.to.lifecycle.LifecycleUnderStepServiceTO;
import org.ow2.dragon.persistence.bo.administration.User;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.lifecycle.Lifecycle;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStep;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleStepService;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStep;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStepService;
import org.ow2.dragon.persistence.dao.administration.UserDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleServiceDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepDAO;
import org.ow2.dragon.persistence.dao.lifecycle.LifecycleStepServiceDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class LifecycleServiceManagerImplTest
extends CommonServiceConfig {
    private static String LIFECYCLE_NAME1 = "Lifecycle1";
    private static String LIFECYCLE_STEP_NAME1 = "Step1";
    private static String LIFECYCLE_STEP_NAME2 = "Step2";
    private static String LIFECYCLE_STEP_NAME3 = "Step3";
    private static String LIFECYCLE_UNDERSTEP_NAME1 = "UnderStep1";
    private static String LIFECYCLE_UNDERSTEP_NAME2 = "UnderStep2";
    private static String LIFECYCLE_UNDERSTEP_NAME3 = "UnderStep3";
    private static String LIFECYCLE_UNDERSTEP_NAME4 = "UnderStep4";
    private static String LIFECYCLE_UNDERSTEP_NAME5 = "UnderStep5";
    private static String USER_NAME = "master";
    private static Date DATE = new Date();
    private Lifecycle lifecycle1;
    private Lifecycle lifecycle2;
    private LifecycleStep lifecycleStep1;
    private LifecycleStep lifecycleStep2;
    private LifecycleStep lifecycleStep3;
    private LifecycleUnderStep lifecycleUnderStep1;
    private LifecycleUnderStep lifecycleUnderStep2;
    private LifecycleUnderStep lifecycleUnderStep3;
    private LifecycleUnderStep lifecycleUnderStep4;
    private LifecycleUnderStep lifecycleUnderStep5;
    private TechnicalService techService;
    private LifecycleService lifecycleService1;
    private LifecycleStepService lifecycleStepService1;
    private LifecycleStepService lifecycleStepService2;
    private LifecycleStepService lifecycleStepService3;
    private LifecycleUnderStepService lifecycleUnderStepService1;
    private LifecycleUnderStepService lifecycleUnderStepService2;
    private LifecycleUnderStepService lifecycleUnderStepService3;
    private LifecycleUnderStepService lifecycleUnderStepService4;
    private LifecycleUnderStepService lifecycleUnderStepService5;
    private User user;
    @Resource
    private LifecycleServiceManager lifecycleServiceManager;
    @Resource
    private LifecycleServiceDAO lifecycleServiceDAO;
    @Resource
    private LifecycleStepServiceDAO lifecycleStepServiceDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private LifecycleDAO lifecycleDAO;
    @Resource
    private LifecycleStepDAO lifecycleStepDAO;
    @Resource
    private UserDAO userDAO;

    public void createLifecycleData() {
        this.lifecycle1 = new Lifecycle();
        this.lifecycle1.setName(LIFECYCLE_NAME1);
        this.lifecycleStep1 = new LifecycleStep();
        this.lifecycleStep1.setName(LIFECYCLE_STEP_NAME1);
        this.lifecycleStep1.setIdx(0);
        this.lifecycleStep1.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep1 = new LifecycleUnderStep();
        this.lifecycleUnderStep1.setName(LIFECYCLE_UNDERSTEP_NAME1);
        this.lifecycleUnderStep1.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleUnderStep2 = new LifecycleUnderStep();
        this.lifecycleUnderStep2.setName(LIFECYCLE_UNDERSTEP_NAME2);
        this.lifecycleUnderStep2.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleStep1.addUnderStep(this.lifecycleUnderStep1);
        this.lifecycleStep1.addUnderStep(this.lifecycleUnderStep2);
        this.lifecycleStep2 = new LifecycleStep();
        this.lifecycleStep2.setName(LIFECYCLE_STEP_NAME2);
        this.lifecycleStep2.setIdx(1);
        this.lifecycleStep2.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep3 = new LifecycleUnderStep();
        this.lifecycleUnderStep3.setName(LIFECYCLE_UNDERSTEP_NAME3);
        this.lifecycleUnderStep3.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleUnderStep4 = new LifecycleUnderStep();
        this.lifecycleUnderStep4.setName(LIFECYCLE_UNDERSTEP_NAME4);
        this.lifecycleUnderStep4.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleStep2.addUnderStep(this.lifecycleUnderStep3);
        this.lifecycleStep2.addUnderStep(this.lifecycleUnderStep4);
        this.lifecycleStep3 = new LifecycleStep();
        this.lifecycleStep3.setName(LIFECYCLE_STEP_NAME3);
        this.lifecycleStep3.setIdx(1);
        this.lifecycleStep3.setLifecycle(this.lifecycle1);
        this.lifecycleUnderStep5 = new LifecycleUnderStep();
        this.lifecycleUnderStep5.setName(LIFECYCLE_UNDERSTEP_NAME5);
        this.lifecycleUnderStep5.setLifecycleStep(this.lifecycleStep3);
        this.lifecycleStep3.addUnderStep(this.lifecycleUnderStep5);
        this.lifecycle1.addStep(this.lifecycleStep1);
        this.lifecycle1.addStep(this.lifecycleStep2);
        this.lifecycle1.addStep(this.lifecycleStep3);
        this.lifecycleDAO.save((Object)this.lifecycle1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep1);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep2);
        this.lifecycleStepDAO.save((Object)this.lifecycleStep3);
        this.getHibernateSession().flush();
    }

    public void createTechServiceData() {
        this.techService = new TechnicalService();
        this.techService.setFullName("techService1");
        this.technicalServiceDAO.save((Object)this.techService);
        this.getHibernateSession().flush();
    }

    public void createLifecycleServiceData() {
        this.createLifecycleData();
        this.createTechServiceData();
        Long d = DATE.getTime();
        this.lifecycleService1 = new LifecycleService();
        this.lifecycleService1.setLifecycle(this.lifecycle1);
        this.lifecycleService1.setTechnicalService(this.techService);
        this.lifecycleStepService1 = new LifecycleStepService();
        this.lifecycleStepService1.setLifecycleService(this.lifecycleService1);
        this.lifecycleStepService1.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleStepService1.setStartDate(d.longValue());
        this.lifecycleUnderStepService1 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService1.setLifecycleStepService(this.lifecycleStepService1);
        this.lifecycleUnderStepService1.setLifecycleUnderStep(this.lifecycleUnderStep1);
        this.lifecycleUnderStepService2 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService2.setLifecycleStepService(this.lifecycleStepService1);
        this.lifecycleUnderStepService2.setLifecycleUnderStep(this.lifecycleUnderStep2);
        this.lifecycleStepService1.addUnderStep(this.lifecycleUnderStepService1);
        this.lifecycleStepService1.addUnderStep(this.lifecycleUnderStepService2);
        this.lifecycleStepService2 = new LifecycleStepService();
        this.lifecycleStepService2.setLifecycleService(this.lifecycleService1);
        this.lifecycleStepService2.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleUnderStepService3 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService3.setLifecycleStepService(this.lifecycleStepService2);
        this.lifecycleUnderStepService3.setLifecycleUnderStep(this.lifecycleUnderStep3);
        this.lifecycleUnderStepService4 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService4.setLifecycleStepService(this.lifecycleStepService2);
        this.lifecycleUnderStepService4.setLifecycleUnderStep(this.lifecycleUnderStep4);
        this.lifecycleStepService2.addUnderStep(this.lifecycleUnderStepService3);
        this.lifecycleStepService2.addUnderStep(this.lifecycleUnderStepService4);
        this.lifecycleStepService3 = new LifecycleStepService();
        this.lifecycleStepService3.setLifecycleService(this.lifecycleService1);
        this.lifecycleStepService3.setLifecycleStep(this.lifecycleStep3);
        this.lifecycleUnderStepService5 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService5.setLifecycleStepService(this.lifecycleStepService3);
        this.lifecycleUnderStepService5.setLifecycleUnderStep(this.lifecycleUnderStep5);
        this.lifecycleStepService3.addUnderStep(this.lifecycleUnderStepService5);
        this.lifecycleService1.addStep(this.lifecycleStepService1);
        this.lifecycleService1.addStep(this.lifecycleStepService2);
        this.lifecycleService1.addStep(this.lifecycleStepService3);
        this.lifecycleServiceDAO.save((Object)this.lifecycleService1);
        this.lifecycleStepServiceDAO.save((Object)this.lifecycleStepService1);
        this.lifecycleStepServiceDAO.save((Object)this.lifecycleStepService2);
        this.lifecycleStepServiceDAO.save((Object)this.lifecycleStepService3);
        this.getHibernateSession().flush();
    }

    public void createLifecycleOnly() {
        this.lifecycle2 = new Lifecycle();
        this.lifecycle2.setName("test");
        this.lifecycleDAO.save((Object)this.lifecycle2);
    }

    public void createUserData() {
        this.user = new User();
        this.user.setName(USER_NAME);
        this.user.setPassword("pass");
        this.userDAO.save((Object)this.user);
    }

    public void createLifecycleServiceWithClosedStepAndUser() {
        this.createLifecycleData();
        this.createTechServiceData();
        this.createUserData();
        Long d = DATE.getTime();
        this.lifecycleService1 = new LifecycleService();
        this.lifecycleService1.setLifecycle(this.lifecycle1);
        this.lifecycleService1.setTechnicalService(this.techService);
        this.lifecycleStepService1 = new LifecycleStepService();
        this.lifecycleStepService1.setLifecycleService(this.lifecycleService1);
        this.lifecycleStepService1.setLifecycleStep(this.lifecycleStep1);
        this.lifecycleStepService1.setStartDate(d.longValue());
        this.lifecycleStepService1.setEndDate(d.longValue());
        this.lifecycleStepService1.setPerson(this.user);
        this.lifecycleUnderStepService1 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService1.setLifecycleStepService(this.lifecycleStepService1);
        this.lifecycleUnderStepService1.setLifecycleUnderStep(this.lifecycleUnderStep1);
        this.lifecycleUnderStepService2 = new LifecycleUnderStepService();
        this.lifecycleUnderStepService2.setLifecycleStepService(this.lifecycleStepService1);
        this.lifecycleUnderStepService2.setLifecycleUnderStep(this.lifecycleUnderStep2);
        this.lifecycleStepService1.addUnderStep(this.lifecycleUnderStepService1);
        this.lifecycleStepService1.addUnderStep(this.lifecycleUnderStepService2);
        this.lifecycleStepService2 = new LifecycleStepService();
        this.lifecycleStepService2.setLifecycleService(this.lifecycleService1);
        this.lifecycleStepService2.setLifecycleStep(this.lifecycleStep2);
        this.lifecycleStepService2.setStartDate(d.longValue());
        this.lifecycleService1.addStep(this.lifecycleStepService1);
        this.lifecycleService1.addStep(this.lifecycleStepService2);
        this.lifecycleServiceDAO.save((Object)this.lifecycleService1);
    }

    @Test
    public void testGetLifecycleServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        LifecycleServiceTO lifecycleServiceTO = this.lifecycleServiceManager.getLifecycleService(this.lifecycleService1.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)lifecycleServiceTO.getTechnicalServiceTO().getId(), (String)this.techService.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testGetLifecycleServiceByIdUnknown() throws LifecycleException {
        this.lifecycleServiceManager.getLifecycleService("testId");
    }

    @Test
    public void testGetLifecycleServiceByTechServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        LifecycleServiceTO lifecycleServiceTO = this.lifecycleServiceManager.getLifecycleServiceByTechnicalService(this.techService.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)lifecycleServiceTO.getId(), (String)this.lifecycleService1.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testGetLifecycleServiceByTechServiceIdUnknown() throws LifecycleException {
        this.lifecycleServiceManager.getLifecycleServiceByTechnicalService("testId");
    }

    @Test
    public void testSaveLifecycleServiceNominal() throws LifecycleException {
        this.createLifecycleData();
        this.createTechServiceData();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle1.getId());
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId(this.techService.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        String id = this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
        LifecycleServiceTO l = this.lifecycleServiceManager.getLifecycleService(id);
        LifecycleServiceManagerImplTest.assertEquals((int)l.getListLifecycleStepService().size(), (int)3);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testSaveLifecycleServiceTwice() throws LifecycleException {
        this.createLifecycleServiceData();
        this.createLifecycleOnly();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle2.getId());
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId(this.techService.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testSaveLifecycleServiceTechServiceNull() throws LifecycleException {
        this.createLifecycleOnly();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle2.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(null);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testSaveLifecycleServiceIdTechServiceUnknown() throws LifecycleException {
        this.createLifecycleOnly();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle2.getId());
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId("testId");
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testSaveLifecycleServiceLifecycleNull() throws LifecycleException {
        this.createTechServiceData();
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId(this.techService.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(null);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testSaveLifecycleServiceIdLifecycleUnknown() throws LifecycleException {
        this.createTechServiceData();
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId("idTest");
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId(this.techService.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    public void testUpdateLifecycleServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        this.createLifecycleOnly();
        LifecycleServiceTO lifecycleServiceTO = this.lifecycleServiceManager.getLifecycleService(this.lifecycleService1.getId());
        LifecycleServiceManagerImplTest.assertEquals((int)lifecycleServiceTO.getListLifecycleStepService().size(), (int)3);
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle2.getId());
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        String id = this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
        LifecycleServiceTO l = this.lifecycleServiceManager.getLifecycleService(id);
        LifecycleServiceManagerImplTest.assertEquals((int)l.getListLifecycleStepService().size(), (int)0);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testUpdateLifecycleServiceByIdUnknown() throws LifecycleException {
        this.createTechServiceData();
        this.createLifecycleOnly();
        TechnicalServiceTO techServiceTO = new TechnicalServiceTO();
        techServiceTO.setId(this.techService.getId());
        LifecycleTO lifecycleTO = new LifecycleTO();
        lifecycleTO.setId(this.lifecycle2.getId());
        LifecycleServiceTO lifecycleServiceTO = new LifecycleServiceTO();
        lifecycleServiceTO.setId("testId");
        lifecycleServiceTO.setLifecycleTO(lifecycleTO);
        lifecycleServiceTO.setTechnicalServiceTO(techServiceTO);
        this.lifecycleServiceManager.saveOrUpdateLifecycleService(lifecycleServiceTO);
    }

    @Test
    public void testDeleteLifecycleServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        this.lifecycleServiceManager.deleteLifecycleService(this.lifecycleService1.getId());
        LifecycleServiceTO lifecycleService = this.lifecycleServiceManager.getLifecycleServiceByTechnicalService(this.techService.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)lifecycleService.getId(), null);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testDeleteLifecycleServiceByIdUnknown() throws LifecycleException {
        this.lifecycleServiceManager.deleteLifecycleService("testId");
    }

    @Test
    public void testDeleteLifecycleServiceByTechService() throws LifecycleException {
        this.createLifecycleServiceData();
        this.lifecycleServiceManager.deleteByTechServiceId(this.techService.getId());
        LifecycleServiceTO lifecycleService = this.lifecycleServiceManager.getLifecycleServiceByTechnicalService(this.techService.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)lifecycleService.getId(), null);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testDeleteLifecycleServiceByTechServiceIdUnknown() throws LifecycleException {
        this.lifecycleServiceManager.deleteByTechServiceId("testId");
    }

    @Test
    public void testGetStepService() throws LifecycleException {
        this.createLifecycleServiceData();
        LifecycleStepServiceTO stepServiceTO = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)stepServiceTO.getName(), (String)LIFECYCLE_STEP_NAME1);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testGetStepServiceByIdUnknown() throws LifecycleException {
        this.lifecycleServiceManager.getStepService("testId");
    }

    @Test
    public void testUpdateStepServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        LifecycleStepServiceTO lifecycleStepServiceTO = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        lifecycleStepServiceTO.setEndDate(new Date().getTime());
        String id = this.lifecycleServiceManager.saveOrUpadeLifecycleStepService(lifecycleStepServiceTO);
        LifecycleServiceManagerImplTest.assertEquals((String)id, (String)this.lifecycleStepService1.getId());
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testUpdateStepServiceByIdUnknown() throws LifecycleException {
        this.createLifecycleServiceData();
        LifecycleStepServiceTO lifecycleStepServiceTO = new LifecycleStepServiceTO();
        lifecycleStepServiceTO.setId("testId");
        this.lifecycleServiceManager.saveOrUpadeLifecycleStepService(lifecycleStepServiceTO);
    }

    @Test
    public void testCloseCurrentStepAndStartNextNominal() throws LifecycleException, UserException {
        this.createLifecycleServiceData();
        this.createUserData();
        long lo = 0L;
        String login = "master";
        LifecycleStepServiceTO lifecycleStepServiceTO = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        LifecycleServiceManagerImplTest.assertNotSame((Object)lifecycleStepServiceTO.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertSame((Object)lifecycleStepServiceTO.getEndDate(), (Object)lo);
        this.lifecycleServiceManager.closeCurrentStepAndStartNextStep(lifecycleStepServiceTO, login);
        LifecycleStepServiceTO l = this.lifecycleServiceManager.getStepService(lifecycleStepServiceTO.getId());
        LifecycleServiceManagerImplTest.assertNotSame((Object)l.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertNotSame((Object)l.getEndDate(), (Object)lo);
        LifecycleStepServiceTO l2 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService2.getId());
        LifecycleServiceManagerImplTest.assertNotSame((Object)l2.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertSame((Object)l2.getEndDate(), (Object)lo);
    }

    @Test
    @ExpectedException(value=LifecycleException.class)
    public void testCloseCurrentStepAndStartNextByUserUnknown() throws LifecycleException, UserException {
        this.createLifecycleServiceData();
        String login = "master";
        LifecycleStepServiceTO lifecycleStepServiceTO = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        this.lifecycleServiceManager.closeCurrentStepAndStartNextStep(lifecycleStepServiceTO, login);
    }

    @Test
    public void testOpenCurrentStep() throws LifecycleException {
        this.createLifecycleServiceWithClosedStepAndUser();
        long lo = 0L;
        LifecycleStepServiceTO stepServiceTO1 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        LifecycleServiceManagerImplTest.assertEquals((String)stepServiceTO1.getPerson().getName(), (String)USER_NAME);
        LifecycleServiceManagerImplTest.assertNotSame((Object)stepServiceTO1.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertNotSame((Object)stepServiceTO1.getEndDate(), (Object)lo);
        LifecycleStepServiceTO stepServiceTO2 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService2.getId());
        LifecycleServiceManagerImplTest.assertNotSame((Object)stepServiceTO2.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertSame((Object)stepServiceTO2.getEndDate(), (Object)lo);
        this.lifecycleServiceManager.openCurrentStepAndCloseNextStep(stepServiceTO1);
        LifecycleStepServiceTO stepServiceTO3 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        LifecycleServiceManagerImplTest.assertNull((Object)stepServiceTO3.getPerson().getName());
        LifecycleServiceManagerImplTest.assertNotSame((Object)stepServiceTO3.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertSame((Object)stepServiceTO3.getEndDate(), (Object)lo);
        LifecycleStepServiceTO stepServiceTO4 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService2.getId());
        LifecycleServiceManagerImplTest.assertSame((Object)stepServiceTO4.getStartDate(), (Object)lo);
        LifecycleServiceManagerImplTest.assertSame((Object)stepServiceTO4.getEndDate(), (Object)lo);
    }

    @Test
    public void testSaveOrUpdateUnderStepServiceNominal() throws LifecycleException {
        this.createLifecycleServiceData();
        long lo = 0L;
        LifecycleStepServiceTO stepServiceTO1 = this.lifecycleServiceManager.getStepService(this.lifecycleStepService1.getId());
        ArrayList<String> underStepSelectedIds = new ArrayList<String>();
        List listUnderStepTO = stepServiceTO1.getListUnderStepService();
        for (LifecycleUnderStepServiceTO underStepService : listUnderStepTO) {
            LifecycleServiceManagerImplTest.assertSame((Object)underStepService.getEndDate(), (Object)lo);
            underStepSelectedIds.add(underStepService.getId());
        }
        this.lifecycleServiceManager.updateCheckUnderStep(underStepSelectedIds, listUnderStepTO);
        for (LifecycleUnderStepServiceTO underStepService : listUnderStepTO) {
            LifecycleServiceManagerImplTest.assertNotSame((Object)underStepService.getEndDate(), (Object)lo);
        }
    }
}

