/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.mock;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager;
import org.ow2.dragon.connection.api.to.Endpoint;
import org.ow2.dragon.connection.api.to.EnvironmentFederation;
import org.ow2.dragon.connection.api.to.ExecutionEnvironment;
import org.ow2.dragon.connection.api.to.Processor;

@WebService(endpointInterface="org.ow2.dragon.connection.api.service.ExecutionEnvironmentManager")
public class PetalsEnvironmentManagerMock1
implements ExecutionEnvironmentManager {
    public List<ExecutionEnvironment> getFederationMembers(String arg0) {
        return null;
    }

    public List<Endpoint> getHostedEndpointsOnExecEnv(String arg0) {
        return null;
    }

    public List<Endpoint> getHostedEndpointsOnProcessor(String arg0) {
        return null;
    }

    public List<ExecutionEnvironment> getManagedExecutionEnvironments() {
        ArrayList<ExecutionEnvironment> result = new ArrayList<ExecutionEnvironment>();
        ExecutionEnvironment execEnv1 = new ExecutionEnvironment();
        execEnv1.setEnvType(ExecutionEnvironment.EEType.ESB);
        execEnv1.setIpv4Address("192.168.2.1");
        execEnv1.setName("petalsNode1");
        execEnv1.setRoleInFederation("master");
        execEnv1.setType("ExecutionEnvironmnent");
        ExecutionEnvironment execEnv2 = new ExecutionEnvironment();
        execEnv2.setEnvType(ExecutionEnvironment.EEType.ESB);
        execEnv2.setIpv4Address("192.168.2.2");
        execEnv2.setName("petalsNode2");
        execEnv2.setRoleInFederation("slave");
        execEnv2.setType("ExecutionEnvironmnent");
        ExecutionEnvironment execEnv3 = new ExecutionEnvironment();
        execEnv3.setEnvType(ExecutionEnvironment.EEType.APPLICATION_SERVER);
        execEnv3.setIpv4Address("192.168.2.3");
        execEnv3.setName("asNode1");
        execEnv3.setRoleInFederation("master");
        execEnv3.setType("ExecutionEnvironmnent");
        result.add(execEnv1);
        result.add(execEnv2);
        result.add(execEnv3);
        Endpoint endpoint1 = new Endpoint();
        Endpoint endpoint2 = new Endpoint();
        Endpoint endpoint3 = new Endpoint();
        try {
            String servDescription = this.readFileAsString("/globalweather.wsdl");
            endpoint1.setName(new QName("GlobalWeatherSoap"));
            endpoint1.setWsdlDescription(servDescription);
            endpoint2.setName(new QName("GlobalWeatherHttpPost"));
            endpoint2.setWsdlDescription(servDescription);
            endpoint3.setName(new QName("GlobalWeatherHttpGet"));
            endpoint3.setWsdlDescription(servDescription);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Processor processor1 = new Processor();
        processor1.setName("IBMServer1");
        processor1.setIpv4Address("192.168.2.1");
        processor1.setType("Processor");
        execEnv1.setEndpoints(new ArrayList());
        execEnv1.getEndpoints().add(endpoint1);
        execEnv1.getEndpoints().add(endpoint2);
        execEnv1.getEndpoints().add(endpoint3);
        execEnv1.setHostProcessor(processor1);
        EnvironmentFederation federation = new EnvironmentFederation();
        federation.setName("EnvFed1");
        federation.setPattern(EnvironmentFederation.FedPattern.DISTRIBUTED);
        federation.setPossibleRole(Arrays.asList("node"));
        execEnv1.setParentFederation(federation);
        return result;
    }

    private String readFileAsString(String filePath) throws IOException {
        URL resourceURL = this.getClass().getResource(filePath);
        File wsdl = new File(URI.create(resourceURL.toString()));
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(wsdl));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    public org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager getProperties() {
        org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager environmentManager = new org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager();
        environmentManager.setName("manager1");
        return environmentManager;
    }
}

