/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.OrganizationManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.common.KeyedRefTO;
import org.ow2.dragon.api.to.organization.OrganizationSearchProperties;
import org.ow2.dragon.api.to.organization.OrganizationUnitTO;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.common.CategoryDAO;
import org.ow2.dragon.persistence.dao.common.IdentifierDAO;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class OrganizationManagerImplTest
extends CommonServiceConfig {
    @Resource
    private CategoryDAO categoryDAO;
    @Resource
    private IdentifierDAO identifierDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    private static final String ORG1_CITY = "city Org 1";
    private static final String ORG1_NAME = "org1";
    private static final String POST1_NAME = "post1";
    private static final String POST2_NAME = "postBBB";
    private static final String POST3_NAME = "postAAA";
    private static final String CAT_VALUE1_DESC = "valueDesc1";
    private static final String CAT_VALUE1_VALUE = "value1";
    private static final String CAT_VALUE2_DESC = "valueDesc2";
    private static final String CAT_VALUE2_VALUE = "value2";
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private OrganizationUnit organizationUnitSearchTest1;
    private OrganizationUnit organizationUnitSearchTest2;
    private Category category1;
    private CategoryValue categoryValue1;
    private Identifier identifier1;
    private KeyedReference categoryRef1;
    private KeyedReference identifierRef1;
    private Category category2;
    private CategoryValue categoryValue2;
    private Identifier identifier2;
    private KeyedReference categoryRef2;
    private KeyedReference identifierRef2;
    private TModel categoryTModel1;
    private TModel identifierTModel1;
    private Post post1;
    private Post post2;
    private Post post3;
    @Resource
    private OrganizationManager organizationManager;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;

    public void createTestData() {
        this.organizationUnit1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName(ORG1_NAME);
        nameOrg1.setLangCode("en");
        this.organizationUnit1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine(ORG1_CITY);
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnit1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnit1.addEmail(email);
        this.organizationUnit2 = new OrganizationUnit();
        Name nameOrg2 = new Name();
        nameOrg2.setName("org2");
        nameOrg2.setLangCode("en");
        this.organizationUnit2.addName(nameOrg2);
        Address addressOrg2 = new Address();
        AddressLine addressLineOrg21 = new AddressLine();
        addressLineOrg21.setAddressLine("city Org 2");
        addressLineOrg21.setKeyName("city");
        addressOrg2.addAddressLine(addressLineOrg21);
        AddressLine addressLineOrg22 = new AddressLine();
        addressLineOrg22.setAddressLine("country Org 2");
        addressLineOrg22.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg22);
        this.organizationUnit2.addAddress(addressOrg2);
        Email email2 = new Email();
        email2.setEmail("email2@email2.com");
        this.organizationUnit2.addEmail(email2);
        this.category1 = new Category();
        this.category1.setName(new Name("en", "cat1"));
        this.categoryValue1 = new CategoryValue();
        this.categoryValue1.setValue(CAT_VALUE1_VALUE);
        this.categoryValue1.setDescription(CAT_VALUE1_DESC);
        this.category1.addValue(this.categoryValue1);
        this.category2 = new Category();
        this.category2.setName(new Name("en", "cat2"));
        this.categoryValue2 = new CategoryValue();
        this.categoryValue2.setValue(CAT_VALUE2_VALUE);
        this.categoryValue2.setDescription(CAT_VALUE2_DESC);
        this.category2.addValue(this.categoryValue2);
        this.identifier1 = new Identifier();
        this.identifier1.setName(new Name("en", "ident1"));
        this.identifier2 = new Identifier();
        this.identifier2.setName(new Name("en", "ident2"));
        this.post1 = new Post();
        this.post1.setName(POST1_NAME);
        this.post1.setDescription("descPost1");
        this.post1.setNature("naturePost1");
        this.post2 = new Post();
        this.post2.setName(POST2_NAME);
        this.post2.setDescription("descPost2");
        this.post2.setNature("naturePost2");
        this.post3 = new Post();
        this.post3.setName(POST3_NAME);
        this.post3.setDescription("descPost3");
        this.post3.setNature("naturePost3");
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.identifierTModel1 = new TModel();
        this.identifierTModel1.setName(new Name("en", "identifierTModel1"));
        this.categoryRef1 = new KeyedReference();
        this.categoryRef1.setKeyName(this.categoryValue1.getDescription());
        this.categoryRef1.setKeyValue(this.categoryValue1.getValue());
        this.categoryRef1.setTmodel(this.categoryTModel1);
        this.identifierRef1 = new KeyedReference();
        this.identifierRef1.setKeyName(this.identifier1.getName().getName());
        this.identifierRef1.setKeyValue("identifierValue1");
        this.identifierRef1.setTmodel(this.identifierTModel1);
        this.categoryRef2 = new KeyedReference();
        this.categoryRef2.setKeyName(this.categoryValue2.getDescription());
        this.categoryRef2.setKeyValue(this.categoryValue2.getValue());
        this.categoryRef2.setTmodel(this.categoryTModel1);
        this.identifierRef2 = new KeyedReference();
        this.identifierRef2.setKeyName(this.identifier2.getName().getName());
        this.identifierRef2.setKeyValue("identifierValue2");
        this.identifierRef2.setTmodel(this.identifierTModel1);
    }

    public void registerAddCategoryData() {
        this.createTestData();
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.categoryDAO.save((Object)this.category1);
        this.getHibernateSession().flush();
    }

    private void createSearchTestData() {
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.organizationUnitSearchTest1 = new OrganizationUnit();
        this.organizationUnitSearchTest1.addName(new Name("en", "Org Test 1"));
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine("A City");
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("A country");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnitSearchTest1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnitSearchTest1.addEmail(email);
        CategoryBag bag = new CategoryBag();
        KeyedReference keyedReference = new KeyedReference(this.categoryTModel1, "URL", "{http://www.serviceobjects.com/}DOTSFastWeather");
        bag.addKeyedReference(keyedReference);
        this.organizationUnitSearchTest1.setCategoryBag(bag);
        this.organizationUnitSearchTest2 = new OrganizationUnit();
        this.organizationUnitSearchTest2.addName(new Name("en", "Org Test 2"));
        Address addressOrg2 = new Address();
        AddressLine addressLineOrg21 = new AddressLine();
        addressLineOrg21.setAddressLine("A City 2");
        addressLineOrg21.setKeyName("city");
        addressOrg2.addAddressLine(addressLineOrg21);
        AddressLine addressLineOrg22 = new AddressLine();
        addressLineOrg22.setAddressLine("A country 2");
        addressLineOrg22.setKeyName("country");
        addressOrg2.addAddressLine(addressLineOrg22);
        this.organizationUnitSearchTest2.addAddress(addressOrg2);
        Email email2 = new Email();
        email2.setEmail("email2@email.com");
        this.organizationUnitSearchTest2.addEmail(email2);
        this.organizationUnitSearchTest2.setType("Public");
        CategoryBag bag2 = new CategoryBag();
        KeyedReference keyedReference2 = new KeyedReference(this.categoryTModel1, "business", "my business");
        bag2.addKeyedReference(keyedReference2);
        this.organizationUnitSearchTest2.setCategoryBag(bag2);
    }

    public void registerSearchTestData() {
        this.createSearchTestData();
        this.tModelDAO.save((Object)this.categoryTModel1);
        this.organizationUnitDAO.save((Object)this.organizationUnitSearchTest1);
        this.organizationUnitDAO.save((Object)this.organizationUnitSearchTest2);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    public void registerAddPostData() {
        this.createTestData();
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.postDAO.save((Object)this.post1);
        this.getHibernateSession().flush();
    }

    public void registerRemovePostData() {
        this.createTestData();
        this.postDAO.save((Object)this.post1);
        this.organizationUnit1.addPost(this.post1);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerGetPostData() {
        this.createTestData();
        this.postDAO.save((Object)this.post1);
        this.postDAO.save((Object)this.post2);
        this.postDAO.save((Object)this.post3);
        this.organizationUnit1.addPost(this.post1);
        this.organizationUnit1.addPost(this.post2);
        this.organizationUnit1.addPost(this.post3);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerGetCategoriesIdentifiersData() {
        this.createTestData();
        this.tModelDAO.save((Object)this.identifierTModel1);
        this.tModelDAO.save((Object)this.categoryTModel1);
        this.organizationUnit1.addIdentifier(this.identifierRef1);
        this.organizationUnit1.addIdentifier(this.identifierRef2);
        CategoryBag categoryBag = new CategoryBag();
        categoryBag.addKeyedReference(this.categoryRef1);
        categoryBag.addKeyedReference(this.categoryRef2);
        this.organizationUnit1.setCategoryBag(categoryBag);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerUpdateOrgData() {
        this.createTestData();
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.getHibernateSession().flush();
    }

    public void registerAddIdentifierData() {
        this.createTestData();
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.identifierDAO.save((Object)this.identifier1);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddCategoryNominal() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getCategoryBag().getKeyedReferences();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of category added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_VALUE, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_DESC, (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.category1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddCategoryEmptyValues() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory("", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddCategoryTwice() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), this.categoryValue1.getId());
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), this.categoryValue1.getId());
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValues() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddCategoryNominal2() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getCategoryBag().getKeyedReferences();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of category added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_VALUE, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_DESC, (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.category1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddCategoryEmptyValues2() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory("", "", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddCategoryEmptyDesc() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), CAT_VALUE1_VALUE, "");
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getCategoryBag().getKeyedReferences();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of category added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_VALUE, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)"", (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.category1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    public void testAddCategoryNullDesc() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), CAT_VALUE1_VALUE, null);
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getCategoryBag().getKeyedReferences();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of category added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)CAT_VALUE1_VALUE, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", null, (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.category1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddCategoryTwice2() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.organizationManager.addCategory(this.organizationUnit1.getId(), this.category1.getId(), CAT_VALUE1_VALUE, CAT_VALUE1_DESC);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddCategoryNullValues2() throws OrganizationException {
        this.registerAddCategoryData();
        this.organizationManager.addCategory(null, null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddIdentifierNominal() throws OrganizationException {
        this.registerAddIdentifierData();
        String identifierValue = "identValue";
        String identifierDesc = "identDesc";
        this.organizationManager.addIdentifier(this.organizationUnit1.getId(), this.identifier1.getId(), identifierValue, identifierDesc);
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getIdentifierBag();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of ident added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)identifierValue, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)identifierDesc, (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.identifier1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    public void testAddIdentifierEmptyDesc() throws OrganizationException {
        this.registerAddIdentifierData();
        String identifierValue = "identValue";
        this.organizationManager.addIdentifier(this.organizationUnit1.getId(), this.identifier1.getId(), identifierValue, "");
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getIdentifierBag();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of ident added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)identifierValue, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)"", (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.identifier1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    public void testAddIdentifierNullDesc() throws OrganizationException {
        this.registerAddIdentifierData();
        String identifierValue = "identValue";
        this.organizationManager.addIdentifier(this.organizationUnit1.getId(), this.identifier1.getId(), identifierValue, null);
        this.getHibernateSession().flush();
        List keyedReferences = this.organizationUnit1.getIdentifierBag();
        OrganizationManagerImplTest.assertNotNull((Object)keyedReferences);
        OrganizationManagerImplTest.assertEquals((String)"Bad number of ident added", (int)1, (int)keyedReferences.size());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)identifierValue, (String)((KeyedReference)keyedReferences.get(0)).getKeyValue());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", null, (String)((KeyedReference)keyedReferences.get(0)).getKeyName());
        OrganizationManagerImplTest.assertEquals((String)"Bad value added", (String)this.identifier1.getId(), (String)((KeyedReference)keyedReferences.get(0)).getTmodel().getId());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddIdentifierEmptyValues() throws OrganizationException {
        this.registerAddIdentifierData();
        this.organizationManager.addIdentifier("", "", "", "");
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddIdentifierTwice() throws OrganizationException {
        this.registerAddIdentifierData();
        String identifierValue = "identValue";
        String identifierDesc = "identDesc";
        this.organizationManager.addIdentifier(this.organizationUnit1.getId(), this.identifier1.getId(), identifierValue, identifierDesc);
        this.organizationManager.addIdentifier(this.organizationUnit1.getId(), this.identifier1.getId(), identifierValue, identifierDesc);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddIdentifierNullValues() throws OrganizationException {
        this.registerAddIdentifierData();
        this.organizationManager.addIdentifier(null, null, null, null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddPostNominal() throws OrganizationException {
        this.registerAddPostData();
        this.organizationManager.addPost(this.organizationUnit1.getId(), this.post1.getId());
        this.getHibernateSession().flush();
        OrganizationManagerImplTest.assertNotNull((Object)this.organizationUnit1.getPosts());
        OrganizationManagerImplTest.assertEquals((int)1, (int)this.organizationUnit1.getPosts().size());
        for (Post post : this.organizationUnit1.getPosts()) {
            OrganizationManagerImplTest.assertEquals((String)POST1_NAME, (String)post.getName());
        }
    }

    @Test
    public void testAddPostTwice() throws OrganizationException {
        this.registerAddPostData();
        this.organizationManager.addPost(this.organizationUnit1.getId(), this.post1.getId());
        this.organizationManager.addPost(this.organizationUnit1.getId(), this.post1.getId());
        this.getHibernateSession().flush();
        OrganizationManagerImplTest.assertNotNull((Object)this.organizationUnit1.getPosts());
        OrganizationManagerImplTest.assertEquals((int)1, (int)this.organizationUnit1.getPosts().size());
        for (Post post : this.organizationUnit1.getPosts()) {
            OrganizationManagerImplTest.assertEquals((String)POST1_NAME, (String)post.getName());
        }
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testAddPostNullValues() throws OrganizationException {
        this.registerAddPostData();
        this.organizationManager.addPost(null, null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testAddPostEmptyValues() throws OrganizationException {
        this.registerAddPostData();
        this.organizationManager.addPost("", "");
        this.getHibernateSession().flush();
    }

    @Test
    public void testCreateOrganizationNominal() throws OrganizationException {
        OrganizationUnitTO organizationUnitTO = new OrganizationUnitTO();
        organizationUnitTO.setName(ORG1_NAME);
        organizationUnitTO.setCity(ORG1_CITY);
        String orgId = this.organizationManager.createOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
        OrganizationUnit createdOrg = (OrganizationUnit)this.organizationUnitDAO.get((Serializable)((Object)orgId));
        OrganizationManagerImplTest.assertEquals((String)ORG1_NAME, (String)((Name)createdOrg.getNames().get(0)).getName());
        for (AddressLine addressLine : ((Address)createdOrg.getAddresses().get(0)).getAddressLines()) {
            if (!addressLine.getKeyName().equals("city")) continue;
            OrganizationManagerImplTest.assertEquals((String)ORG1_CITY, (String)addressLine.getAddressLine());
        }
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreateOrganizationTwice() throws OrganizationException {
        OrganizationUnitTO organizationUnitTO = new OrganizationUnitTO();
        organizationUnitTO.setName(ORG1_NAME);
        organizationUnitTO.setCity(ORG1_CITY);
        this.organizationManager.createOrganization(organizationUnitTO);
        this.organizationManager.createOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreateOrganizationNullCity() throws OrganizationException {
        OrganizationUnitTO organizationUnitTO = new OrganizationUnitTO();
        organizationUnitTO.setName(ORG1_NAME);
        organizationUnitTO.setCity(null);
        this.organizationManager.createOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreateOrganizationNullName() throws OrganizationException {
        OrganizationUnitTO organizationUnitTO = new OrganizationUnitTO();
        organizationUnitTO.setName(null);
        organizationUnitTO.setCity(ORG1_CITY);
        this.organizationManager.createOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreateOrganizationNullValue() throws OrganizationException {
        this.organizationManager.createOrganization(null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdateOrganization() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        String orgName = "Updated Name";
        organizationUnitTO.setName(orgName);
        this.organizationManager.updateOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
        OrganizationUnit updatedOrg = (OrganizationUnit)this.organizationUnitDAO.get((Serializable)((Object)this.organizationUnit1.getId()));
        OrganizationManagerImplTest.assertEquals((String)orgName, (String)((Name)updatedOrg.getNames().get(0)).getName());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdateOrganizationNullValue() throws OrganizationException {
        this.registerUpdateOrgData();
        this.organizationManager.updateOrganization(null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdateOrganizationNullId() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        organizationUnitTO.setId(null);
        this.organizationManager.updateOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdateOrganizationEmptyId() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        organizationUnitTO.setId("");
        this.organizationManager.updateOrganization(organizationUnitTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdateOrganizationSameNameCity() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO1 = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        OrganizationUnitTO organizationUnitTO2 = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit2);
        organizationUnitTO2.setName(organizationUnitTO1.getName());
        organizationUnitTO2.setCity(organizationUnitTO1.getCity());
        this.organizationManager.updateOrganization(organizationUnitTO2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdateOrganizationSameNameCityId() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO1 = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        this.organizationManager.updateOrganization(organizationUnitTO1);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetAllOrgsNominal() throws OrganizationException {
        this.registerUpdateOrgData();
        List orgs1 = this.organizationManager.getAllOrganizations(null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs1);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs1.size());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.PARTY_NAME);
        List orgs2 = this.organizationManager.getAllOrganizations(requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)orgs2);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs2.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)((OrganizationUnitTO)orgs2.get(0)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit2.getId(), (String)((OrganizationUnitTO)orgs2.get(1)).getId());
        RequestOptionsTO requestOptionsTO2 = new RequestOptionsTO();
        requestOptionsTO2.setSortAscendingly(false);
        requestOptionsTO2.setSortCriteria(SortCriteria.PARTY_NAME);
        List orgs3 = this.organizationManager.getAllOrganizations(requestOptionsTO2);
        OrganizationManagerImplTest.assertNotNull((Object)orgs3);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs3.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit2.getId(), (String)((OrganizationUnitTO)orgs3.get(0)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)((OrganizationUnitTO)orgs3.get(1)).getId());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdateOrganizationMeAsMotherOrg() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organizationUnitTO1 = this.transfertObjectAssembler.toOrganizationUnitTO(this.organizationUnit1);
        organizationUnitTO1.setMotherOrganization(organizationUnitTO1);
        this.organizationManager.updateOrganization(organizationUnitTO1);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetCategoriesForOrgNominal() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        List cats = this.organizationManager.getCategoriesForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)cats);
        OrganizationManagerImplTest.assertEquals((int)2, (int)cats.size());
        ArrayList<String> catIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : cats) {
            catIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef2.getId()));
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetCategoriesForOrgNullValue() throws OrganizationException {
        this.organizationManager.getCategoriesForOrg(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetCategoriesForOrgBadValue() throws OrganizationException {
        this.organizationManager.getCategoriesForOrg("bad");
    }

    @Test
    public void testGetIdentifiersForOrgNominal() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        List idents = this.organizationManager.getIdentifiersForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)idents);
        OrganizationManagerImplTest.assertEquals((int)2, (int)idents.size());
        ArrayList<String> identIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : idents) {
            identIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef2.getId()));
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetIdentifiersForOrgNullValue() throws OrganizationException {
        this.organizationManager.getCategoriesForOrg(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetIdentifiersForOrgBadValue() throws OrganizationException {
        this.organizationManager.getCategoriesForOrg("bad");
    }

    @Test
    public void testGetOrgNominal() throws OrganizationException {
        this.registerUpdateOrgData();
        OrganizationUnitTO organization = this.organizationManager.getOrganization(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)organization);
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)organization.getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetOrgNullValue() throws OrganizationException {
        this.organizationManager.getOrganization(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetOrgBadValue() throws OrganizationException {
        this.organizationManager.getOrganization("bad");
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetAllOrgsWithoutMeAndMyChildNullValue() throws OrganizationException {
        this.organizationManager.getAllOrgsWithoutMeAndMyChildren(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetAllOrgsWithoutMeAndMyChildBadValue() throws OrganizationException {
        this.organizationManager.getAllOrgsWithoutMeAndMyChildren("bad");
    }

    @Test
    public void testRemoveIdentifiersNominal() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> identIdsToRemove = new ArrayList<String>();
        identIdsToRemove.add(this.identifierRef2.getId());
        this.organizationManager.removeIdentifiers(this.organizationUnit1.getId(), identIdsToRemove);
        List idents = this.organizationManager.getIdentifiersForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)idents);
        OrganizationManagerImplTest.assertEquals((int)1, (int)idents.size());
        ArrayList<String> identIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : idents) {
            identIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef1.getId()));
    }

    @Test
    public void testRemoveIdentifiersNominal2() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> identIdsToRemove = new ArrayList<String>();
        identIdsToRemove.add(this.identifierRef1.getId());
        identIdsToRemove.add(this.identifierRef2.getId());
        this.organizationManager.removeIdentifiers(this.organizationUnit1.getId(), identIdsToRemove);
        List idents = this.organizationManager.getIdentifiersForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)idents);
        OrganizationManagerImplTest.assertEquals((int)0, (int)idents.size());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveIdentifiersNullValue() throws OrganizationException {
        this.organizationManager.removeIdentifiers(null, null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testRemoveIdentifiersBadValue() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> identIdsToRemove = new ArrayList<String>();
        identIdsToRemove.add(this.identifierRef1.getId());
        this.organizationManager.removeIdentifiers("bad", identIdsToRemove);
    }

    @Test
    public void testRemoveIdentifiersBadValue2() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> identIdsToRemove = new ArrayList<String>();
        identIdsToRemove.add("bad");
        this.organizationManager.removeIdentifiers(this.organizationUnit1.getId(), identIdsToRemove);
        List idents = this.organizationManager.getIdentifiersForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)idents);
        OrganizationManagerImplTest.assertEquals((int)2, (int)idents.size());
        ArrayList<String> identIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : idents) {
            identIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef2.getId()));
    }

    @Test
    public void testRemoveIdentifiersEmptyList() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList identIdsToRemove = new ArrayList();
        this.organizationManager.removeIdentifiers(this.organizationUnit1.getId(), identIdsToRemove);
        List idents = this.organizationManager.getIdentifiersForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)idents);
        OrganizationManagerImplTest.assertEquals((int)2, (int)idents.size());
        ArrayList<String> identIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : idents) {
            identIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)identIds.contains(this.identifierRef2.getId()));
    }

    @Test
    public void testRemoveCategoriesNominal() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> catIdsToRemove = new ArrayList<String>();
        catIdsToRemove.add(this.categoryRef2.getId());
        this.organizationManager.removeCategories(this.organizationUnit1.getId(), catIdsToRemove);
        List cats = this.organizationManager.getCategoriesForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)cats);
        OrganizationManagerImplTest.assertEquals((int)1, (int)cats.size());
        ArrayList<String> catIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : cats) {
            catIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef1.getId()));
    }

    @Test
    public void testRemoveCategoriesNominal2() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> catIdsToRemove = new ArrayList<String>();
        catIdsToRemove.add(this.categoryRef2.getId());
        catIdsToRemove.add(this.categoryRef1.getId());
        this.organizationManager.removeCategories(this.organizationUnit1.getId(), catIdsToRemove);
        List cats = this.organizationManager.getCategoriesForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)cats);
        OrganizationManagerImplTest.assertEquals((int)0, (int)cats.size());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveCategoriesNullValue() throws OrganizationException {
        this.organizationManager.removeCategories(null, null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testRemoveCategoriesBadValue() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> catIdsToRemove = new ArrayList<String>();
        catIdsToRemove.add(this.categoryRef1.getId());
        this.organizationManager.removeCategories("bad", catIdsToRemove);
    }

    @Test
    public void testRemoveCategoriesBadValue2() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList<String> catIdsToRemove = new ArrayList<String>();
        catIdsToRemove.add("bad");
        this.organizationManager.removeCategories(this.organizationUnit1.getId(), catIdsToRemove);
        List cats = this.organizationManager.getCategoriesForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)cats);
        OrganizationManagerImplTest.assertEquals((int)2, (int)cats.size());
        ArrayList<String> catIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : cats) {
            catIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef2.getId()));
    }

    @Test
    public void testRemoveCategoriesEmptyList() throws OrganizationException {
        this.registerGetCategoriesIdentifiersData();
        ArrayList catIdsToRemove = new ArrayList();
        this.organizationManager.removeCategories(this.organizationUnit1.getId(), catIdsToRemove);
        List cats = this.organizationManager.getCategoriesForOrg(this.organizationUnit1.getId());
        OrganizationManagerImplTest.assertNotNull((Object)cats);
        OrganizationManagerImplTest.assertEquals((int)2, (int)cats.size());
        ArrayList<String> catIds = new ArrayList<String>();
        for (KeyedRefTO keyedRefTO : cats) {
            catIds.add(keyedRefTO.getKefRefId());
        }
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef1.getId()));
        OrganizationManagerImplTest.assertTrue((boolean)catIds.contains(this.categoryRef2.getId()));
    }

    @Test
    public void testRemoveOrganization() throws OrganizationException {
        this.registerUpdateOrgData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.PARTY_NAME);
        List orgs = this.organizationManager.getAllOrganizations(requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit2.getId(), (String)((OrganizationUnitTO)orgs.get(1)).getId());
        this.organizationManager.removeOrganization(this.organizationUnit1.getId());
        this.getHibernateSession().flush();
        List orgs2 = this.organizationManager.getAllOrganizations(requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)orgs2);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs2.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit2.getId(), (String)((OrganizationUnitTO)orgs2.get(0)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemoveOrgNullValue() throws OrganizationException {
        this.organizationManager.removeOrganization(null);
    }

    @Test
    public void testRemoveOrgEmptyValue() throws OrganizationException {
        this.registerUpdateOrgData();
        this.organizationManager.removeOrganization("");
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.PARTY_NAME);
        List orgs = this.organizationManager.getAllOrganizations(requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnit2.getId(), (String)((OrganizationUnitTO)orgs.get(1)).getId());
    }

    @Test
    public void testGetPostByOrgNominal() throws OrganizationException {
        this.registerGetPostData();
        List posts = this.organizationManager.getPostsByOrganization(this.organizationUnit1.getId(), null);
        OrganizationManagerImplTest.assertNotNull((Object)posts);
        OrganizationManagerImplTest.assertEquals((int)3, (int)posts.size());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.POST_NAME);
        List posts2 = this.organizationManager.getPostsByOrganization(this.organizationUnit1.getId(), requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)posts2);
        OrganizationManagerImplTest.assertEquals((int)3, (int)posts2.size());
        OrganizationManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts2.get(0)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.post3.getId(), (String)((PostTO)posts2.get(1)).getId());
        OrganizationManagerImplTest.assertEquals((String)this.post2.getId(), (String)((PostTO)posts2.get(2)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetPostByOrgNullValue() throws OrganizationException {
        List posts = this.organizationManager.getPostsByOrganization(null, null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetPostByOrgEmptyValue() throws OrganizationException {
        List posts = this.organizationManager.getPostsByOrganization("", null);
    }

    @Test
    public void testRemovePost() throws OrganizationException {
        this.registerRemovePostData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.POST_NAME);
        List posts = this.organizationManager.getPostsByOrganization(this.organizationUnit1.getId(), requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)posts);
        OrganizationManagerImplTest.assertEquals((int)1, (int)posts.size());
        OrganizationManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts.get(0)).getId());
        this.organizationManager.removePost(this.organizationUnit1.getId(), this.post1.getId());
        this.getHibernateSession().flush();
        List posts2 = this.organizationManager.getPostsByOrganization(this.organizationUnit1.getId(), requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)posts2);
        OrganizationManagerImplTest.assertEquals((int)0, (int)posts2.size());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemovePostNullValue() throws OrganizationException {
        this.organizationManager.removePost(null, null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testRemovePostEmptyValue() throws OrganizationException {
        this.registerRemovePostData();
        this.organizationManager.removePost("", this.post1.getId());
    }

    @Test
    public void testRemovePostEmptyValue2() throws OrganizationException {
        this.registerRemovePostData();
        this.organizationManager.removePost(this.organizationUnit1.getId(), "");
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.POST_NAME);
        List posts = this.organizationManager.getPostsByOrganization(this.organizationUnit1.getId(), requestOptionsTO);
        OrganizationManagerImplTest.assertNotNull((Object)posts);
        OrganizationManagerImplTest.assertEquals((int)1, (int)posts.size());
        OrganizationManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts.get(0)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testSearchOrgNullValue() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = null;
        List searchedProperties = null;
        RequestOptionsTO requestOptions = null;
        this.organizationManager.searchOrganization(searchCriteria, searchedProperties, requestOptions);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testSearchOrgEmptyValues() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "";
        ArrayList searchedProperties = new ArrayList();
        RequestOptionsTO requestOptions = null;
        this.organizationManager.searchOrganization(searchCriteria, searchedProperties, requestOptions);
    }

    @Test
    public void testSearchOrg() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "{http://www.serviceobjects.com/}DOTSFastWeather";
        List searchedProperties = null;
        List orgs = this.organizationManager.searchOrganization(searchCriteria, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
        String searchCriteria3 = "ht*";
        List orgs3 = this.organizationManager.searchOrganization(searchCriteria3, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs3);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs3.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs3.get(0)).getId());
        String searchCriteria4 = "h??p";
        List orgs4 = this.organizationManager.searchOrganization(searchCriteria4, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs4);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs4.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs4.get(0)).getId());
        String searchCriteria6 = "h*p";
        List orgs6 = this.organizationManager.searchOrganization(searchCriteria6, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs6);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs6.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs6.get(0)).getId());
        String searchCriteria2 = "htvp~0.6";
        List orgs2 = this.organizationManager.searchOrganization(searchCriteria2, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs2);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs2.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs2.get(0)).getId());
        String searchCriteria7 = "~http";
        List orgs7 = this.organizationManager.searchOrganization(searchCriteria7, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs7);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs7.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs7.get(0)).getId());
        String searchCriteria8 = "ht~tp";
        List orgs8 = this.organizationManager.searchOrganization(searchCriteria8, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs8);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs8.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs8.get(0)).getId());
        String searchCriteria9 = "htvp~0";
        List orgs9 = this.organizationManager.searchOrganization(searchCriteria9, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs9);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs9.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs9.get(0)).getId());
        String searchCriteria10 = "htvp~0.1";
        List orgs10 = this.organizationManager.searchOrganization(searchCriteria10, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs10);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs10.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs10.get(0)).getId());
        String searchCriteria11 = "htvp~0.9";
        List orgs11 = this.organizationManager.searchOrganization(searchCriteria11, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs11);
        OrganizationManagerImplTest.assertEquals((int)0, (int)orgs11.size());
        String searchCriteria12 = "http~.5";
        List orgs12 = this.organizationManager.searchOrganization(searchCriteria12, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs12);
        OrganizationManagerImplTest.assertEquals((int)0, (int)orgs12.size());
        String searchCriteria13 = "http~7.3";
        List orgs13 = this.organizationManager.searchOrganization(searchCriteria13, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs13);
        OrganizationManagerImplTest.assertEquals((int)0, (int)orgs13.size());
        String searchCriteria14 = "http~0.";
        List orgs14 = this.organizationManager.searchOrganization(searchCriteria14, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs14);
        OrganizationManagerImplTest.assertEquals((int)0, (int)orgs14.size());
        String searchCriteria15 = "htv~0.9p";
        List orgs15 = this.organizationManager.searchOrganization(searchCriteria15, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs15);
        OrganizationManagerImplTest.assertEquals((int)0, (int)orgs15.size());
    }

    @Test
    public void testSearchOrgOnName() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "org test 1";
        ArrayList<OrganizationSearchProperties> searchedProperties = new ArrayList<OrganizationSearchProperties>();
        searchedProperties.add(OrganizationSearchProperties.NAME);
        List orgs = this.organizationManager.searchOrganization(searchCriteria, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest1.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
        String searchCriteria2 = "o*";
        ArrayList<OrganizationSearchProperties> searchedProperties2 = new ArrayList<OrganizationSearchProperties>();
        searchedProperties2.add(OrganizationSearchProperties.NAME);
        List orgs2 = this.organizationManager.searchOrganization(searchCriteria2, searchedProperties2, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs2);
        OrganizationManagerImplTest.assertEquals((int)2, (int)orgs2.size());
    }

    @Test
    public void testSearchOrgOnCategory() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "my business";
        ArrayList<OrganizationSearchProperties> searchedProperties = new ArrayList<OrganizationSearchProperties>();
        searchedProperties.add(OrganizationSearchProperties.CATEGORY);
        List orgs = this.organizationManager.searchOrganization(searchCriteria, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest2.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
    }

    @Test
    public void testSearchOrgOnType() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "public";
        ArrayList<OrganizationSearchProperties> searchedProperties = new ArrayList<OrganizationSearchProperties>();
        searchedProperties.add(OrganizationSearchProperties.TYPE);
        List orgs = this.organizationManager.searchOrganization(searchCriteria, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest2.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
    }

    @Test
    public void testSearchOrgOnLocalization() throws OrganizationException {
        this.registerSearchTestData();
        String searchCriteria = "a country city 2";
        ArrayList<OrganizationSearchProperties> searchedProperties = new ArrayList<OrganizationSearchProperties>();
        searchedProperties.add(OrganizationSearchProperties.LOCALIZATION);
        List orgs = this.organizationManager.searchOrganization(searchCriteria, searchedProperties, null);
        OrganizationManagerImplTest.assertNotNull((Object)orgs);
        OrganizationManagerImplTest.assertEquals((int)1, (int)orgs.size());
        OrganizationManagerImplTest.assertEquals((String)this.organizationUnitSearchTest2.getId(), (String)((OrganizationUnitTO)orgs.get(0)).getId());
    }
}

