/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PersonManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.organization.PersonSearchProperties;
import org.ow2.dragon.api.to.organization.PersonTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.Identifier;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class PersonManagerImplTest
extends CommonServiceConfig {
    private static final String PERS_EMAIL1 = "person1@email.com";
    private static final String PERS_LAST_NAME1 = "lastName1";
    private static final String PERS_FIRST_NAME1 = "firstName1";
    private static final String ORG1_CITY = "city Org 1";
    private static final String ORG1_NAME = "org1";
    private static final String POST1_NAME = "post1";
    private static final String POST2_NAME = "postBBB";
    private static final String POST3_NAME = "postAAA";
    private static final String CAT_VALUE1_DESC = "valueDesc1";
    private static final String CAT_VALUE1_VALUE = "value1";
    private static final String CAT_VALUE2_DESC = "valueDesc2";
    private static final String CAT_VALUE2_VALUE = "value2";
    private OrganizationUnit organizationUnit1;
    private OrganizationUnit organizationUnit2;
    private Person person1;
    private Person person2;
    private Category category1;
    private CategoryValue categoryValue1;
    private Identifier identifier1;
    private KeyedReference categoryRef1;
    private KeyedReference identifierRef1;
    private Category category2;
    private CategoryValue categoryValue2;
    private Identifier identifier2;
    private KeyedReference categoryRef2;
    private KeyedReference identifierRef2;
    private TModel categoryTModel1;
    private TModel identifierTModel1;
    private Post post1;
    private Post post2;
    private Post post3;
    @Resource
    private PersonManager personManager;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    @Resource
    private PersonDAO personDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;

    public void createTestData() {
        this.organizationUnit1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName(ORG1_NAME);
        nameOrg1.setLangCode("en");
        this.organizationUnit1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine(ORG1_CITY);
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnit1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnit1.addEmail(email);
        this.organizationUnit2 = new OrganizationUnit();
        Name nameOrg2 = new Name();
        nameOrg2.setName("org2");
        nameOrg2.setLangCode("en");
        this.organizationUnit2.addName(nameOrg2);
        Address addressOrg2 = new Address();
        AddressLine addressLineOrg21 = new AddressLine();
        addressLineOrg21.setAddressLine("city Org 2");
        addressLineOrg21.setKeyName("city");
        addressOrg2.addAddressLine(addressLineOrg21);
        AddressLine addressLineOrg22 = new AddressLine();
        addressLineOrg22.setAddressLine("country Org 2");
        addressLineOrg22.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg22);
        this.organizationUnit2.addAddress(addressOrg2);
        Email email2 = new Email();
        email2.setEmail("email2@email2.com");
        this.organizationUnit2.addEmail(email2);
        this.category1 = new Category();
        this.category1.setName(new Name("en", "cat1"));
        this.categoryValue1 = new CategoryValue();
        this.categoryValue1.setValue(CAT_VALUE1_VALUE);
        this.categoryValue1.setDescription(CAT_VALUE1_DESC);
        this.category1.addValue(this.categoryValue1);
        this.category2 = new Category();
        this.category2.setName(new Name("en", "cat2"));
        this.categoryValue2 = new CategoryValue();
        this.categoryValue2.setValue(CAT_VALUE2_VALUE);
        this.categoryValue2.setDescription(CAT_VALUE2_DESC);
        this.category2.addValue(this.categoryValue2);
        this.identifier1 = new Identifier();
        this.identifier1.setName(new Name("en", "ident1"));
        this.identifier2 = new Identifier();
        this.identifier2.setName(new Name("en", "ident2"));
        this.post1 = new Post();
        this.post1.setName(POST1_NAME);
        this.post1.setDescription("descPost1");
        this.post1.setNature("naturePost1");
        this.post2 = new Post();
        this.post2.setName(POST2_NAME);
        this.post2.setDescription("descPost2");
        this.post2.setNature("naturePost2");
        this.post3 = new Post();
        this.post3.setName(POST3_NAME);
        this.post3.setDescription("descPost3");
        this.post3.setNature("naturePost3");
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.identifierTModel1 = new TModel();
        this.identifierTModel1.setName(new Name("en", "identifierTModel1"));
        this.categoryRef1 = new KeyedReference();
        this.categoryRef1.setKeyName(this.categoryValue1.getDescription());
        this.categoryRef1.setKeyValue(this.categoryValue1.getValue());
        this.categoryRef1.setTmodel(this.categoryTModel1);
        this.identifierRef1 = new KeyedReference();
        this.identifierRef1.setKeyName(this.identifier1.getName().getName());
        this.identifierRef1.setKeyValue("identifierValue1");
        this.identifierRef1.setTmodel(this.identifierTModel1);
        this.categoryRef2 = new KeyedReference();
        this.categoryRef2.setKeyName(this.categoryValue2.getDescription());
        this.categoryRef2.setKeyValue(this.categoryValue2.getValue());
        this.categoryRef2.setTmodel(this.categoryTModel1);
        this.identifierRef2 = new KeyedReference();
        this.identifierRef2.setKeyName(this.identifier2.getName().getName());
        this.identifierRef2.setKeyValue("identifierValue2");
        this.identifierRef2.setTmodel(this.identifierTModel1);
        this.person1 = new Person();
        this.person1.setFirstName(PERS_FIRST_NAME1);
        this.person1.setLastName(PERS_LAST_NAME1);
        Email emailPers1 = new Email();
        emailPers1.setEmail(PERS_EMAIL1);
        this.person1.addEmail(emailPers1);
        this.person1.setParentOrganization(this.organizationUnit1);
        this.person1.setPost(this.post1);
        PhoneNumber phoneNumber1 = new PhoneNumber();
        phoneNumber1.setPhoneNumber("0505050505");
        this.person1.addPhoneNumber(phoneNumber1);
        this.person2 = new Person();
        this.person2.setFirstName("firstName2");
        this.person2.setLastName("lastName2");
        Email emailPers2 = new Email();
        emailPers2.setEmail("person2@email.com");
        this.person2.addEmail(emailPers2);
        this.person2.setParentOrganization(this.organizationUnit2);
        this.person2.setPost(this.post2);
        PhoneNumber phoneNumber2 = new PhoneNumber();
        phoneNumber2.setPhoneNumber("0505050506");
        this.person2.addPhoneNumber(phoneNumber2);
    }

    public void registerCreateTestData() {
        this.createTestData();
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.organizationUnitDAO.save((Object)this.organizationUnit2);
        this.postDAO.save((Object)this.post1);
        this.postDAO.save((Object)this.post2);
        this.personDAO.save((Object)this.person1);
        this.personDAO.save((Object)this.person2);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    @Test
    public void testCreatePersonNominal() throws OrganizationException {
        PersonTO personTO = new PersonTO();
        personTO.setFirstname(PERS_FIRST_NAME1);
        personTO.setLastname(PERS_LAST_NAME1);
        personTO.setEmail(PERS_EMAIL1);
        String personId = this.personManager.createPerson(personTO);
        this.getHibernateSession().flush();
        Person createdPers = (Person)this.personDAO.get((Serializable)((Object)personId));
        PersonManagerImplTest.assertEquals((String)PERS_FIRST_NAME1, (String)createdPers.getFirstName());
        PersonManagerImplTest.assertEquals((String)PERS_LAST_NAME1, (String)createdPers.getLastName());
        PersonManagerImplTest.assertEquals((String)PERS_EMAIL1, (String)((Email)createdPers.getEmailAddresses().get(0)).getEmail());
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePersonTwice() throws OrganizationException {
        PersonTO personTO = new PersonTO();
        personTO.setFirstname(PERS_FIRST_NAME1);
        personTO.setLastname(PERS_LAST_NAME1);
        personTO.setEmail(PERS_EMAIL1);
        this.personManager.createPerson(personTO);
        this.personManager.createPerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePersonNullFirstName() throws OrganizationException {
        PersonTO personTO = new PersonTO();
        personTO.setFirstname(null);
        personTO.setLastname(PERS_LAST_NAME1);
        personTO.setEmail(PERS_EMAIL1);
        this.personManager.createPerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePersonNullLastName() throws OrganizationException {
        PersonTO personTO = new PersonTO();
        personTO.setFirstname(PERS_FIRST_NAME1);
        personTO.setLastname(null);
        personTO.setEmail(PERS_EMAIL1);
        this.personManager.createPerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePersonNullEmail() throws OrganizationException {
        PersonTO personTO = new PersonTO();
        personTO.setFirstname(PERS_FIRST_NAME1);
        personTO.setLastname(PERS_LAST_NAME1);
        personTO.setEmail(null);
        this.personManager.createPerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreatePersonNullValue() throws OrganizationException {
        this.personManager.createPerson(null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetAllPersonsNominal() throws OrganizationException {
        this.registerCreateTestData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(false);
        requestOptionsTO.setSortCriteria(SortCriteria.PERSON_LASTNAME);
        List pers1 = this.personManager.getAllPersons(requestOptionsTO);
        PersonManagerImplTest.assertNotNull((Object)pers1);
        PersonManagerImplTest.assertEquals((int)2, (int)pers1.size());
        PersonManagerImplTest.assertEquals((String)this.person2.getId(), (String)((PersonTO)pers1.get(0)).getId());
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonTO)pers1.get(1)).getId());
    }

    @Test
    public void testGetPersonNominal() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO person = this.personManager.getPerson(this.person1.getId());
        PersonManagerImplTest.assertNotNull((Object)person);
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)person.getId());
        PersonManagerImplTest.assertEquals((String)this.person1.getFirstName(), (String)person.getFirstname());
        PersonManagerImplTest.assertEquals((String)this.person1.getLastName(), (String)person.getLastname());
        PersonManagerImplTest.assertEquals((String)this.person1.getLocation(), (String)person.getLocalization());
        PersonManagerImplTest.assertEquals((String)this.person1.getMiddleName(), (String)person.getMiddlename());
        PersonManagerImplTest.assertEquals((String)this.person1.getTitle(), (String)person.getTitle());
        PersonManagerImplTest.assertEquals((boolean)this.person1.isContact(), (boolean)person.isContact());
        PersonManagerImplTest.assertEquals((String)((Email)this.person1.getEmailAddresses().get(0)).getEmail(), (String)person.getEmail());
        PersonManagerImplTest.assertEquals((String)this.person1.getParentOrganization().getId(), (String)person.getOrganization().getId());
        PersonManagerImplTest.assertEquals((String)((PhoneNumber)this.person1.getPhoneNumbers().get(0)).getPhoneNumber(), (String)person.getPhone());
        PersonManagerImplTest.assertEquals((String)this.person1.getPost().getId(), (String)person.getPost().getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetPersonNullValue() throws OrganizationException {
        this.personManager.getPerson(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetPersonBadValue() throws OrganizationException {
        this.personManager.getPerson("bad");
    }

    @Test
    public void testRemovePerson() throws OrganizationException {
        this.registerCreateTestData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.PERSON_LASTNAME);
        List pers = this.personManager.getAllPersons(requestOptionsTO);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)2, (int)pers.size());
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonTO)pers.get(0)).getId());
        PersonManagerImplTest.assertEquals((String)this.person2.getId(), (String)((PersonTO)pers.get(1)).getId());
        this.personManager.removePerson(this.person1.getId());
        this.getHibernateSession().flush();
        List pers2 = this.personManager.getAllPersons(requestOptionsTO);
        PersonManagerImplTest.assertNotNull((Object)pers2);
        PersonManagerImplTest.assertEquals((int)1, (int)pers2.size());
        PersonManagerImplTest.assertEquals((String)this.person2.getId(), (String)((PersonTO)pers2.get(0)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemovePersonNullValue() throws OrganizationException {
        this.personManager.removePerson(null);
    }

    @Test
    public void testRemovePersonEmptyValue() throws OrganizationException {
        this.registerCreateTestData();
        this.personManager.removePerson("");
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.PERSON_LASTNAME);
        List pers = this.personManager.getAllPersons(requestOptionsTO);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)2, (int)pers.size());
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonTO)pers.get(0)).getId());
        PersonManagerImplTest.assertEquals((String)this.person2.getId(), (String)((PersonTO)pers.get(1)).getId());
    }

    @Test
    public void testUpdatePerson() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO personTO = this.transfertObjectAssembler.toPersonTO(this.person1);
        String personLastname = "Updated lastname";
        personTO.setLastname(personLastname);
        this.personManager.updatePerson(personTO);
        this.getHibernateSession().flush();
        Person updatedPerson = (Person)this.personDAO.get((Serializable)((Object)this.person1.getId()));
        PersonManagerImplTest.assertEquals((String)personLastname, (String)updatedPerson.getLastName());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdatePersonNullValue() throws OrganizationException {
        this.registerCreateTestData();
        this.personManager.updatePerson(null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdatePersonNullId() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO personTO = this.transfertObjectAssembler.toPersonTO(this.person1);
        personTO.setId(null);
        this.personManager.updatePerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdatePersonEmptyId() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO personTO = this.transfertObjectAssembler.toPersonTO(this.person1);
        personTO.setId("");
        this.personManager.updatePerson(personTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdatePersonSameLastnameFirstnameEmail() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO personTO1 = this.transfertObjectAssembler.toPersonTO(this.person1);
        PersonTO personTO2 = this.transfertObjectAssembler.toPersonTO(this.person2);
        personTO2.setFirstname(personTO1.getFirstname());
        personTO2.setLastname(personTO1.getLastname());
        personTO2.setEmail(personTO1.getEmail());
        this.personManager.updatePerson(personTO2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdatePersonSameLastnameFirstnameEmailId() throws OrganizationException {
        this.registerCreateTestData();
        PersonTO personTO1 = this.transfertObjectAssembler.toPersonTO(this.person1);
        this.personManager.updatePerson(personTO1);
        this.getHibernateSession().flush();
    }

    @Test
    public void testSearchPersonOnName() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = "lastName2";
        ArrayList<PersonSearchProperties> searchedProperties = new ArrayList<PersonSearchProperties>();
        searchedProperties.add(PersonSearchProperties.NAME);
        List pers = this.personManager.searchPersons(searchCriteria, searchedProperties, null);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)1, (int)pers.size());
        PersonManagerImplTest.assertEquals((String)this.person2.getId(), (String)((PersonTO)pers.get(0)).getId());
    }

    @Test
    public void testSearchPersonOnParentOrg() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = ORG1_NAME;
        ArrayList<PersonSearchProperties> searchedProperties = new ArrayList<PersonSearchProperties>();
        searchedProperties.add(PersonSearchProperties.PARENT_ORG);
        List pers = this.personManager.searchPersons(searchCriteria, searchedProperties, null);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)1, (int)pers.size());
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonTO)pers.get(0)).getId());
    }

    @Test
    public void testSearchPersonOnPost() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = POST1_NAME;
        ArrayList<PersonSearchProperties> searchedProperties = new ArrayList<PersonSearchProperties>();
        searchedProperties.add(PersonSearchProperties.POST);
        List pers = this.personManager.searchPersons(searchCriteria, searchedProperties, null);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)1, (int)pers.size());
        PersonManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonTO)pers.get(0)).getId());
    }

    @Test
    public void testSearchPersonOnAll() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = "org*";
        List pers = this.personManager.searchPersons(searchCriteria, null, null);
        PersonManagerImplTest.assertNotNull((Object)pers);
        PersonManagerImplTest.assertEquals((int)2, (int)pers.size());
    }
}

