/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.PostManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.organization.PostSearchProperties;
import org.ow2.dragon.api.to.organization.PostTO;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class PostManagerImplTest
extends CommonServiceConfig {
    private static final String POST1_NATURE = "naturePost1";
    private static final String POST1_DESC = "descPost1";
    private static final String POST1_NAME = "post1";
    private static final String POST2_NAME = "postBBB";
    private static final String POST3_NAME = "postAAA";
    private Post post1;
    private Post post2;
    private Post post3;
    @Resource
    private PostManager postManager;
    @Resource
    private PostDAO postDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;

    public void createTestData() {
        this.post1 = new Post();
        this.post1.setName(POST1_NAME);
        this.post1.setDescription(POST1_DESC);
        this.post1.setNature(POST1_NATURE);
        this.post2 = new Post();
        this.post2.setName(POST2_NAME);
        this.post2.setDescription("descPost2");
        this.post2.setNature("naturePost2");
        this.post3 = new Post();
        this.post3.setName(POST3_NAME);
        this.post3.setDescription("descPost3");
        this.post3.setNature("naturePost3");
    }

    public void registerCreateTestData() {
        this.createTestData();
        this.postDAO.save((Object)this.post1);
        this.postDAO.save((Object)this.post2);
        this.postDAO.save((Object)this.post3);
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePostTwice() throws OrganizationException {
        PostTO postTO = new PostTO();
        postTO.setName(POST1_NAME);
        this.postManager.createPost(postTO);
        this.postManager.createPost(postTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testCreatePostNullName() throws OrganizationException {
        PostTO postTO = new PostTO();
        postTO.setName(null);
        this.postManager.createPost(postTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testCreatePostNullValue() throws OrganizationException {
        this.postManager.createPost(null);
        this.getHibernateSession().flush();
    }

    @Test
    public void testGetAllPostsNominal() throws OrganizationException {
        this.registerCreateTestData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(false);
        requestOptionsTO.setSortCriteria(SortCriteria.POST_NAME);
        List posts = this.postManager.getAllPosts(requestOptionsTO);
        PostManagerImplTest.assertNotNull((Object)posts);
        PostManagerImplTest.assertEquals((int)3, (int)posts.size());
        PostManagerImplTest.assertEquals((String)this.post2.getId(), (String)((PostTO)posts.get(0)).getId());
        PostManagerImplTest.assertEquals((String)this.post3.getId(), (String)((PostTO)posts.get(1)).getId());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts.get(2)).getId());
    }

    @Test
    public void testGetPostNominal() throws OrganizationException {
        this.registerCreateTestData();
        PostTO post = this.postManager.getPost(this.post1.getId());
        PostManagerImplTest.assertNotNull((Object)post);
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)post.getId());
        PostManagerImplTest.assertEquals((String)this.post1.getName(), (String)post.getName());
        PostManagerImplTest.assertEquals((String)this.post1.getNature(), (String)post.getNature());
        PostManagerImplTest.assertEquals((String)this.post1.getDescription(), (String)post.getDescription());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetPostNullValue() throws OrganizationException {
        this.postManager.getPost(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testGetPostBadValue() throws OrganizationException {
        this.postManager.getPost("bad");
    }

    @Test
    public void testRemovePost() throws OrganizationException {
        this.registerCreateTestData();
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.POST_NAME);
        List posts = this.postManager.getAllPosts(requestOptionsTO);
        PostManagerImplTest.assertNotNull((Object)posts);
        PostManagerImplTest.assertEquals((int)3, (int)posts.size());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts.get(0)).getId());
        PostManagerImplTest.assertEquals((String)this.post3.getId(), (String)((PostTO)posts.get(1)).getId());
        PostManagerImplTest.assertEquals((String)this.post2.getId(), (String)((PostTO)posts.get(2)).getId());
        this.postManager.removePost(this.post3.getId());
        this.getHibernateSession().flush();
        List posts2 = this.postManager.getAllPosts(requestOptionsTO);
        PostManagerImplTest.assertNotNull((Object)posts2);
        PostManagerImplTest.assertEquals((int)2, (int)posts2.size());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)posts2.get(0)).getId());
        PostManagerImplTest.assertEquals((String)this.post2.getId(), (String)((PostTO)posts2.get(1)).getId());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testRemovePostNullValue() throws OrganizationException {
        this.postManager.removePost(null);
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testRemovePostEmptyValue() throws OrganizationException {
        this.registerCreateTestData();
        this.postManager.removePost("");
    }

    @Test
    public void testUpdatePost() throws OrganizationException {
        this.registerCreateTestData();
        PostTO postTO = this.transfertObjectAssembler.toPostTO(this.post1);
        String postNature = "Updated nature";
        postTO.setNature(postNature);
        this.postManager.updatePost(postTO);
        this.getHibernateSession().flush();
        Post updatedPost = (Post)this.postDAO.get((Serializable)((Object)this.post1.getId()));
        PostManagerImplTest.assertEquals((String)postNature, (String)updatedPost.getNature());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdatePostNullValue() throws OrganizationException {
        this.registerCreateTestData();
        this.postManager.updatePost(null);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testUpdatePostNullId() throws OrganizationException {
        this.registerCreateTestData();
        PostTO postTO = this.transfertObjectAssembler.toPostTO(this.post1);
        postTO.setId(null);
        this.postManager.updatePost(postTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdatePostEmptyId() throws OrganizationException {
        this.registerCreateTestData();
        PostTO postTO = this.transfertObjectAssembler.toPostTO(this.post1);
        postTO.setId("");
        this.postManager.updatePost(postTO);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=OrganizationException.class)
    public void testUpdatePostSameName() throws OrganizationException {
        this.registerCreateTestData();
        PostTO postTO1 = this.transfertObjectAssembler.toPostTO(this.post1);
        PostTO postTO2 = this.transfertObjectAssembler.toPostTO(this.post2);
        postTO2.setName(postTO1.getName());
        this.postManager.updatePost(postTO2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testUpdatePostNameId() throws OrganizationException {
        this.registerCreateTestData();
        PostTO postTO = this.transfertObjectAssembler.toPostTO(this.post1);
        this.postManager.updatePost(postTO);
        this.getHibernateSession().flush();
    }

    @Test
    public void testSearchPostOnName() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = POST1_NAME;
        ArrayList<PostSearchProperties> searchedProperties = new ArrayList<PostSearchProperties>();
        searchedProperties.add(PostSearchProperties.NAME);
        List postTOs = this.postManager.searchPost(searchCriteria, searchedProperties, null);
        PostManagerImplTest.assertNotNull((Object)postTOs);
        PostManagerImplTest.assertEquals((int)1, (int)postTOs.size());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)postTOs.get(0)).getId());
    }

    @Test
    public void testSearchPostOnNature() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = POST1_NATURE;
        ArrayList<PostSearchProperties> searchedProperties = new ArrayList<PostSearchProperties>();
        searchedProperties.add(PostSearchProperties.NATURE);
        List postTOs = this.postManager.searchPost(searchCriteria, searchedProperties, null);
        PostManagerImplTest.assertNotNull((Object)postTOs);
        PostManagerImplTest.assertEquals((int)1, (int)postTOs.size());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)postTOs.get(0)).getId());
    }

    @Test
    public void testSearchPostOnDesc() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = POST1_DESC;
        ArrayList<PostSearchProperties> searchedProperties = new ArrayList<PostSearchProperties>();
        searchedProperties.add(PostSearchProperties.DESCRIPTION);
        List postTOs = this.postManager.searchPost(searchCriteria, searchedProperties, null);
        PostManagerImplTest.assertNotNull((Object)postTOs);
        PostManagerImplTest.assertEquals((int)1, (int)postTOs.size());
        PostManagerImplTest.assertEquals((String)this.post1.getId(), (String)((PostTO)postTOs.get(0)).getId());
    }

    @Test
    public void testSearchPostOnAll() throws OrganizationException {
        this.registerCreateTestData();
        String searchCriteria = "post*";
        List postTOs = this.postManager.searchPost(searchCriteria, null, null);
        PostManagerImplTest.assertNotNull((Object)postTOs);
        PostManagerImplTest.assertEquals((int)3, (int)postTOs.size());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testSearchPostNull() throws OrganizationException {
        this.postManager.searchPost(null, null, null);
    }
}

