/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.organization.OrganizationException;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.common.LinkDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class RoleOfPartyManagerImplCase
extends CommonServiceConfig {
    private static Logger logger = Logger.getLogger(RoleOfPartyManagerImplCase.class);
    private static TechnicalService service1;
    private static TechnicalService service2;
    private static TechnicalService service3;
    private static Person person1;
    private static Person person2;
    private static Person person3;
    private static Post post1;
    private static Post post2;
    private static Post post3;
    @Resource
    private PostDAO postDAO;
    @Resource
    private LinkDAO linkDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    @Resource
    private ServiceInterfaceDAO serviceInterfaceDAO;
    @Resource
    private PersonDAO personDAO;
    @Resource
    private RoleOfPartyManager roleOfPartyManager;
    private static String roleId;

    @BeforeClass
    public static void createTestObject() {
        logger.debug((Object)"##### create test data");
        person1 = new Person();
        person1.setFirstName("foo1");
        person1.setMiddleName("bar1");
        person1.setLastName("foobar1");
        person1.setLocation("A1");
        person2 = new Person();
        person2.setFirstName("foo2");
        person2.setMiddleName("bar1");
        person2.setLastName("foobar2");
        person2.setLocation("A2");
        person3 = new Person();
        person3.setFirstName("foo3");
        person3.setMiddleName("bar3");
        person3.setLastName("foobar3");
        person3.setLocation("A3");
        post1 = new Post();
        post1.setName("post1");
        post1.setNature("nature1");
        post1.setDescription("desc1");
        post2 = new Post();
        post2.setName("post2");
        post2.setNature("nature2");
        post2.setDescription("desc2");
        post3 = new Post();
        post3.setName("post3");
        post3.setNature("nature3");
        post3.setDescription("desc3");
        service1 = new TechnicalService();
        RoleOfPartyManagerImplCase.setName(service1, "serv1");
        service2 = new TechnicalService();
        RoleOfPartyManagerImplCase.setName(service2, "serv2");
        service3 = new TechnicalService();
        RoleOfPartyManagerImplCase.setName(service3, "serv3");
        person1.setPost(post1);
        person2.setPost(post2);
        person3.setPost(post1);
    }

    private static void setName(TechnicalService technicalServiceBO, String name) {
        Name nameObj = new Name();
        nameObj.setLangCode("EN-us");
        nameObj.setName(name);
        technicalServiceBO.addName(nameObj);
    }

    @Test
    @Rollback(value=false)
    public void createTestData() {
        this.postDAO.save((Object)post1);
        this.postDAO.save((Object)post2);
        this.postDAO.save((Object)post3);
        this.personDAO.save((Object)person1);
        this.personDAO.save((Object)person2);
        this.personDAO.save((Object)person3);
        this.technicalServiceDAO.save((Object)service1);
        this.technicalServiceDAO.save((Object)service2);
        this.technicalServiceDAO.save((Object)service3);
    }

    @Test
    @Rollback(value=false)
    public void testCreateTechServiceRole() {
        logger.debug((Object)"##### call testCreateTechServiceRole() method");
        try {
            roleId = this.roleOfPartyManager.createTechServiceRole(person1.getId(), service1.getId(), "Owner");
            TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)service1.getId()));
            Person person = (Person)this.personDAO.get((Serializable)((Object)person1.getId()));
            Link roleOfParty = (Link)this.linkDAO.get((Serializable)((Object)roleId));
            RoleOfPartyManagerImplCase.assertEquals((String)"Owner", (String)roleOfParty.getType());
            RoleOfPartyManagerImplCase.assertEquals((Object)person1, (Object)roleOfParty.getFrom());
            RoleOfPartyManagerImplCase.assertEquals((Object)service1, (Object)roleOfParty.getTo());
            RoleOfPartyManagerImplCase.assertEquals((int)1, (int)service.getToLinks().size());
            RoleOfPartyManagerImplCase.assertEquals((int)1, (int)person.getFromLinks().size());
        }
        catch (OrganizationException e) {
            e.printStackTrace();
            RoleOfPartyManagerImplCase.fail();
        }
    }

    @Test
    public void testCreateTechServiceRole2() {
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)service1.getId()));
        Person person = (Person)this.personDAO.get((Serializable)((Object)person1.getId()));
        RoleOfPartyManagerImplCase.assertEquals((int)1, (int)service.getToLinks().size());
        RoleOfPartyManagerImplCase.assertEquals((int)1, (int)person.getFromLinks().size());
    }
}

