/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.organization;

import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.deployment.EndpointManager;
import org.ow2.dragon.api.service.deployment.TechServiceManager;
import org.ow2.dragon.api.service.organization.RoleOfPartyManager;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.organization.OrgToEndpointTO;
import org.ow2.dragon.api.to.organization.OrgToTechServiceTO;
import org.ow2.dragon.api.to.organization.PersonToEndpointTO;
import org.ow2.dragon.api.to.organization.PersonToTechServiceTO;
import org.ow2.dragon.persistence.bo.common.Category;
import org.ow2.dragon.persistence.bo.common.CategoryValue;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.AddressLine;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Person;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.ow2.dragon.persistence.dao.organization.PersonDAO;
import org.ow2.dragon.persistence.dao.organization.PostDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.deployment.TechServiceManagerImplTest;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.w3c.dom.Document;

@RunWith(value=SpringJUnit4ClassRunner.class)
public class RoleOfPartyManagerImplTest
extends CommonServiceConfig {
    @Resource
    private SimpleFileDAO simpleFileDAO;
    @Resource
    private PostDAO postDAO;
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private TransportDAO transportDAO;
    @Resource
    private OrganizationUnitDAO organizationUnitDAO;
    @Resource
    private PersonDAO personDAO;
    private static final String ROLE_TYPE_USER = "User";
    private static final String ROLE_TYPE_ADMIN = "Admin";
    private static final String ROLE_TYPE_OWNER = "Owner";
    private static final String ROLE_TYPE_MANAGER = "Manager";
    @Resource
    private RoleOfPartyManager roleOfPartyManager;
    private static final String CAT_VALUE1_DESC = "valueDesc1";
    private static final String CAT_VALUE1_VALUE = "value1";
    private static final String CAT_VALUE2_DESC = "valueDesc2";
    private static final String CAT_VALUE2_VALUE = "value2";
    private static final String PERS_EMAIL1 = "person1@email.com";
    private static final String PERS_LAST_NAME1 = "lastName1";
    private static final String PERS_FIRST_NAME1 = "firstName1";
    private Person person1;
    private Post post1;
    private OrganizationUnit organizationUnit1;
    private Category category1;
    private CategoryValue categoryValue1;
    private Category category2;
    private CategoryValue categoryValue2;
    private KeyedReference categoryRef1;
    private KeyedReference categoryRef2;
    private TModel categoryTModel1;
    private String servId;
    private String servId2;
    private static Logger logger = Logger.getLogger(TechServiceManagerImplTest.class);
    @Resource
    private TechServiceManager techServiceManager;
    @Resource
    private EndpointManager endpointManager;
    @Resource
    private WSDLManager wsdlManager;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();
    private int tModelsInDB;
    private int simpleFileInDB;

    public void createTestData() {
        this.category1 = new Category();
        this.category1.setName(new Name("en", "cat1"));
        this.categoryValue1 = new CategoryValue();
        this.categoryValue1.setValue(CAT_VALUE1_VALUE);
        this.categoryValue1.setDescription(CAT_VALUE1_DESC);
        this.category1.addValue(this.categoryValue1);
        this.category2 = new Category();
        this.category2.setName(new Name("en", "cat2"));
        this.categoryValue2 = new CategoryValue();
        this.categoryValue2.setValue(CAT_VALUE2_VALUE);
        this.categoryValue2.setDescription(CAT_VALUE2_DESC);
        this.category2.addValue(this.categoryValue2);
        this.categoryTModel1 = new TModel();
        this.categoryTModel1.setName(new Name("en", "categoryTModel1"));
        this.categoryRef1 = new KeyedReference();
        this.categoryRef1.setKeyName(this.categoryValue1.getDescription());
        this.categoryRef1.setKeyValue(this.categoryValue1.getValue());
        this.categoryRef1.setTmodel(this.categoryTModel1);
        this.categoryRef2 = new KeyedReference();
        this.categoryRef2.setKeyName(this.categoryValue2.getDescription());
        this.categoryRef2.setKeyValue(this.categoryValue2.getValue());
        this.categoryRef2.setTmodel(this.categoryTModel1);
        this.organizationUnit1 = new OrganizationUnit();
        Name nameOrg1 = new Name();
        nameOrg1.setName("org1");
        nameOrg1.setLangCode("en");
        this.organizationUnit1.addName(nameOrg1);
        Address addressOrg1 = new Address();
        AddressLine addressLineOrg11 = new AddressLine();
        addressLineOrg11.setAddressLine("Org City 1");
        addressLineOrg11.setKeyName("city");
        addressOrg1.addAddressLine(addressLineOrg11);
        AddressLine addressLineOrg12 = new AddressLine();
        addressLineOrg12.setAddressLine("country Org 1");
        addressLineOrg12.setKeyName("country");
        addressOrg1.addAddressLine(addressLineOrg12);
        this.organizationUnit1.addAddress(addressOrg1);
        Email email = new Email();
        email.setEmail("email@email.com");
        this.organizationUnit1.addEmail(email);
        this.post1 = new Post();
        this.post1.setName("post1");
        this.post1.setDescription("descPost1");
        this.post1.setNature("naturePost1");
        this.person1 = new Person();
        this.person1.setFirstName(PERS_FIRST_NAME1);
        this.person1.setLastName(PERS_LAST_NAME1);
        Email emailPers1 = new Email();
        emailPers1.setEmail(PERS_EMAIL1);
        this.person1.addEmail(emailPers1);
        this.person1.setParentOrganization(this.organizationUnit1);
        this.person1.setPost(this.post1);
        PhoneNumber phoneNumber1 = new PhoneNumber();
        phoneNumber1.setPhoneNumber("0505050505");
        this.person1.addPhoneNumber(phoneNumber1);
    }

    public void registerAddCategoryData() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.postDAO.save((Object)this.post1);
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.personDAO.save((Object)this.person1);
        this.getHibernateSession().flush();
    }

    public void registerServices() throws Exception {
        this.createTestData();
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:photoservice.wsdl"));
        Document document2 = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.servId2 = this.wsdlManager.importServiceDefFile(document2)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    public void registerService() throws Exception {
        this.createTestData();
        this.tModelsInDB = this.tModelDAO.count((IMutableSearch)new Search());
        this.simpleFileInDB = this.simpleFileDAO.count((IMutableSearch)new Search());
        Document document = XMLUtil.loadDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.servId = this.wsdlManager.importServiceDefFile(document)[0];
        this.organizationUnitDAO.save((Object)this.organizationUnit1);
        this.getHibernateSession().flush();
    }

    @Before
    public void before() {
        TModel tModel1;
        int i = 0;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "tmodel" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "protocol" + i));
            ++i;
            this.protocolDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "transport" + i));
            ++i;
            this.transportDAO.save((Object)tModel1);
        }
        this.getHibernateSession().flush();
    }

    @Override
    @After
    public void after() {
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
    }

    @Test
    public void testCRUDRole() throws Exception {
        this.registerAddCategoryData();
        List eps = this.endpointManager.getAllEndpoints(null);
        String anEpId = ((EndpointTO)eps.get(0)).getId();
        String epToOrgRoleId = this.roleOfPartyManager.createEndpointRole(this.organizationUnit1.getId(), anEpId, ROLE_TYPE_USER);
        String epToPersonRoleId = this.roleOfPartyManager.createEndpointRole(this.person1.getId(), anEpId, ROLE_TYPE_ADMIN);
        String servToOrgRoleId = this.roleOfPartyManager.createTechServiceRole(this.organizationUnit1.getId(), this.servId, ROLE_TYPE_OWNER);
        String servToPersonRoleId = this.roleOfPartyManager.createTechServiceRole(this.person1.getId(), this.servId, ROLE_TYPE_MANAGER);
        List orgToEndpointTOs = this.roleOfPartyManager.getOrgRolesByEndpoint(anEpId, null);
        RoleOfPartyManagerImplTest.assertEquals((int)1, (int)orgToEndpointTOs.size());
        RoleOfPartyManagerImplTest.assertEquals((String)anEpId, (String)((OrgToEndpointTO)orgToEndpointTOs.get(0)).getEndpointTO().getId());
        RoleOfPartyManagerImplTest.assertEquals((String)this.organizationUnit1.getId(), (String)((OrgToEndpointTO)orgToEndpointTOs.get(0)).getOrganizationUnitTO().getId());
        RoleOfPartyManagerImplTest.assertEquals((String)ROLE_TYPE_USER, (String)((OrgToEndpointTO)orgToEndpointTOs.get(0)).getType());
        List personToEndpointTOs = this.roleOfPartyManager.getPersonRolesByEndpoint(anEpId, null);
        RoleOfPartyManagerImplTest.assertEquals((int)1, (int)personToEndpointTOs.size());
        RoleOfPartyManagerImplTest.assertEquals((String)anEpId, (String)((PersonToEndpointTO)personToEndpointTOs.get(0)).getEndpointTO().getId());
        RoleOfPartyManagerImplTest.assertEquals((String)this.person1.getId(), (String)((PersonToEndpointTO)personToEndpointTOs.get(0)).getPersonTO().getId());
        RoleOfPartyManagerImplTest.assertEquals((String)ROLE_TYPE_ADMIN, (String)((PersonToEndpointTO)personToEndpointTOs.get(0)).getType());
        List orgToServTOs = this.roleOfPartyManager.getOrgRolesByTechService(this.servId, null);
        RoleOfPartyManagerImplTest.assertEquals((int)2, (int)orgToServTOs.size());
        ArrayList<String> types1 = new ArrayList<String>();
        types1.add(((OrgToTechServiceTO)orgToServTOs.get(0)).getType());
        types1.add(((OrgToTechServiceTO)orgToServTOs.get(1)).getType());
        RoleOfPartyManagerImplTest.assertTrue((boolean)types1.contains(ROLE_TYPE_USER));
        RoleOfPartyManagerImplTest.assertTrue((boolean)types1.contains(ROLE_TYPE_OWNER));
        List personToTechServiceTOs = this.roleOfPartyManager.getPersonRolesByTechService(this.servId, null);
        RoleOfPartyManagerImplTest.assertEquals((int)2, (int)personToTechServiceTOs.size());
        ArrayList<String> types2 = new ArrayList<String>();
        types2.add(((PersonToTechServiceTO)personToTechServiceTOs.get(0)).getType());
        types2.add(((PersonToTechServiceTO)personToTechServiceTOs.get(1)).getType());
        RoleOfPartyManagerImplTest.assertTrue((boolean)types2.contains(ROLE_TYPE_MANAGER));
        RoleOfPartyManagerImplTest.assertTrue((boolean)types2.contains(ROLE_TYPE_ADMIN));
        this.roleOfPartyManager.removeRole(epToOrgRoleId);
        List orgToEndpointTOs2 = this.roleOfPartyManager.getOrgRolesByEndpoint(anEpId, null);
        RoleOfPartyManagerImplTest.assertEquals((int)0, (int)orgToEndpointTOs2.size());
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetCategoriesNullValue() throws Exception {
        throw new NullPointerException();
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
    }
}

