/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.technology;

import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.technology.TechnologyException;
import org.ow2.dragon.api.service.technology.TechnologyManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.api.to.SortCriteria;
import org.ow2.dragon.api.to.deployment.EndpointTO;
import org.ow2.dragon.api.to.technology.EnvironmentFederationTO;
import org.ow2.dragon.api.to.technology.ExecEnvManagerSearchProperties;
import org.ow2.dragon.api.to.technology.ExecEnvSearchProperties;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentManagerTO;
import org.ow2.dragon.api.to.technology.ExecutionEnvironmentTO;
import org.ow2.dragon.api.to.technology.FederationSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorSearchProperties;
import org.ow2.dragon.api.to.technology.ProcessorTO;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironmentManager;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.persistence.dao.technology.ExecutionEnvironmentDAO;
import org.ow2.dragon.persistence.dao.technology.ExecutionEnvironmentManagerDAO;
import org.ow2.dragon.persistence.dao.technology.ProcessorDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(locations={"classpath:applicationContext-test-hibernate.xml", "classpath:applicationContext-test-jdbc.xml", "classpath:applicationContext-transaction.xml", "classpath:applicationContext-annotation.xml", "classpath:applicationContext-test-cxf.xml", "classpath:applicationContext-service.xml", "classpath:applicationContext-test-repository.xml", "classpath:applicationContext-aop.xml", "classpath:applicationContext-mock.xml"})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class TechnologyManagerImplTest
extends CommonServiceConfig {
    private static Logger logger = Logger.getLogger(TechnologyManagerImplTest.class);
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private TransportDAO transportDAO;
    @Resource
    private TechnologyManager technologyManager;
    @Resource
    private ExecutionEnvironmentManagerDAO executionEnvironmentManagerDAO;
    @Resource
    private ExecutionEnvironmentDAO executionEnvironmentDAO;
    @Resource
    private ProcessorDAO processorDAO;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();

    @Before
    public void synchronizeServer() {
        TModel tModel1;
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int i = 0;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "tmodel" + i));
            ++i;
            this.tModelDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "protocol" + i));
            ++i;
            this.protocolDAO.save((Object)tModel1);
        }
        i = 0;
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            tModel1.setName(new Name("en", "transport" + i));
            ++i;
            this.transportDAO.save((Object)tModel1);
        }
        this.getHibernateSession().flush();
    }

    @Test
    public void testAddRuntimeManager() {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        ExecutionEnvironmentManager environmentManager = (ExecutionEnvironmentManager)this.executionEnvironmentManagerDAO.get((Serializable)((Object)id));
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)environmentManager.getName());
    }

    @Test
    public void testAddTwoRuntimeManager() {
        String id1 = null;
        String id2 = null;
        try {
            id1 = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
            id2 = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService2");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        ExecutionEnvironmentManager environmentManager1 = (ExecutionEnvironmentManager)this.executionEnvironmentManagerDAO.get((Serializable)((Object)id1));
        ExecutionEnvironmentManager environmentManager2 = (ExecutionEnvironmentManager)this.executionEnvironmentManagerDAO.get((Serializable)((Object)id2));
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)environmentManager1.getName());
        TechnologyManagerImplTest.assertEquals((String)"manager2", (String)environmentManager2.getName());
    }

    @Test
    public void testSynchronizeManagedExecEnv() {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setCaseSensitive(true);
        List execEnvs = this.executionEnvironmentDAO.searchEquals(new String[]{"petalsNode1"}, new String[]{"name"}, requestOptions);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvs.size());
        List execEnvs2 = this.executionEnvironmentDAO.searchEquals(new String[]{"petalsNode2"}, new String[]{"name"}, requestOptions);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvs2.size());
        List execEnvs3 = this.executionEnvironmentDAO.searchEquals(new String[]{"asNode1"}, new String[]{"name"}, requestOptions);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvs3.size());
        List processors = this.processorDAO.searchEquals(new String[]{"IBMServer1"}, new String[]{"name"}, requestOptions);
        TechnologyManagerImplTest.assertEquals((int)1, (int)processors.size());
    }

    @Test
    public void testGetAllEnvFed() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List feds = this.technologyManager.getAllEnvironmentFederations(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)feds.size());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)((EnvironmentFederationTO)feds.get(0)).getName());
        this.technologyManager.removeEnvironmentFederation(((EnvironmentFederationTO)feds.get(0)).getEnvFedId());
        List feds2 = this.technologyManager.getAllEnvironmentFederations(null);
        TechnologyManagerImplTest.assertEquals((int)0, (int)feds2.size());
    }

    @Test
    public void testGetAllExecEnvManagers() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List execEnvMans = this.technologyManager.getAllExecutionEnvironmentManagers(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvMans.size());
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)((ExecutionEnvironmentManagerTO)execEnvMans.get(0)).getName());
        this.technologyManager.removeRuntimeManager(((ExecutionEnvironmentManagerTO)execEnvMans.get(0)).getExecEnvManagerId());
        List execEnvMans2 = this.technologyManager.getAllExecutionEnvironmentManagers(null);
        TechnologyManagerImplTest.assertEquals((int)0, (int)execEnvMans2.size());
    }

    @Test
    public void testGetAllExecEnvs() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        List execEnvs = this.technologyManager.getAllExecutionEnvironments(requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)3, (int)execEnvs.size());
        TechnologyManagerImplTest.assertEquals((String)"asNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(0)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(1)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode2", (String)((ExecutionEnvironmentTO)execEnvs.get(2)).getName());
        this.technologyManager.removeExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(0)).getNodeId());
        this.technologyManager.removeExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(1)).getNodeId());
        this.technologyManager.removeExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(2)).getNodeId());
        List execEnvs2 = this.technologyManager.getAllExecutionEnvironments(requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)0, (int)execEnvs2.size());
    }

    @Test
    public void testGetAllProcs() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List procs = this.technologyManager.getAllProcessors(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
        this.technologyManager.removeProcessor(((ProcessorTO)procs.get(0)).getNodeId());
        List procs2 = this.technologyManager.getAllProcessors(null);
        TechnologyManagerImplTest.assertEquals((int)0, (int)procs2.size());
    }

    @Test
    public void testGetEnvFed() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List feds = this.technologyManager.getAllEnvironmentFederations(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)feds.size());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)((EnvironmentFederationTO)feds.get(0)).getName());
        EnvironmentFederationTO federationTO = this.technologyManager.getEnvironmentFederation(((EnvironmentFederationTO)feds.get(0)).getEnvFedId());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)federationTO.getName());
    }

    @Test
    public void testGetExecEnvManager() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List execEnvMans = this.technologyManager.getAllExecutionEnvironmentManagers(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvMans.size());
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)((ExecutionEnvironmentManagerTO)execEnvMans.get(0)).getName());
        ExecutionEnvironmentManagerTO managerTO = this.technologyManager.getRuntimeManager(((ExecutionEnvironmentManagerTO)execEnvMans.get(0)).getExecEnvManagerId());
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)managerTO.getName());
    }

    @Test
    public void testGetExecEnv() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        List execEnvs = this.technologyManager.getAllExecutionEnvironments(requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)3, (int)execEnvs.size());
        TechnologyManagerImplTest.assertEquals((String)"asNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(0)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(1)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode2", (String)((ExecutionEnvironmentTO)execEnvs.get(2)).getName());
        ExecutionEnvironmentTO environmentTO1 = this.technologyManager.getExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(0)).getNodeId());
        TechnologyManagerImplTest.assertEquals((String)"asNode1", (String)environmentTO1.getName());
        ExecutionEnvironmentTO environmentTO2 = this.technologyManager.getExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(1)).getNodeId());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)environmentTO2.getName());
        ExecutionEnvironmentTO environmentTO3 = this.technologyManager.getExecutionEnvironment(((ExecutionEnvironmentTO)execEnvs.get(2)).getNodeId());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode2", (String)environmentTO3.getName());
    }

    @Test
    public void testGetProc() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List procs = this.technologyManager.getAllProcessors(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
        ProcessorTO processorTO = this.technologyManager.getProcessor(((ProcessorTO)procs.get(0)).getNodeId());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)processorTO.getName());
    }

    @Test
    public void testGetExecEnvsHostedOnProc() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List procs = this.technologyManager.getAllProcessors(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        List execEnvs = this.technologyManager.getExecEnvsHostedOnProcessor(((ProcessorTO)procs.get(0)).getNodeId(), requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(0)).getName());
    }

    @Test
    public void testGetExecEnvsInEnvFed() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List feds = this.technologyManager.getAllEnvironmentFederations(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)feds.size());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)((EnvironmentFederationTO)feds.get(0)).getName());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        List execEnvs = this.technologyManager.getExecEnvsInFederation(((EnvironmentFederationTO)feds.get(0)).getEnvFedId(), requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)1, (int)execEnvs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(0)).getName());
    }

    @Test
    public void testGetEpsHostedOnExecEnv() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.EXEC_ENV_NAME);
        List execEnvs = this.technologyManager.getAllExecutionEnvironments(requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)3, (int)execEnvs.size());
        TechnologyManagerImplTest.assertEquals((String)"asNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(0)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)execEnvs.get(1)).getName());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode2", (String)((ExecutionEnvironmentTO)execEnvs.get(2)).getName());
        requestOptionsTO.setSortCriteria(SortCriteria.ENDPOINT_NAME);
        List eps = this.technologyManager.getEpsHostedOnExecEnv(((ExecutionEnvironmentTO)execEnvs.get(1)).getNodeId(), requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)3, (int)eps.size());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherHttpGet", (String)((EndpointTO)eps.get(0)).getName());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherHttpPost", (String)((EndpointTO)eps.get(1)).getName());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherSoap", (String)((EndpointTO)eps.get(2)).getName());
    }

    @Test
    public void testGetEpsHostedOnProc() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        List procs = this.technologyManager.getAllProcessors(null);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
        RequestOptionsTO requestOptionsTO = new RequestOptionsTO();
        requestOptionsTO.setSortAscendingly(true);
        requestOptionsTO.setSortCriteria(SortCriteria.ENDPOINT_NAME);
        List eps = this.technologyManager.getEpsHostedOnProcessor(((ProcessorTO)procs.get(0)).getNodeId(), requestOptionsTO);
        TechnologyManagerImplTest.assertEquals((int)3, (int)eps.size());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherHttpGet", (String)((EndpointTO)eps.get(0)).getName());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherHttpPost", (String)((EndpointTO)eps.get(1)).getName());
        TechnologyManagerImplTest.assertEquals((String)"GlobalWeatherSoap", (String)((EndpointTO)eps.get(2)).getName());
    }

    @Test
    public void testSearchEnvFedOnName() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "EnvFed1";
        ArrayList<FederationSearchProperties> searchedProperties = new ArrayList<FederationSearchProperties>();
        searchedProperties.add(FederationSearchProperties.NAME);
        List feds = this.technologyManager.searchEnvironmentFederations(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)feds);
        TechnologyManagerImplTest.assertEquals((int)1, (int)feds.size());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)((EnvironmentFederationTO)feds.get(0)).getName());
    }

    @Test
    public void testSearchEnvFedOnPattern() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "DISTRIBUTED";
        ArrayList<FederationSearchProperties> searchedProperties = new ArrayList<FederationSearchProperties>();
        searchedProperties.add(FederationSearchProperties.PATTERN);
        List feds = this.technologyManager.searchEnvironmentFederations(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)feds);
        TechnologyManagerImplTest.assertEquals((int)1, (int)feds.size());
        TechnologyManagerImplTest.assertEquals((String)"EnvFed1", (String)((EnvironmentFederationTO)feds.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvManOnName() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "manager1";
        ArrayList<ExecEnvManagerSearchProperties> searchedProperties = new ArrayList<ExecEnvManagerSearchProperties>();
        searchedProperties.add(ExecEnvManagerSearchProperties.NAME);
        List managers = this.technologyManager.searchExecutionEnvironmentManagers(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)managers);
        TechnologyManagerImplTest.assertEquals((int)1, (int)managers.size());
        TechnologyManagerImplTest.assertEquals((String)"manager1", (String)((ExecutionEnvironmentManagerTO)managers.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvOnName() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "petalsNode1";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.NAME);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)envs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)envs.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvOnAddress() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "192.168.2.1";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.ADDRESS);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)envs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)envs.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvOnEnvType() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "ESB";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.ENV_TYPE);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)2, (int)envs.size());
    }

    @Test
    public void testSearchExecEnvOnFed() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "EnvFed1";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.FEDERATION);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)envs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)envs.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvOnHost() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "IBMServer1";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.HOST);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)envs.size());
        TechnologyManagerImplTest.assertEquals((String)"petalsNode1", (String)((ExecutionEnvironmentTO)envs.get(0)).getName());
    }

    @Test
    public void testSearchExecEnvOnRoleInFed() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "master";
        ArrayList<ExecEnvSearchProperties> searchedProperties = new ArrayList<ExecEnvSearchProperties>();
        searchedProperties.add(ExecEnvSearchProperties.ROLE_IN_FEDERATION);
        List envs = this.technologyManager.searchExecutionEnvironments(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)envs);
        TechnologyManagerImplTest.assertEquals((int)2, (int)envs.size());
    }

    @Test
    public void testSearchProcOnName() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "IBMServer1";
        ArrayList<ProcessorSearchProperties> searchedProperties = new ArrayList<ProcessorSearchProperties>();
        searchedProperties.add(ProcessorSearchProperties.NAME);
        List procs = this.technologyManager.searchProcessors(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)procs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
    }

    @Test
    public void testSearchProcOnAddress() throws TechnologyException {
        String id = null;
        try {
            id = this.technologyManager.addRuntimeManager("http://localhost:9221/PetalsMockService1");
        }
        catch (TechnologyException e) {
            logger.error((Object)"Failed to add runtime manager", (Throwable)e);
            TechnologyManagerImplTest.fail();
        }
        try {
            this.technologyManager.synchronizeManagedExecEnv(id);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to synchronize managed exec envs", e);
            TechnologyManagerImplTest.fail();
        }
        this.getHibernateSession().flush();
        this.getFullTextSession().flushToIndexes();
        String searchCriteria = "192.168.2.1";
        ArrayList<ProcessorSearchProperties> searchedProperties = new ArrayList<ProcessorSearchProperties>();
        searchedProperties.add(ProcessorSearchProperties.ADDRESS);
        List procs = this.technologyManager.searchProcessors(searchCriteria, searchedProperties, null);
        TechnologyManagerImplTest.assertNotNull((Object)procs);
        TechnologyManagerImplTest.assertEquals((int)1, (int)procs.size());
        TechnologyManagerImplTest.assertEquals((String)"IBMServer1", (String)((ProcessorTO)procs.get(0)).getName());
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
    }
}

