/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.util;

import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.ow2.dragon.service.util.RepositoryServlet;
import org.ow2.dragon.service.util.ServerConfig;
import org.ow2.easywsdl.wsdl.api.WSDLException;

public class JettyServer {
    private Logger log = Logger.getLogger(JettyServer.class);
    public static final int HEADER_BUFFER_SIZE = 16384;
    private static JettyServer instance = null;
    private RepositoryServlet repositoryServlet;
    private ServerConfig config;
    private Server server;
    private BoundedThreadPool threadPool;

    private JettyServer(ServerConfig config) {
        this.config = config;
        this.threadPool = new BoundedThreadPool();
        this.threadPool.setName("SoapJettyThreadPool");
        this.threadPool.setMaxThreads(this.config.getJettyThreadMaxPoolSize());
        this.threadPool.setMinThreads(this.config.getJettyThreadMinPoolSize());
        SelectChannelConnector nioConnector = new SelectChannelConnector();
        nioConnector.setPort(this.config.getPort());
        if (this.config.isRestrict()) {
            nioConnector.setHost(this.config.getHost());
        }
        nioConnector.setHeaderBufferSize(16384);
        nioConnector.setStatsOn(false);
        nioConnector.setAcceptors(this.config.getJettyAcceptors());
        this.server = new Server();
        this.server.setConnectors(new Connector[]{nioConnector});
        this.server.setThreadPool((ThreadPool)this.threadPool);
    }

    public void createDefaultServlet() throws WSDLException {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        Context repositoryContext = new Context((HandlerContainer)contexts, "/Repository", 1);
        this.repositoryServlet = new RepositoryServlet();
        ServletHolder repositoryServletHolder = new ServletHolder((Servlet)this.repositoryServlet);
        repositoryServletHolder.setName("RepositoryServlet");
        repositoryServletHolder.setInitOrder(1);
        repositoryContext.addServlet(repositoryServletHolder, "/");
        this.log.info((Object)("Repository servlet deployed at: http://" + this.config.getHost() + ":" + this.config.getPort() + "/Repository"));
        this.log.info((Object)("Welcome servlet deployed at: http://" + this.config.getHost() + ":" + this.config.getPort() + "/Repository"));
    }

    public static JettyServer getInstance() throws Exception {
        if (instance == null) {
            instance = new JettyServer(new ServerConfig());
            instance.createDefaultServlet();
            instance.start();
        }
        if (!instance.getServer().isStarted()) {
            instance.createDefaultServlet();
            instance.start();
        }
        return instance;
    }

    public RepositoryServlet getRepositoryServlet() {
        return this.repositoryServlet;
    }

    public void start() throws Exception {
        this.log.info((Object)"Starting Jetty server...");
        this.log.info((Object)("Host : " + (!this.config.isRestrict() ? "*" : this.config.getHost() + " (restricted)") + " / Port : " + this.config.getPort() + " / Jetty Max poolsize : " + this.config.getJettyThreadMaxPoolSize() + " / Jetty Min poolsize : " + this.config.getJettyThreadMinPoolSize() + " / Jetty Acceptors size : " + this.config.getJettyAcceptors()));
        this.server.start();
    }

    public void stop() throws Exception {
        this.log.info((Object)"Stop and kill Jetty server...");
        for (Handler h : this.server.getHandlers()) {
            this.server.removeHandler(h);
        }
        for (Handler h : this.server.getChildHandlers()) {
            this.server.removeHandler(h);
        }
        this.server.stop();
    }

    public Server getServer() {
        return this.server;
    }

    public ServerConfig getConfig() {
        return this.config;
    }
}

