/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class NetworkUtil {
    public static Set<NetworkInterface> getAllLocalInterfaces() {
        HashSet<NetworkInterface> result = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                InetAddress address;
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> set = ni.getInetAddresses();
                if (!set.hasMoreElements() || (address = set.nextElement()).isLoopbackAddress()) continue;
                result.add(ni);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    public static Set<NetworkInterface> getAllInterfaces() {
        HashSet<NetworkInterface> result = new HashSet<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    public static Set<Inet4Address> getAllLocalIPv4InetAddresses() {
        HashSet<Inet4Address> result = new HashSet<Inet4Address>();
        Set<NetworkInterface> iset = NetworkUtil.getAllLocalInterfaces();
        for (NetworkInterface networkInterface : iset) {
            Enumeration<InetAddress> e = networkInterface.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress elem = e.nextElement();
                if (!(elem instanceof Inet4Address)) continue;
                result.add((Inet4Address)elem);
            }
        }
        return result;
    }

    public static Set<Inet4Address> getAllIPv4InetAddresses() {
        HashSet<Inet4Address> result = new HashSet<Inet4Address>();
        Set<NetworkInterface> iset = NetworkUtil.getAllInterfaces();
        for (NetworkInterface networkInterface : iset) {
            Enumeration<InetAddress> e = networkInterface.getInetAddresses();
            while (e.hasMoreElements()) {
                InetAddress elem = e.nextElement();
                if (!(elem instanceof Inet4Address)) continue;
                result.add((Inet4Address)elem);
            }
        }
        return result;
    }

    public static boolean isLocalAddress(InetAddress address) {
        boolean result = false;
        if (address != null) {
            try {
                Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
                while (itfs.hasMoreElements()) {
                    NetworkInterface itf = itfs.nextElement();
                    Enumeration<InetAddress> iaenum = itf.getInetAddresses();
                    while (iaenum.hasMoreElements() && !result) {
                        InetAddress ia = iaenum.nextElement();
                        result = ia.equals(address);
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isLoopbackAddress(InetAddress addr) {
        return addr.isLoopbackAddress();
    }
}

