/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ow2.dragon.api.service.wsdl.WSDLManager;
import org.ow2.dragon.api.service.wsdl.WSDLServiceException;
import org.ow2.dragon.api.to.specification.ServiceSpecificationTO;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.deployment.Endpoint;
import org.ow2.dragon.persistence.bo.deployment.Protocol;
import org.ow2.dragon.persistence.bo.deployment.TechnicalService;
import org.ow2.dragon.persistence.bo.deployment.Transport;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;
import org.ow2.dragon.persistence.dao.common.TModelDAO;
import org.ow2.dragon.persistence.dao.deployment.BindingDAO;
import org.ow2.dragon.persistence.dao.deployment.EndpointDAO;
import org.ow2.dragon.persistence.dao.deployment.ProtocolDAO;
import org.ow2.dragon.persistence.dao.deployment.TechnicalServiceDAO;
import org.ow2.dragon.persistence.dao.deployment.TransportDAO;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceInterfaceDAO;
import org.ow2.dragon.persistence.dao.specification.ServiceSpecificationDAO;
import org.ow2.dragon.service.CommonServiceConfig;
import org.ow2.dragon.service.util.JettyServer;
import org.ow2.dragon.util.InputStreamUtil;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.XMLUtil;
import org.springframework.test.annotation.ExpectedException;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={TransactionalTestExecutionListener.class, DependencyInjectionTestExecutionListener.class})
public class WSDLManagerImplTest
extends CommonServiceConfig {
    @Resource
    private TModelDAO tModelDAO;
    @Resource
    private ProtocolDAO protocolDAO;
    @Resource
    private TransportDAO transportDAO;
    @Resource
    private WSDLManager wsdlManager;
    @Resource
    private SimpleFileDAO simpleFileDAO;
    @Resource
    private EndpointDAO endpointDAO;
    @Resource
    private ServiceSpecificationDAO serviceSpecificationDAO;
    @Resource
    private ServiceInterfaceDAO serviceInterfaceDAO;
    @Resource
    private BindingDAO bindingDAO;
    @Resource
    private TechnicalServiceDAO technicalServiceDAO;
    private static JettyServer jettyServer = null;
    private static List<String> tModelsIds = new ArrayList<String>();
    private static List<String> protocolsIds = new ArrayList<String>();
    private static List<String> transportsIds = new ArrayList<String>();

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
        try {
            jettyServer = JettyServer.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @AfterClass
    public static void afterClass() {
        try {
            jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Before
    public void before() {
        TModel tModel1;
        for (String tModelsId : tModelsIds) {
            tModel1 = new TModel(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.tModelDAO.save((Object)tModel1);
        }
        for (String tModelsId : protocolsIds) {
            tModel1 = new Protocol(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.protocolDAO.save((Object)tModel1);
        }
        for (String tModelsId : transportsIds) {
            tModel1 = new Transport(null, false, null, null, null, null);
            tModel1.setId(tModelsId);
            this.transportDAO.save((Object)tModel1);
        }
    }

    public void createTestData() {
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testImportServiceDefFileFromStringNullValue() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String nullString = null;
        this.wsdlManager.importServiceDefFile(nullString);
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportServiceDefFileFromStringBadValue() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String nullString = "bad wsdl";
        this.wsdlManager.importServiceDefFile(nullString);
    }

    @Test
    public void testImportServiceDefFileFromString() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
    }

    @Test
    public void testImportServiceDefFileFromDocument() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException, SAXException {
        Document wsdlContent = XMLUtil.createDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportAbstractServiceDefFileFromDocument() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException, SAXException {
        Document wsdlContent = XMLUtil.createDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportServiceDefFileFromDocumentBadContent() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException, SAXException {
        Document wsdlContent = XMLUtil.createDocument();
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
    }

    @Test
    public void testImportServiceDefFileFromDocumentAndRelativeImports() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException, SAXException {
        Document wsdlContent = XMLUtil.createDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-with-import.wsdl"));
        Document wsdlImportContent = XMLUtil.createDocument((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        HashMap<String, Document> imports = new HashMap<String, Document>();
        imports.put("testservice-import.wsdl", wsdlImportContent);
        this.wsdlManager.importServiceDefFile(wsdlContent, imports, null);
        this.testAllCreatedEntities();
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testImportServiceDefFileFromDocumentNullValues() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException, SAXException {
        Document wsdlContent = null;
        this.wsdlManager.importServiceDefFile(wsdlContent, null, null);
        this.testAllCreatedEntities();
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportServiceDefFileFromStringWithBadImport() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-with-badImport.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
    }

    @Test
    public void testImportServiceDefFileFromStringWithImport() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-with-import.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
    }

    @Test
    public void testImportServiceDefFileFromStringAndMapWithRelativeImport() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-with-relative-import.wsdl"));
        String wsdlImportContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        HashMap<String, String> imports = new HashMap<String, String>();
        imports.put("testservice-import.wsdl", wsdlImportContent);
        this.wsdlManager.importServiceDefFile(wsdlContent, imports, null);
        this.testAllCreatedEntities();
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportServiceDefFileFromStringAndMapWithBadRelativeImport() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-with-relative-import.wsdl"));
        String wsdlImportContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-import.wsdl"));
        HashMap<String, String> imports = new HashMap<String, String>();
        imports.put("bad-import.wsdl", wsdlImportContent);
        this.wsdlManager.importServiceDefFile(wsdlContent, imports, null);
    }

    @Test
    public void testImportServiceDefFileFromClasspathURI() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        this.wsdlManager.importServiceDefFile(URI.create("classpath:testservice.wsdl"));
        this.testAllCreatedEntities();
    }

    @Test
    public void testImportServiceDefFileFromHttpURI() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        this.wsdlManager.importServiceDefFile(URI.create("http://localhost:8085/Repository?filename=testservice.wsdl"));
        this.testAllCreatedEntities();
    }

    @Test
    public void testImportServiceDefFileFromHttpURIWithRelativeImport() throws IOException, URISyntaxException, WSDLServiceException, TimeoutException {
        URI wsdlContent = URI.create("http://localhost:8085/Repository?filename=testservice-with-import.wsdl");
        URI wsdlImportContent = URI.create("http://localhost:8085/Repository?filename=testservice-import.wsdl");
        HashMap<String, URI> imports = new HashMap<String, URI>();
        imports.put("testservice-import.wsdl", wsdlImportContent);
        this.wsdlManager.importServiceDefFile(wsdlContent, imports, null);
        this.testAllCreatedEntities();
    }

    private void testAllCreatedEntities() {
        List wsdlFiles = this.simpleFileDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)wsdlFiles);
        WSDLManagerImplTest.assertEquals((int)1, (int)wsdlFiles.size());
        SimpleFile wsdFile = (SimpleFile)wsdlFiles.get(0);
        List serviceSpecifications = this.serviceSpecificationDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)serviceSpecifications);
        WSDLManagerImplTest.assertEquals((int)1, (int)serviceSpecifications.size());
        ServiceSpecification serviceSpecification = (ServiceSpecification)serviceSpecifications.get(0);
        WSDLManagerImplTest.assertNotNull((Object)serviceSpecification.getOverviewDocs());
        WSDLManagerImplTest.assertEquals((int)1, (int)serviceSpecification.getOverviewDocs().size());
        SimpleFile servSpecOverviewDoc = (SimpleFile)serviceSpecification.getOverviewDocs().get(0);
        WSDLManagerImplTest.assertEquals((String)wsdFile.getId(), (String)servSpecOverviewDoc.getId());
        WSDLManagerImplTest.assertNotNull((Object)serviceSpecification.getDescriptions());
        WSDLManagerImplTest.assertEquals((int)2, (int)serviceSpecification.getDescriptions().size());
        WSDLManagerImplTest.assertTrue((boolean)this.containsWSDLDescription(serviceSpecification.getDescriptions()));
        WSDLManagerImplTest.assertEquals((String)"{http://test.org/}Undefined", (String)serviceSpecification.getName().getName());
        List serviceInterfaces = this.serviceInterfaceDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)serviceInterfaces);
        WSDLManagerImplTest.assertEquals((int)1, (int)serviceInterfaces.size());
        ServiceInterface serviceInterface = (ServiceInterface)serviceInterfaces.get(0);
        WSDLManagerImplTest.assertEquals((String)"{http://test.org/}PhotoServiceSoap", (String)serviceInterface.getFullName());
        Set specifiedOps = serviceInterface.getSpecifiedOps();
        WSDLManagerImplTest.assertNotNull((Object)specifiedOps);
        WSDLManagerImplTest.assertEquals((int)3, (int)specifiedOps.size());
        this.allIntOpsRegistered(specifiedOps);
        Set serviceInterfacesInSpec = serviceSpecification.getServiceInterfaces();
        WSDLManagerImplTest.assertEquals((int)1, (int)serviceInterfacesInSpec.size());
        WSDLManagerImplTest.assertEquals((String)serviceInterfacesInSpec.toArray(new ServiceInterface[0])[0].getId(), (String)serviceInterface.getId());
        List bindings = this.bindingDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)bindings);
        WSDLManagerImplTest.assertEquals((int)2, (int)bindings.size());
        this.allBindingAndBindingOpsCreated(bindings);
        Set bindingsToInt = serviceInterface.getBindings();
        WSDLManagerImplTest.assertNotNull((Object)bindingsToInt);
        WSDLManagerImplTest.assertEquals((int)2, (int)bindingsToInt.size());
        WSDLManagerImplTest.assertTrue((String)"Bad bindings", (boolean)bindingsToInt.containsAll(bindings));
        this.allBindingLinkToTransportAndProtocol(bindings);
        Set bindingsToServSpec = serviceSpecification.getBindings();
        WSDLManagerImplTest.assertNotNull((Object)bindingsToServSpec);
        WSDLManagerImplTest.assertEquals((int)2, (int)bindingsToServSpec.size());
        WSDLManagerImplTest.assertTrue((String)"Bad bindings", (boolean)bindingsToServSpec.containsAll(bindings));
        List technicalServices = this.technicalServiceDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)technicalServices);
        WSDLManagerImplTest.assertEquals((int)1, (int)technicalServices.size());
        TechnicalService technicalService = (TechnicalService)technicalServices.get(0);
        WSDLManagerImplTest.assertEquals((String)"{http://test.org/}PhotoService", (String)technicalService.getFullName());
        Set endpoints = technicalService.getEndpoints();
        WSDLManagerImplTest.assertNotNull((Object)endpoints);
        WSDLManagerImplTest.assertEquals((int)2, (int)endpoints.size());
        this.allEpsCreated(endpoints, serviceSpecification);
        technicalService.getServiceSpecifications().contains(serviceSpecification);
    }

    private void allEpsCreated(Set<Endpoint> endpoints, ServiceSpecification serviceSpecification) {
        HashMap<String, String> epNameToBindingName = new HashMap<String, String>();
        for (Endpoint endpoint : endpoints) {
            epNameToBindingName.put(endpoint.getName(), endpoint.getBinding().getFullName());
            WSDLManagerImplTest.assertTrue((boolean)endpoint.getServiceSpecifications().contains(serviceSpecification));
        }
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap12"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap")).equals("{http://test.org/}PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap12")).equals("{http://test.org/}PhotoServiceSoap12"));
    }

    private void allBindingLinkToTransportAndProtocol(List<Binding> bindings) {
        Protocol soapProto = (Protocol)this.protocolDAO.get((Serializable)((Object)"uddi:uddi.org:protocol:soap"));
        Protocol soap12Proto = (Protocol)this.protocolDAO.get((Serializable)((Object)"uddi:dragon.org:protocol:soap12"));
        Transport httpTrans = (Transport)this.transportDAO.get((Serializable)((Object)"uddi:uddi.org:transport:http"));
        for (Binding binding : bindings) {
            Set protocols = binding.getProtocols();
            Set transports = binding.getTransports();
            if (binding.getFullName().equals("{http://test.org/}PhotoServiceSoap")) {
                WSDLManagerImplTest.assertTrue((protocols.size() == 1 ? 1 : 0) != 0);
                WSDLManagerImplTest.assertTrue((boolean)protocols.contains(soapProto));
                WSDLManagerImplTest.assertTrue((transports.size() == 1 ? 1 : 0) != 0);
                WSDLManagerImplTest.assertTrue((boolean)transports.contains(httpTrans));
            }
            if (!binding.getFullName().equals("{http://test.org/}PhotoServiceSoap12")) continue;
            WSDLManagerImplTest.assertTrue((protocols.size() == 1 ? 1 : 0) != 0);
            WSDLManagerImplTest.assertTrue((boolean)protocols.contains(soap12Proto));
            WSDLManagerImplTest.assertTrue((transports.size() == 1 ? 1 : 0) != 0);
            WSDLManagerImplTest.assertTrue((boolean)transports.contains(httpTrans));
        }
    }

    private void allBindingAndBindingOpsCreated(List<Binding> bindings) {
        HashMap bindingNameToOpsName = new HashMap();
        for (Binding binding : bindings) {
            ArrayList<String> bindingOpNames = new ArrayList<String>();
            Set bindingOperations = binding.getBindingOps();
            for (BindingOperation bindingOperation : bindingOperations) {
                bindingOpNames.add(bindingOperation.getSignature());
            }
            bindingNameToOpsName.put(binding.getFullName(), bindingOpNames);
        }
        WSDLManagerImplTest.assertTrue((boolean)bindingNameToOpsName.keySet().contains("{http://test.org/}PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)bindingNameToOpsName.keySet().contains("{http://test.org/}PhotoServiceSoap12"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap")).contains("{http://test.org/}GetSlides"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap")).contains("{http://test.org/}GetSlidesPhotos"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap")).contains("{http://test.org/}GetSlidesAS"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap12")).contains("{http://test.org/}GetSlides"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap12")).contains("{http://test.org/}GetSlidesPhotos"));
        WSDLManagerImplTest.assertTrue((boolean)((List)bindingNameToOpsName.get("{http://test.org/}PhotoServiceSoap12")).contains("{http://test.org/}GetSlidesAS"));
    }

    private void allIntOpsRegistered(Set<SpecifiedOperation> specifiedOps) {
        ArrayList<String> opNames = new ArrayList<String>();
        for (SpecifiedOperation specifiedOperation : specifiedOps) {
            opNames.add(specifiedOperation.getName());
        }
        WSDLManagerImplTest.assertTrue((boolean)opNames.contains("{http://test.org/}GetSlides"));
        WSDLManagerImplTest.assertTrue((boolean)opNames.contains("{http://test.org/}GetSlidesPhotos"));
        WSDLManagerImplTest.assertTrue((boolean)opNames.contains("{http://test.org/}GetSlidesAS"));
    }

    private boolean containsWSDLDescription(List<Description> descriptions) {
        boolean result = false;
        for (Description description : descriptions) {
            if (!"This is a test wsdl description".equalsIgnoreCase(description.getDescription())) continue;
            result = true;
        }
        return result;
    }

    @Test
    public void testImportServiceDefFileFromStringTwice() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        this.getHibernateSession().flush();
        String[] servCreated2 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertEquals((int)0, (int)servCreated2.length);
        this.getHibernateSession().flush();
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testImportServiceDefFileFromStringSameIntDiffIntOps() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String wsdlContent2 = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-sameInt-diffIntOps.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        this.getHibernateSession().flush();
        this.wsdlManager.importServiceDefFile(wsdlContent2);
        this.getHibernateSession().flush();
    }

    @Test
    public void testImportServiceDefFileFromStringSameBindingDiffBindingOpsOrProtocolOrTransport() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String wsdlContent2 = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-sameBinding-diffBindingOps.wsdl"));
        String wsdlContent3 = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-sameBinding-diffProtocol.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        String[] servCreated2 = this.wsdlManager.importServiceDefFile(wsdlContent2);
        WSDLManagerImplTest.assertEquals((int)0, (int)servCreated2.length);
        String[] servCreated3 = this.wsdlManager.importServiceDefFile(wsdlContent3);
        WSDLManagerImplTest.assertEquals((int)0, (int)servCreated3.length);
    }

    @Test
    public void testImportServiceDefFileFromStringSameServiceDiffEpsMore() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String wsdlContent2 = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-sameServ-diffEps-more.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servCreated1[0]));
        Set endpoints1 = service.getEndpoints();
        WSDLManagerImplTest.assertEquals((int)2, (int)endpoints1.size());
        this.allEpsCreated1(endpoints1);
        String[] servCreated2 = this.wsdlManager.importServiceDefFile(wsdlContent2);
        WSDLManagerImplTest.assertEquals((int)0, (int)servCreated2.length);
        TechnicalService service2 = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servCreated1[0]));
        Set endpoints2 = service2.getEndpoints();
        WSDLManagerImplTest.assertEquals((int)3, (int)endpoints2.size());
        this.allEpsCreated2(endpoints2);
    }

    private void allEpsCreated1(Set<Endpoint> endpoints) {
        HashMap<String, String> epNameToBindingName = new HashMap<String, String>();
        for (Endpoint endpoint : endpoints) {
            epNameToBindingName.put(endpoint.getName(), endpoint.getBinding().getFullName());
        }
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap12"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap")).equals("{http://test.org/}PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap12")).equals("{http://test.org/}PhotoServiceSoap12"));
    }

    private void allEpsCreated2(Set<Endpoint> endpoints) {
        HashMap<String, String> epNameToBindingName = new HashMap<String, String>();
        for (Endpoint endpoint : endpoints) {
            epNameToBindingName.put(endpoint.getName(), endpoint.getBinding().getFullName());
        }
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoap12"));
        WSDLManagerImplTest.assertTrue((boolean)epNameToBindingName.keySet().contains("PhotoServiceSoapMore"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap")).equals("{http://test.org/}PhotoServiceSoap"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoap12")).equals("{http://test.org/}PhotoServiceSoap12"));
        WSDLManagerImplTest.assertTrue((boolean)((String)epNameToBindingName.get("PhotoServiceSoapMore")).equals("{http://test.org/}PhotoServiceSoap12"));
    }

    @Test
    public void testImportServiceDefFileFromStringSameServiceDiffEpsLess() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        String wsdlContent2 = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-sameServ-diffEps-less.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servCreated1[0]));
        Set endpoints1 = service.getEndpoints();
        WSDLManagerImplTest.assertEquals((int)2, (int)endpoints1.size());
        this.allEpsCreated1(endpoints1);
        String[] servCreated2 = this.wsdlManager.importServiceDefFile(wsdlContent2);
        WSDLManagerImplTest.assertEquals((int)0, (int)servCreated2.length);
        TechnicalService service2 = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servCreated1[0]));
        Set endpoints2 = service2.getEndpoints();
        WSDLManagerImplTest.assertEquals((int)2, (int)endpoints2.size());
        this.allEpsCreated1(endpoints2);
    }

    @Test
    public void testImportServiceDefFileFromStringWithoutEps() throws WSDLServiceException, IOException, URISyntaxException, TimeoutException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice-without-endpoints.wsdl"));
        String[] servCreated1 = this.wsdlManager.importServiceDefFile(wsdlContent);
        WSDLManagerImplTest.assertNotNull((Object)servCreated1);
        WSDLManagerImplTest.assertEquals((int)1, (int)servCreated1.length);
        TechnicalService service = (TechnicalService)this.technicalServiceDAO.get((Serializable)((Object)servCreated1[0]));
        Set endpoints1 = service.getEndpoints();
        WSDLManagerImplTest.assertEquals((int)0, (int)endpoints1.size());
    }

    @Test
    public void testGetWsdlDescAsString() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
        List specs = this.serviceSpecificationDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)specs);
        WSDLManagerImplTest.assertEquals((int)1, (int)specs.size());
        String result = this.wsdlManager.getWsdlDescAsString(((ServiceSpecification)specs.get(0)).getId());
        WSDLManagerImplTest.assertEquals((String)wsdlContent, (String)result);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetWsdlDescAsStringNullValue() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getWsdlDescAsString(null);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetWsdlDescAsInputStreamNullValue() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getWsdlDesc(null);
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testGetWsdlDescAsStringBadId() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getWsdlDescAsString("");
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testGetWsdlDescAsInputStreamBadId() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getWsdlDesc("");
    }

    @Test
    public void testGetServSpecs() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        List serviceSpecificationTOs;
        String wsdlContent = StringHelper.toString((InputStream)InputStreamUtil.getInputStream((String)"classpath:testservice.wsdl"));
        this.wsdlManager.importServiceDefFile(wsdlContent);
        this.testAllCreatedEntities();
        List specs = this.serviceSpecificationDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)specs);
        WSDLManagerImplTest.assertEquals((int)1, (int)specs.size());
        List endpoints = this.endpointDAO.getAll();
        List services = this.technicalServiceDAO.getAll();
        WSDLManagerImplTest.assertNotNull((Object)endpoints);
        WSDLManagerImplTest.assertNotNull((Object)services);
        for (TechnicalService technicalService : services) {
            serviceSpecificationTOs = this.wsdlManager.getServSpecsForTechServ(technicalService.getId());
            WSDLManagerImplTest.assertNotNull((Object)serviceSpecificationTOs);
            WSDLManagerImplTest.assertEquals((int)1, (int)serviceSpecificationTOs.size());
            WSDLManagerImplTest.assertEquals((String)((ServiceSpecification)specs.get(0)).getId(), (String)((ServiceSpecificationTO)serviceSpecificationTOs.get(0)).getId());
        }
        for (Endpoint endpoint : endpoints) {
            serviceSpecificationTOs = this.wsdlManager.getServSpecsForEndpoint(endpoint.getId());
            WSDLManagerImplTest.assertNotNull((Object)serviceSpecificationTOs);
            WSDLManagerImplTest.assertEquals((int)1, (int)serviceSpecificationTOs.size());
            WSDLManagerImplTest.assertEquals((String)((ServiceSpecification)specs.get(0)).getId(), (String)((ServiceSpecificationTO)serviceSpecificationTOs.get(0)).getId());
        }
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetServSpecsForEpNullValue() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getServSpecsForEndpoint(null);
    }

    @Test
    @ExpectedException(value=NullPointerException.class)
    public void testGetServSpecsForServNullValue() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getServSpecsForTechServ(null);
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testGetServSpecsForEpBadId() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getServSpecsForEndpoint("");
    }

    @Test
    @ExpectedException(value=WSDLServiceException.class)
    public void testGetServSpecsForServBadId() throws WSDLServiceException, TimeoutException, IOException, URISyntaxException {
        this.wsdlManager.getServSpecsForTechServ("");
    }

    @Override
    @After
    public void after() {
        for (String tModelsId : tModelsIds) {
            this.tModelDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : protocolsIds) {
            this.protocolDAO.remove((Serializable)((Object)tModelsId));
        }
        for (String tModelsId : transportsIds) {
            this.transportDAO.remove((Serializable)((Object)tModelsId));
        }
    }

    static {
        protocolsIds.add("uddi:uddi.org:protocol:soap");
        protocolsIds.add("uddi:dragon.org:protocol:soap12");
        protocolsIds.add("uddi:uddi.org:protocol:http");
        transportsIds.add("uddi:uddi.org:transport:http");
        transportsIds.add("uddi:uddi.org:transport:smtp");
        transportsIds.add("uddi:uddi.org:transport:ftp");
        tModelsIds.add("uddi:uddi.org:wsdl:address");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:protocol");
        tModelsIds.add("uddi:uddi.org:wsdl:categorization:transport");
        tModelsIds.add("uddi:uddi.org:wsdl:porttypereference");
        tModelsIds.add("uddi:uddi.org:wsdl:types");
        tModelsIds.add("uddi:uddi.org:xml:localname");
        tModelsIds.add("uddi:uddi.org:xml:namespace");
        tModelsIds.add("uddi:uddi.org:categorization:types");
    }
}

