/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.CollectionOfElements;
import org.ow2.dragon.persistence.bo.common.Comment;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.bo.common.Rating;

@Entity(name="org.ow2.dragon.persistence.bo.common.CommunityObj")
@Inheritance(strategy=InheritanceType.JOINED)
public class CommunityObj
extends LinkedEntity {
    private static final long serialVersionUID = -173407239562343951L;
    private Set<Rating> ratings = new HashSet<Rating>();
    private List<Comment> comments = new ArrayList<Comment>();
    private Set<String> tags = new HashSet<String>();

    @OneToMany(cascade={CascadeType.ALL})
    public Set<Rating> getRatings() {
        return this.ratings;
    }

    public void setRatings(Set<Rating> ratings) {
        this.ratings = ratings;
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void addComment(Comment comment) {
        this.comments.add(comment);
    }

    @CollectionOfElements
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public boolean isTagged(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.ratings).append(this.comments).append(this.tags).toHashCode();
    }
}

