/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.lifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.ow2.dragon.persistence.bo.common.NonSearchableBaseObject;
import org.ow2.dragon.persistence.bo.lifecycle.Lifecycle;
import org.ow2.dragon.persistence.bo.lifecycle.LifecycleUnderStep;

@Entity(name="org.ow2.dragon.persistence.bo.administration.LifecycleStep")
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"lifecycle_id", "name"})})
public class LifecycleStep
extends NonSearchableBaseObject {
    private static final long serialVersionUID = -2625599605261739799L;
    private String name;
    private int idx;
    private Lifecycle lifecycle;
    private List<LifecycleUnderStep> listLifecycleUnderStep = new ArrayList<LifecycleUnderStep>();

    @Column(nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(nullable=false)
    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="lifecycleStep")
    public List<LifecycleUnderStep> getListLifecycleUnderStep() {
        return this.listLifecycleUnderStep;
    }

    public void setListLifecycleUnderStep(List<LifecycleUnderStep> listLifecycleUnderStep) {
        this.listLifecycleUnderStep = listLifecycleUnderStep;
    }

    public void addUnderStep(LifecycleUnderStep underStep) {
        this.getListLifecycleUnderStep().add(underStep);
    }

    public void removeUnderStep(LifecycleUnderStep underStep) {
        this.getListLifecycleUnderStep().remove((Object)underStep);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LifecycleStep)) {
            return false;
        }
        LifecycleStep castOther = (LifecycleStep)((Object)other);
        return new EqualsBuilder().append((Object)this.name, (Object)castOther.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("id", (Object)this.name).toString();
    }
}

