/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.ow2.dragon.persistence.bo.common.CategoryBag;
import org.ow2.dragon.persistence.bo.common.KeyedReference;
import org.ow2.dragon.persistence.bo.organization.DiscoveryUrl;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.Post;

@Entity(name="org.ow2.dragon.persistence.bo.organization.OrganizationUnit")
@Indexed
public class OrganizationUnit
extends Party {
    private static final long serialVersionUID = 2669421239273081631L;
    private boolean isLegalEntity;
    private List<DiscoveryUrl> discoveryUrls;
    private List<KeyedReference> identifierBag;
    @IndexedEmbedded
    private CategoryBag categoryBag;
    private Set<Party> parties = new HashSet<Party>();
    private Set<Post> posts = new HashSet<Post>();
    @Field(index=Index.TOKENIZED, store=Store.NO)
    private String type;

    public OrganizationUnit() {
        this.discoveryUrls = new ArrayList<DiscoveryUrl>();
        this.identifierBag = new ArrayList<KeyedReference>();
    }

    public void addIdentifier(KeyedReference keyedReference) {
        this.getIdentifierBag().add(keyedReference);
    }

    public void addParty(Party party) {
        this.getParties().add(party);
        party.setParentOrganization(this);
    }

    public void removeParty(Party party) {
        this.getParties().remove((Object)party);
        party.setParentOrganization(null);
    }

    public void addPost(Post post) {
        this.getPosts().add(post);
    }

    public void addDiscoveryUrl(DiscoveryUrl discoveryUrl) {
        this.getDiscoveryUrls().add(discoveryUrl);
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<DiscoveryUrl> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="parentOrganization")
    public Set<Party> getParties() {
        return this.parties;
    }

    @ManyToMany
    public Set<Post> getPosts() {
        return this.posts;
    }

    public String getType() {
        return this.type;
    }

    public boolean isLegalEntity() {
        return this.isLegalEntity;
    }

    public void removePost(Post post) {
        this.getPosts().remove((Object)post);
    }

    public void setDiscoveryUrls(List<DiscoveryUrl> discoveryUrls) {
        this.discoveryUrls = discoveryUrls;
    }

    public void setLegalEntity(boolean isLegalEntity) {
        this.isLegalEntity = isLegalEntity;
    }

    public void setParties(Set<Party> parties) {
        this.parties = parties;
    }

    public void setPosts(Set<Post> posts) {
        this.posts = posts;
    }

    public void setType(String type) {
        this.type = type;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="OrgaUnit_KeyedRef")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<KeyedReference> getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(List<KeyedReference> identifierBag) {
        this.identifierBag = identifierBag;
    }

    @OneToOne(cascade={CascadeType.ALL})
    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("discoveryUrls", this.discoveryUrls).append("categoryBag", (Object)this.categoryBag).append("type", (Object)this.type).append("identifierBag", this.identifierBag).append("isLegalEntity", this.isLegalEntity).append("posts", this.posts).append("parties", this.parties).toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof OrganizationUnit)) {
            return false;
        }
        OrganizationUnit castOther = (OrganizationUnit)((Object)other);
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.identifierBag, castOther.identifierBag).append((Object)this.type, (Object)castOther.type).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.identifierBag).append((Object)this.type).toHashCode();
    }
}

