/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.ow2.dragon.persistence.bo.common.Description;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.bo.common.Name;
import org.ow2.dragon.persistence.bo.organization.Address;
import org.ow2.dragon.persistence.bo.organization.Email;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;

@Entity(name="org.ow2.dragon.persistence.bo.organization.Party")
@Inheritance(strategy=InheritanceType.JOINED)
public class Party
extends LinkedEntity {
    private static final long serialVersionUID = 4264025768507516327L;
    @IndexedEmbedded
    private List<Description> descriptions = new ArrayList<Description>();
    private List<Email> emailAddresses = new ArrayList<Email>();
    private boolean isExternal;
    private OrganizationUnit parentOrganization;
    private String responsabilities;
    private List<Address> addresses = new ArrayList<Address>();

    public void addAddress(Address address) {
        this.getAddresses().add(address);
    }

    public void addEmail(Email email) {
        this.getEmailAddresses().add(email);
    }

    public void addDescription(Description description) {
        this.getDescriptions().add(description);
    }

    public void addName(Name name) {
        this.getNames().add(name);
    }

    @ManyToOne
    @IndexedEmbedded(depth=7)
    public OrganizationUnit getParentOrganization() {
        return this.parentOrganization;
    }

    public String getResponsabilities() {
        return this.responsabilities;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setParentOrganization(OrganizationUnit parentOrganization) {
        this.parentOrganization = parentOrganization;
    }

    public void setResponsabilities(String responsabilities) {
        this.responsabilities = responsabilities;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<Email> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<Email> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @IndexedEmbedded
    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("addresses", this.addresses).append("isExternal", this.isExternal).append("descriptions", this.descriptions).append("responsabilities", (Object)this.responsabilities).append("emailAddresses", this.emailAddresses).toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Party)) {
            return false;
        }
        Party castOther = (Party)((Object)other);
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.emailAddresses, castOther.emailAddresses).append(this.addresses, castOther.addresses).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.emailAddresses).append(this.addresses).toHashCode();
    }
}

