/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.organization;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.bo.organization.PhoneNumber;
import org.ow2.dragon.persistence.bo.organization.Post;

@Entity(name="org.ow2.dragon.persistence.bo.organization.Person")
@Indexed
public class Person
extends Party {
    private static final long serialVersionUID = -1325593703523178955L;
    private String firstName;
    private String lastName;
    private String location;
    private String middleName;
    @IndexedEmbedded
    private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
    private Post post;
    private String title;
    private boolean contact;

    public void addPhoneNumber(PhoneNumber phoneNumber) {
        this.getPhoneNumbers().add(phoneNumber);
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    public String getFirstName() {
        return this.firstName;
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    public String getLastName() {
        return this.lastName;
    }

    public String getLocation() {
        return this.location;
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    public String getMiddleName() {
        return this.middleName;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @ManyToOne
    @IndexedEmbedded
    public Post getPost() {
        return this.post;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setPhoneNumbers(List<PhoneNumber> phoneNumber) {
        this.phoneNumbers = phoneNumber;
    }

    public void setPost(Post post) {
        this.post = post;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("title", (Object)this.title).append("posts", (Object)this.post).append("phoneNumbers", this.phoneNumbers).append("middleName", (Object)this.middleName).append("location", (Object)this.location).append("firstName", (Object)this.firstName).append("lastName", (Object)this.lastName).append("contact", this.contact).toString();
    }

    public boolean isContact() {
        return this.contact;
    }

    public void setContact(boolean contact) {
        this.contact = contact;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Person)) {
            return false;
        }
        Person castOther = (Person)((Object)other);
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.firstName, (Object)castOther.firstName).append((Object)this.lastName, (Object)castOther.lastName).append((Object)this.middleName, (Object)castOther.middleName).append((Object)this.title, (Object)castOther.title).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.firstName).append((Object)this.lastName).append((Object)this.middleName).append((Object)this.title).toHashCode();
    }
}

