/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cascade;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.ow2.dragon.persistence.bo.common.TModel;
import org.ow2.dragon.persistence.bo.deployment.Binding;
import org.ow2.dragon.persistence.bo.specification.ServiceSpecification;
import org.ow2.dragon.persistence.bo.specification.SpecifiedOperation;

@Entity(name="org.ow2.dragon.persistence.bo.specification.ServiceInterface")
public class ServiceInterface
extends TModel {
    private static final long serialVersionUID = 4970986248323341443L;
    private Set<Binding> bindings;
    private String fullName;
    private Set<ServiceSpecification> serviceSpecs;
    private Set<SpecifiedOperation> specifiedOps = new HashSet<SpecifiedOperation>();

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ServiceInterface)) {
            return false;
        }
        ServiceInterface castOther = (ServiceInterface)((Object)other);
        return new EqualsBuilder().append((Object)this.fullName, (Object)castOther.fullName).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fullName).toHashCode();
    }

    public ServiceInterface() {
        this.bindings = new HashSet<Binding>();
        this.serviceSpecs = new HashSet<ServiceSpecification>();
    }

    public void addBinding(Binding binding) {
        this.getBindings().add(binding);
        binding.setServiceInterface(this);
    }

    public void removeBinding(Binding binding) {
        this.getBindings().remove((Object)binding);
        binding.setServiceInterface(null);
    }

    public void addSpecifiedOp(SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().add(specifiedOperation);
        specifiedOperation.setServiceInterface(this);
    }

    public void removeSpecifiedOp(SpecifiedOperation specifiedOperation) {
        this.getSpecifiedOps().remove((Object)specifiedOperation);
        specifiedOperation.setServiceInterface(null);
    }

    public void addServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecs().add(serviceSpecification);
        serviceSpecification.getServiceInterfaces().add(this);
    }

    public void removeServiceSpec(ServiceSpecification serviceSpecification) {
        this.getServiceSpecs().remove((Object)serviceSpecification);
        serviceSpecification.getServiceInterfaces().remove((Object)this);
    }

    @OneToMany(mappedBy="serviceInterface")
    public Set<Binding> getBindings() {
        return this.bindings;
    }

    public String getFullName() {
        return this.fullName;
    }

    @ManyToMany(mappedBy="serviceInterfaces")
    public Set<ServiceSpecification> getServiceSpecs() {
        return this.serviceSpecs;
    }

    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="ServInterface_SpecOperation")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @IndexedEmbedded
    public Set<SpecifiedOperation> getSpecifiedOps() {
        return this.specifiedOps;
    }

    public void setBindings(Set<Binding> bindings) {
        this.bindings = bindings;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setServiceSpecs(Set<ServiceSpecification> serviceSpecs) {
        this.serviceSpecs = serviceSpecs;
    }

    public void setSpecifiedOps(Set<SpecifiedOperation> specifiedOps) {
        this.specifiedOps = specifiedOps;
    }
}

