/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.specification;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.ow2.dragon.persistence.bo.common.SearchableBaseObject;
import org.ow2.dragon.persistence.bo.deployment.BindingOperation;
import org.ow2.dragon.persistence.bo.specification.ServiceInterface;

@Entity(name="org.ow2.dragon.persistence.bo.specification.SpecifiedOperation")
public class SpecifiedOperation
extends SearchableBaseObject {
    private static final long serialVersionUID = 319403999125489629L;
    private Set<BindingOperation> bindingOps = new HashSet<BindingOperation>();
    private boolean canParticipateInTransaction;
    private boolean isAtomicTransaction;
    private boolean isNonUpdating;
    private boolean isTransactionCoordNeeded;
    private String name;
    private String signature;
    private String purpose;
    private ServiceInterface serviceInterface;
    private String transactionCoordIsBy;
    private OpTmType transmission;

    public void addBindingOp(BindingOperation bindingOperation) {
        this.getBindingOps().add(bindingOperation);
        bindingOperation.setSpecifiedOp(this);
    }

    public void removeBindingOp(BindingOperation bindingOperation) {
        this.getBindingOps().remove((Object)bindingOperation);
        bindingOperation.setSpecifiedOp(null);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SpecifiedOperation)) {
            return false;
        }
        SpecifiedOperation castOther = (SpecifiedOperation)((Object)other);
        return new EqualsBuilder().append((Object)this.signature, (Object)castOther.signature).isEquals();
    }

    @OneToMany(mappedBy="specifiedOp")
    public Set<BindingOperation> getBindingOps() {
        return this.bindingOps;
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    public String getName() {
        return this.name;
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    @Lob
    @Column(length=0x100000)
    public String getPurpose() {
        return this.purpose;
    }

    @ManyToOne
    @JoinColumn(name="serviceIntId", nullable=false)
    public ServiceInterface getServiceInterface() {
        return this.serviceInterface;
    }

    public String getTransactionCoordIsBy() {
        return this.transactionCoordIsBy;
    }

    @Enumerated(value=EnumType.STRING)
    public OpTmType getTransmission() {
        return this.transmission;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.signature).toHashCode();
    }

    public boolean isAtomicTransaction() {
        return this.isAtomicTransaction;
    }

    public boolean isCanParticipateInTransaction() {
        return this.canParticipateInTransaction;
    }

    public boolean isNonUpdating() {
        return this.isNonUpdating;
    }

    public boolean isTransactionCoordNeeded() {
        return this.isTransactionCoordNeeded;
    }

    public void setAtomicTransaction(boolean isAtomicTransaction) {
        this.isAtomicTransaction = isAtomicTransaction;
    }

    public void setBindingOps(Set<BindingOperation> bindingOps) {
        this.bindingOps = bindingOps;
    }

    public void setCanParticipateInTransaction(boolean canParticipateInTransaction) {
        this.canParticipateInTransaction = canParticipateInTransaction;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNonUpdating(boolean isNonUpdating) {
        this.isNonUpdating = isNonUpdating;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void setServiceInterface(ServiceInterface serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public void setTransactionCoordIsBy(String transactionCoordIsBy) {
        this.transactionCoordIsBy = transactionCoordIsBy;
    }

    public void setTransactionCoordNeeded(boolean isTransactionCoordNeeded) {
        this.isTransactionCoordNeeded = isTransactionCoordNeeded;
    }

    public void setTransmission(OpTmType transmission) {
        this.transmission = transmission;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("transmission", (Object)this.transmission).append("canParticipateInTransaction", this.canParticipateInTransaction).append("bindingOps", this.bindingOps).append("transactionCoordIsBy", (Object)this.transactionCoordIsBy).append("purpose", (Object)this.purpose).append("isNonUpdating", this.isNonUpdating).append("isTransactionCoordNeeded", this.isTransactionCoordNeeded).append("isAtomicTransaction", this.isAtomicTransaction).append("name", (Object)this.name).toString();
    }

    @Column(length=0x100000)
    @Lob
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public static enum OpTmType {
        NOTIFICATION,
        ONEWAY,
        REQUEST_RESPONSE,
        SOLICIT_RESPONSE,
        UNKNOWN;

    }

    public static enum OpStyleType {
        DOCUMENT,
        PARAMETERS,
        UNKNOWN;

    }
}

