/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.bo.technology;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.search.annotations.Indexed;
import org.ow2.dragon.persistence.bo.technology.ExecutionEnvironment;
import org.ow2.dragon.persistence.bo.technology.Node;

@Entity(name="org.ow2.dragon.persistence.bo.technology.Processor")
@Inheritance(strategy=InheritanceType.JOINED)
@Indexed
public class Processor
extends Node {
    private static final long serialVersionUID = 5901811128718172427L;
    private Set<ExecutionEnvironment> executionEnvs = new HashSet<ExecutionEnvironment>();

    @OneToMany(mappedBy="hostProcessor")
    public Set<ExecutionEnvironment> getExecutionEnvs() {
        return this.executionEnvs;
    }

    public void setExecutionEnvs(Set<ExecutionEnvironment> executionEnvs) {
        this.executionEnvs = executionEnvs;
    }

    public void addExecutionEnvironment(ExecutionEnvironment execEnv) {
        this.getExecutionEnvs().add(execEnv);
        execEnv.setHostProcessor(this);
    }

    public void removeExecutionEnvironment(ExecutionEnvironment execEnv) {
        this.getExecutionEnvs().remove((Object)execEnv);
        execEnv.setHostProcessor(null);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append((Object)super.toString()).append("executionEnvs", this.executionEnvs).toString();
    }
}

