/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.metadata.hibernate;

import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import com.trg.search.Filter;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.Sort;
import com.trg.search.hibernate.HibernateSearchProcessor;
import java.util.List;
import org.hibernate.SessionFactory;
import org.ow2.dragon.persistence.bo.metadata.SimpleFile;
import org.ow2.dragon.persistence.dao.metadata.SimpleFileDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="simpleFileDAO")
public class SimpleFileDAOImpl
extends GenericHibernateDAOImpl<SimpleFile, String>
implements SimpleFileDAO {
    @Autowired
    public SimpleFileDAOImpl(@Qualifier(value="sessionFactory") SessionFactory factory) {
        super(factory);
    }

    public List<SimpleFile> searchEquals(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "=");
    }

    public List<SimpleFile> searchLike(String[] criteria, String[] properties, RequestOptions requestOptions) {
        return this.search(criteria, properties, requestOptions, "like");
    }

    private List<SimpleFile> search(String[] criteria, String[] properties, RequestOptions requestOptions, String predicate) {
        HibernateSearchProcessor searchProcessor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)this.getSessionFactory());
        ISearch search = SimpleFileDAOImpl.createSearchContext(this.type, criteria, properties, requestOptions, predicate);
        return searchProcessor.search(this.getSession(), search);
    }

    private static ISearch createSearchContext(Class<?> clazz, String[] criterii, String[] properties, RequestOptions requestOptions, String predicate) {
        Search search = new Search();
        search.setSearchClass(clazz);
        search.setDistinct(false);
        if (criterii != null && properties != null && criterii.length > 0 && properties.length > 0) {
            for (String criteria : criterii) {
                Filter filter = Filter.or((Filter[])new Filter[0]);
                for (String property : properties) {
                    if ("=".equalsIgnoreCase(predicate)) {
                        if (requestOptions != null && requestOptions.isCaseSensitive()) {
                            filter.add(Filter.equal((String)property, (Object)criteria));
                            continue;
                        }
                        filter.add(Filter.equal((String)property, (Object)criteria));
                        continue;
                    }
                    if (!"like".equalsIgnoreCase(predicate)) continue;
                    if (requestOptions != null && requestOptions.isCaseSensitive()) {
                        filter.add(Filter.like((String)property, (String)("%" + criteria + "%")));
                        continue;
                    }
                    filter.add(Filter.ilike((String)property, (String)("%" + criteria + "%")));
                }
                search.addFilterAnd(new Filter[]{filter});
            }
        }
        if (requestOptions != null) {
            if (requestOptions.hasPagination()) {
                search.setFirstResult(requestOptions.getFirstResult());
                search.setMaxResults(requestOptions.getNbOfResults());
            }
            if (requestOptions.hasSortOption()) {
                Sort sort = new Sort();
                sort.setProperty(requestOptions.getSortCriteria());
                if (requestOptions.isSortAscendingly()) {
                    sort.setDesc(false);
                } else {
                    sort.setDesc(true);
                }
                search.addSort(sort);
            }
            if (requestOptions.hasFetchOption()) {
                search.addFetch(requestOptions.getFetchCriteria());
            }
        }
        return search;
    }
}

