/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.dao.organization.hibernate;

import com.ebmwebsourcing.webcommons.persistence.dao.DAOLayerException;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.ow2.dragon.persistence.bo.organization.OrganizationUnit;
import org.ow2.dragon.persistence.bo.organization.Party;
import org.ow2.dragon.persistence.dao.organization.OrganizationUnitDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="organizationUnitDAO")
public class OrganizationUnitDAOImpl
extends GenericHibernateDAOImpl<OrganizationUnit, String>
implements OrganizationUnitDAO {
    @Autowired
    public OrganizationUnitDAOImpl(@Qualifier(value="sessionFactory") SessionFactory factory) {
        super(factory);
    }

    @Override
    public OrganizationUnit getOrgUnitByNameAndCity(String name, String city) {
        Search search = new Search();
        search.addFilterAnd(new Filter[]{Filter.some((String)"names", (Filter)Filter.equal((String)"name", (Object)name)), Filter.some((String)"addresses", (Filter)Filter.some((String)"addressLines", (Filter)Filter.and((Filter[])new Filter[]{Filter.equal((String)"keyName", (Object)"city"), Filter.equal((String)"addressLine", (Object)city)})))});
        return (OrganizationUnit)this.searchUnique((IMutableSearch)search);
    }

    @Override
    public List<OrganizationUnit> getOrgAndChildren(String initialOrgId) {
        ArrayList<OrganizationUnit> result = new ArrayList<OrganizationUnit>();
        OrganizationUnit initialOrg = (OrganizationUnit)this.get((Serializable)((Object)initialOrgId));
        this.addChildOrg(result, initialOrg);
        return result;
    }

    @Override
    public List<OrganizationUnit> getAllWithoutMeAndMyChildren(String initialOrgId) throws DAOLayerException {
        ArrayList<OrganizationUnit> result = new ArrayList<OrganizationUnit>();
        OrganizationUnit initialOrg = (OrganizationUnit)this.get((Serializable)((Object)initialOrgId));
        if (initialOrg == null) {
            throw new DAOLayerException("No initial organization found for the given id: " + initialOrgId);
        }
        this.addChildOrg(result, initialOrg);
        ArrayList<String> idsToExclude = new ArrayList<String>();
        for (OrganizationUnit org : result) {
            idsToExclude.add(org.getId());
        }
        Search search = new Search();
        search.addFilterNotIn("id", idsToExclude);
        search.addFetch("names");
        search.addSortAsc("names.name");
        return this.search((IMutableSearch)search);
    }

    private void addChildOrg(List<OrganizationUnit> result, OrganizationUnit initialOrg) {
        Set<Party> parties;
        result.add(initialOrg);
        if (initialOrg != null && (parties = initialOrg.getParties()) != null && !parties.isEmpty()) {
            for (Party party : parties) {
                if (!(party instanceof OrganizationUnit)) continue;
                this.addChildOrg(result, (OrganizationUnit)party);
            }
        }
    }
}

