/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.persistence.util;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.ow2.dragon.util.RegistryConfig;
import org.ow2.dragon.util.StringHelper;
import org.ow2.dragon.util.UDDIStandardTModelKeys;

public class UDDIIdentifierGenerator
implements IdentifierGenerator {
    public static final String UDDI_V3_SCHEME = "uddi";
    public static final String UDDI_V2_SCHEME = "uuid";
    private static final String PARTITION_SEPARATOR = ":";
    private static final String ROOT_DOMAIN = "root.domain";
    private Logger log = Logger.getLogger(UDDIIdentifierGenerator.class);

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        Object id = session.getEntityPersister(null, object).getIdentifier(object, session.getEntityMode());
        if (id == null || id instanceof String && StringHelper.isNullOrEmpty((String)((String)id))) {
            id = UDDIIdentifierGenerator.getUddiV3KeyPrefix() + this.getUUID();
        }
        return id;
    }

    private synchronized String getUUID() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGUID(SessionImplementor session) {
        String string;
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement st = session.getBatcher().prepareSelectStatement(sql);
        try {
            String result;
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = rs.getString(1);
            }
            finally {
                rs.close();
            }
            this.log.debug((Object)("GUID identifier generated: " + result));
            string = result;
        }
        catch (Throwable throwable) {
            try {
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw JDBCExceptionHelper.convert((SQLExceptionConverter)session.getFactory().getSQLExceptionConverter(), (SQLException)sqle, (String)"could not retrieve GUID", (String)sql);
            }
        }
        session.getBatcher().closeStatement(st);
        return string;
    }

    public static String toUddiV2Id(String uddiV3Id) {
        String v2Key = null;
        if (!StringHelper.isNullOrEmpty((String)uddiV3Id) && (v2Key = (String)UDDIStandardTModelKeys.UDDIV2TOV3KEY.getKey((Object)(uddiV3Id = uddiV3Id.toLowerCase()))) == null) {
            if (!uddiV3Id.startsWith(UDDIIdentifierGenerator.getUddiV3KeyPrefix())) {
                throw new HibernateException("Trying to use an invalid uddi v3 key ('" + uddiV3Id + "'). Valid v3 key for this registry are: '" + UDDIIdentifierGenerator.getUddiV3KeyPrefix() + "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'");
            }
            v2Key = UDDIIdentifierGenerator.getUddiV2KeyPrefix() + uddiV3Id.substring(UDDIIdentifierGenerator.getUddiV3KeyPrefix().length());
        }
        return v2Key;
    }

    private static String getUddiV3KeyPrefix() {
        String rootDomain = "";
        try {
            rootDomain = RegistryConfig.getConfiguration().getString(ROOT_DOMAIN);
        }
        catch (ConfigurationException ce) {
            throw new HibernateException("Can't retrieve root.domain property from registry config file", (Throwable)ce);
        }
        return "uddi:" + rootDomain + PARTITION_SEPARATOR;
    }

    private static String getUddiV2KeyPrefix() {
        return "uuid:";
    }

    public static String toUddiV3Id(String uddiV2Id) {
        String v3Key = null;
        if (!StringHelper.isNullOrEmpty((String)uddiV2Id) && (v3Key = (String)UDDIStandardTModelKeys.UDDIV2TOV3KEY.get((Object)(uddiV2Id = uddiV2Id.toLowerCase()))) == null) {
            if (!uddiV2Id.startsWith(UDDIIdentifierGenerator.getUddiV2KeyPrefix())) {
                throw new HibernateException("Trying to use an invalid uddi v2 key ('" + uddiV2Id + "'). Valid v2 key are: '" + UDDIIdentifierGenerator.getUddiV2KeyPrefix() + "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx'");
            }
            v3Key = UDDIIdentifierGenerator.getUddiV3KeyPrefix() + uddiV2Id.substring(UDDIIdentifierGenerator.getUddiV2KeyPrefix().length());
        }
        return v3Key;
    }

    public static boolean isUddiV3ValidId(String uddiV3Id) {
        boolean result = UDDIStandardTModelKeys.UDDIV2TOV3KEY.containsValue((Object)uddiV3Id);
        if (!result) {
            result = uddiV3Id.startsWith(UDDIIdentifierGenerator.getUddiV3KeyPrefix());
        }
        return result;
    }
}

