/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.administration;

import javax.annotation.Resource;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.api.service.administration.RoleManager;
import org.ow2.dragon.persistence.bo.administration.Role;
import org.ow2.dragon.persistence.dao.administration.RoleDAO;
import org.ow2.dragon.service.administration.EnumRoles;
import org.springframework.stereotype.Service;

@Service(value="roleManager")
public class RoleManagerImpl
implements RoleManager {
    @Resource
    private RoleDAO roleDAO;

    @Override
    public void init() {
        for (EnumRoles enumRole : EnumRoles.values()) {
            String name = enumRole.toString();
            this.createRole(name);
        }
    }

    @Override
    @CheckAllArgumentsNotNull
    public void createRole(String roleName) {
        Role role = this.roleDAO.getRoleByName(roleName);
        if (role == null) {
            role = new Role();
            role.setName(roleName);
            this.roleDAO.save((Object)role);
        }
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }
}

