/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dragon.service.common;

import com.ebmwebsourcing.webcommons.persistence.dao.util.RequestOptions;
import com.trg.search.Filter;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.ow2.dragon.aop.annotation.CheckAllArgumentsNotNull;
import org.ow2.dragon.aop.annotation.CheckArgumentsNotNull;
import org.ow2.dragon.api.service.common.CommonException;
import org.ow2.dragon.api.service.common.EntityLinkManager;
import org.ow2.dragon.api.to.RequestOptionsTO;
import org.ow2.dragon.persistence.bo.common.Link;
import org.ow2.dragon.persistence.bo.common.LinkedEntity;
import org.ow2.dragon.persistence.dao.common.LinkDAO;
import org.ow2.dragon.persistence.dao.common.LinkedEntityDAO;
import org.ow2.dragon.service.TransfertObjectAssembler;
import org.springframework.stereotype.Service;

@Service(value="entityLinkManager")
public class EntityLinkManagerImpl
implements EntityLinkManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Resource
    private LinkDAO linkDAO;
    @Resource
    private LinkedEntityDAO linkedEntityDAO;
    @Resource
    private TransfertObjectAssembler transfertObjectAssembler;

    @Override
    @CheckAllArgumentsNotNull
    public String createLink(String fromId, String toId, String type) throws CommonException {
        Link link = this.linkExist(fromId, toId, type);
        if (link != null) {
            this.logger.debug((Object)("Link already exist : " + link.toString() + ". Skip creation !"));
        } else {
            LinkedEntity from = this.retrieveLinkableEntity(fromId);
            LinkedEntity to = this.retrieveLinkableEntity(toId);
            link = new Link();
            link.setType(type);
            from.addFromLink(link);
            to.addToLink(link);
            this.linkDAO.save((Object)link);
        }
        return link.getId();
    }

    private Link linkExist(String fromId, String toId, String type) {
        Search search = new Search();
        search.addFilter(Filter.equal((String)"from.id", (Object)fromId));
        search.addFilter(Filter.equal((String)"to.id", (Object)toId));
        search.addFilter(Filter.equal((String)"type", (Object)type));
        return (Link)((Object)this.linkDAO.searchUnique((IMutableSearch)search));
    }

    private LinkedEntity retrieveLinkableEntity(String linkableId) throws CommonException {
        LinkedEntity linkable = (LinkedEntity)((Object)this.linkedEntityDAO.get((Serializable)((Object)linkableId)));
        if (linkable == null) {
            throw new CommonException("One of the link end doesn't exist. Id: " + linkableId);
        }
        return linkable;
    }

    @Override
    @CheckAllArgumentsNotNull
    public void removeLink(String linkId) {
        this.linkDAO.remove((Serializable)((Object)linkId));
    }

    @Override
    @CheckArgumentsNotNull
    public List<Link> getAllLinksForFrom(String fromId, RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.transfertObjectAssembler.toLinkRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List links = this.linkDAO.searchEquals(new String[]{fromId}, new String[]{"from.id"}, requestOptions);
        return links;
    }

    @Override
    @CheckArgumentsNotNull
    public List<Link> getAllLinksForTo(String toId, RequestOptionsTO requestOptionsTO) {
        RequestOptions requestOptions = this.transfertObjectAssembler.toLinkRequestOptions(requestOptionsTO);
        if (requestOptions != null) {
            requestOptions.setCaseSensitive(true);
        }
        List links = this.linkDAO.searchEquals(new String[]{toId}, new String[]{"to.id"}, requestOptions);
        return links;
    }
}

